
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"

int	cps_typ::RunDDS( )
{
	Int4	arg,i,j,k,x;
	FILE	*fp=0;
#if 1
  if(0 && NN > 50){	// then randomly sample a smaller set of sequences...
	pdb_typ *P;
	char *Chn,**RX,**RY;
	Int4 *AX,*AY;
        char **pID;
	
	Int4	nn=MINIMUM(Int4,NN,50);
	NEW(P,nn + 3,pdb_typ);
	NEW(Chn,nn + 3,char);
	NEWP(RX,nn + 3,char); NEWP(RY,nn + 3,char);
	NEW(AX,nn + 3,Int4); NEW(AY,nn + 3,Int4);
	NEWP(pID,nn + 3,char);
	dh_type dH=dheap(NN+2,3);
	for(i=1; i <= NN; i++) insrtHeap(i,(keytyp)Random(),dH);
	for(Int4 run=1; run <= 30; run++){
	   if(ItemsInHeap(dH) > 5){ 
	     for(i=1; i <= nn; i++){
		if(emptyHeap(dH)) break;
		Int4 x=delminHeap(dH);
		P[i]=PDB[x]; Chn[i]=CHN[x]; RX[i]=ResX[x]; RY[i]=ResY[x];
		AX[i]=AdjstX[x]; AY[i]=AdjstY[x]; 
		pID[i]=PDBID[x]; 
	     }
	     P[i]=0; Chn[i]=0; RX[i]=0; RY[i]=0; AX[i]=0; AY[i]=0; pID[i]=0;
	     dds_typ *dds = new dds_typ(P,Chn,RX,RY,AX,AY,pID);
	     // free(stdev[1]); free(stdev[2]); free(stdev);
	     stdev=dds->Put(outfp,cutoff); delete dds;
	   }
	} Nildheap(dH);
	free(P); free(Chn); free(RX); free(RY); free(AX); free(AY); 
  } else 
#endif
  {
	if(NN == 0) print_error("ERROR: no common structural alignments");
	dds_typ *dds= new dds_typ(PDB,CHN,ResX,ResY,AdjstX,AdjstY,PDBID,verbose);
	stdev=dds->Put(outfp,cutoff);
	// free(stdev[1]); free(stdev[2]); free(stdev);
	delete dds;
#if 0	// recalculate distribution after removing outliers
	Int4 nn,nN=NN,*n2N; 
	double **tmp=stdev;
	while(0){
	  NEW(n2N,nN+3,Int4);
	  for(nn=0,i=1; i <= nN; i++){
	     if(tmp[1][i] < cutoff && tmp[2][i] < cutoff){
		nn++; n2N[nn]=i;
	     }
	  }
	  if(nn < nN){
	   pdb_typ *P; NEW(P,nn + 3,pdb_typ);
	   char *Chn,**RX,**RY;
	   NEW(Chn,nn + 3,char); NEWP(RX,nn + 3,char); NEWP(RY,nn + 3,char);
	   Int4 *AX,*AY; NEW(AX,nn + 3,Int4); NEW(AY,nn + 3,Int4);
           char **pID; NEWP(pID,nn + 3,char);
	   for(i=1; i <= nn; i++){
		x=n2N[i];
		P[i]=PDB[x]; Chn[i]=CHN[x]; RX[i]=ResX[x]; RY[i]=ResY[x];
		AX[i]=AdjstX[x]; AY[i]=AdjstY[x]; 
		pID[i]=PDBID[x]; 
	   }
	   P[i]=0; Chn[i]=0; RX[i]=0; RY[i]=0; AX[i]=0; AY[i]=0; pID[i]=0;
	   dds_typ *dds = new dds_typ(P,Chn,RX,RY,AX,AY,pID);
	   if(nN != NN && tmp != stdev){ free(tmp[1]); free(tmp[2]); free(tmp); }
	   tmp=dds->Put(outfp,cutoff); delete dds;
	   free(P); free(Chn); free(RX); free(RY); free(AX); free(AY); 
	   free(n2N); nN=nn;
	  } else { 
	   if(nN != NN && tmp != stdev){ free(tmp[1]); free(tmp[2]); free(tmp); }
	   free(n2N); nN=nn; break; 
	  }
	}
#endif
  }
	return 0;
}

