
/******************************************************************************************
    Copyright (C) 1997-2019 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of
    this software and associated documentation files (the "Software"), to deal in the
    Software without restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the
    following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cps_typ.h"
#include "compass_usage.h"


void	cps_typ::RunDCA()
{
	FILE	*fp=0,*dfp=0,*tfp=0;
	//====================================================================
	fprintf(stderr,"==== Running CCMpred on each MSA ====\n");
	//====================================================================
	//================ remove old files if present. ==================
#if 1	// turning this off does not prevent core dump
	sprintf(str,"%s_X_sprc_X.dca",argv[1]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }
	sprintf(str,"%s_X_sprc_X.mst",argv[1]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }

	sprintf(str,"%s_X_sprc_X.dca",argv[2]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }
	sprintf(str,"%s_X_sprc_X.mst",argv[2]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }
#endif

#if 1	// turning this off does not prevent core dump
	FILE *wfp=open_file(argv[1],"_X","w"); PutCMSA(wfp,cmaA); fclose(wfp);
	wfp=open_file(argv[2],"_X","w"); PutCMSA(wfp,cmaB); fclose(wfp);
#endif

        NEWP(ArgV,argc+5,char);
        ArgV[0]=argv[0];
#if 0
	ArgV[1]=AllocString(argv[1]); // ArgV[1]=AllocString(str); 
#else
	sprintf(str,"%s_X",argv[1]); ArgV[1]=AllocString(str); 
#endif
	ArgV[2]=argv[3]; 
	// ArgV[3]=AllocString("-dev=1"); 
	if(gpu_num > -1){
		sprintf(str,"-dev=%d",gpu_num); ArgV[3]=AllocString(str); 
		ArgC=4;
	} else if(thrds > 0){
		sprintf(str,"-thrds=%d",thrds); ArgV[3]=AllocString(str); 
		ArgC=4;
	} else ArgC=3;
	if(ccm_wt > 0.0){
		sprintf(str,"-ccm_wt=%f",ccm_wt);
		ArgV[ArgC]=AllocString(str); ArgC++;
	}
	if(ccm_LF > 0.0){
		sprintf(str,"-ccm_LF=%f",ccm_LF);
		ArgV[ArgC]=AllocString(str); ArgC++;
	}

        drc_typ *drc= new drc_typ(ArgC,ArgV,'C'); 
	double AvgL,AvgS;
#if 1	// remove old file for absent pdb;
	sprintf(str,"%s_%s.absent",argv[1],name2);
	tfp=fopen(str,"r"); 
	if(tfp){ fclose(tfp); std::remove(str); }
#endif
#if 0	// runtime error debugging...
free(ArgV[1]); if(ArgV[3]) free(ArgV[3]); free(ArgV); fclose(outfp);
for(i=1; i <= N; i++){ free(pdb_id[i]); } free(pdb_id);
delete drc; return 0;	
#endif
	fprintf(logfp,"---- MSA 1: %s ----\n",name1); fflush(logfp);
	sprintf(str,"%s_%s",argv[1],name2);
	double cut=CutDel/100.0;
// cut=1.0;
	RtnI=drc->run_sparc(AvgS,AvgL,logfp,5,str,cut);
	drc->SaveFiles();
	delete drc;
	// fprintf(stderr,"############## %s\t%lf\t%lf\n",argv[1],AvgS,AvgL);
	free(ArgV[1]); 
// exit(1);

	fprintf(logfp,"---- MSA 2: %s ----\n",name2);
	sprintf(str,"%s_X",argv[2]); ArgV[1]=AllocString(str); 
        drc = new drc_typ(ArgC,ArgV,'C'); 
	sprintf(str,"%s_%s",argv[1],name2);
	RtnJ=drc->run_sparc(AvgS,AvgL,logfp,5,str,cut);
	drc->SaveFiles();
	delete drc;


	// fprintf(stderr,"############## %s\t%lf\t%lf\n",argv[2],AvgS,AvgL);
	free(ArgV[1]);
	if(ArgV[3]) free(ArgV[3]); free(ArgV);  ArgV=0;
} 

void	cps_typ::RunPreDCA()
{
	FILE	*fp=0,*dfp=0,*tfp=0;
	//====================================================================
	fprintf(stderr,"==== Running CCMpred on each MSA ====\n");
	//====================================================================
	//================ remove old files if present. ==================
#if 1	// turning this off does not prevent core dump
	sprintf(str,"%s_X_sprc_X.mst",argv[1]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }

	sprintf(str,"%s_X_sprc_X.mst",argv[2]); dfp=fopen(str,"r"); 
	if(dfp){ fclose(dfp); std::remove(str); }
#endif

#if 1	// turning this off does not prevent core dump
	FILE *wfp=open_file(argv[1],"_X","w"); PutCMSA(wfp,cmaA); fclose(wfp);
	wfp=open_file(argv[2],"_X","w"); PutCMSA(wfp,cmaB); fclose(wfp);
#endif

        NEWP(ArgV,argc+5,char);
        ArgV[0]=argv[0];
	sprintf(str,"%s_X",argv[1]); ArgV[1]=AllocString(str); 
	ArgV[2]=argv[3]; ArgC=3;

        drc_typ *drc= new drc_typ(ArgC,ArgV,'C'); 
	sprintf(str,"%s_%s",argv[1],name2);
	double cut=CutDel/100.0;
// cut=1.0;
	drc->RunPreSparc(cut);
	drc->SaveFiles();
	delete drc;
	free(ArgV[1]); 
// exit(1);

	sprintf(str,"%s_X",argv[2]); ArgV[1]=AllocString(str); 
        drc = new drc_typ(ArgC,ArgV,'C'); 
	sprintf(str,"%s_%s",argv[1],name2);
	drc->RunPreSparc(cut);
	drc->SaveFiles();
	delete drc;

	free(ArgV[1]);
	if(ArgV[3]) free(ArgV[3]); free(ArgV);  ArgV=0;
} 

