/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "stdinc.h"
#include "chn_vsi.h"

// extern	int ChainVSI(int argc,char *argv[],FILE *ifp, FILE *ofp);

// VSI: visualize structural interactions

#if 0	// ChnVSI
if ($UseRasmol >= 1) then
chn_vsi $1 $2 -T -d2.5 -v  -D
chn_vsi ${1}.crs $2 -d2.5 -v  -c -D
else if(0) then
chn_vsi $1 $2 -T -d2.5 -v  -D -skip=A
chn_vsi ${1}.crs $2 -d2.5 -v  -c -D -skip=A -pml > ${1}.pml
else
chn_vsi $1 $2 -T -d2.5 -v  -D -skip=W
chn_vsi ${1}.crs $2 -d2.5 -v  -c -D -skip=W -pml > ${1}.pml
endif
  \rm -f $1.crs
  \rm -f ${1}_tmp.vsi
  \rm -f ${1}_tmp[0-9].vsi
#endif

#define VSI2PML_USAGE "\n\
Usage 1: vsi2pml <vsi_file> \n\
     Prints to stdout the commands to generate pymol session files\n\
     for each structural coordinate file in <vsi_file>\n\
   Options: none.\n\
Usage 2: vsi2pml <vsi_file> <group_id> <file_id> \n\
     Creates a pymol session file for a given group and file id\n\
   Options:\n\
     -save  Save the intermediate *.pml file (used to combine analyses)\n\
\n"


int	main(int argc,char *argv[])
{ 
	BooLean	verbose=TRUE;
	int	Argc=argc;
	FILE	*fp,*ifp,*ofp,*vsifp;
	char	str[202],*Argv[100],str0[202],str1[202];
	if(argc == 2){	// then print out list of pdb files present
	   Int4	x,X;
	   fp=open_file(argv[1],"","r");
	   for(x=0; fgets(str0,200,fp) != NULL; ){
		Int4 grp=0;
		if(str0[0] == '~'){
		  if(x >= 1) fprintf(stdout,"\n"); else x++;
		  if(sscanf(str0,"~$=%d.\n",&X) ==1){ if(X > 0) grp=X; }
		  fprintf(stdout,"====== group %d ======\n",grp);
	          while(fgets(str0,200,fp) != NULL && str0[0] == 'F'){
		      Int4 file=0;
		      if(sscanf(str0,"File%d=%s",&X,str1) ==2){
			char *S=strrchr(str1,'/');
			if(S != NULL){
			  S++;
			  sprintf(str,"%s",S);
			} else sprintf(str,"%s",str1);
			if(X > 0) file=X; 
		      }
		      if(file != 0 && grp!=0){
		       fprintf(stdout,"%s %s %d %d --> %s_%d_%d.pse (%s)\n",
				argv[0],argv[1],grp,file,argv[1],grp,file,str);
		      }
		  }
		} else if(str0[0] == '#' && isspace(str0[1])){
		   if(strstr(str0,"# 1.Set1:") == NULL){
		      fprintf(stdout,"%s",str0+1);
		   }
		}
	   } fprintf(stdout,"\n"); fclose(fp); return 0;
	} 
	if(argc < 3) print_error(VSI2PML_USAGE);
#if 1
	BooLean	RmPML=TRUE;
	for(Int4 arg = 4; arg < argc; arg++){
	   if(strcmp("-save",argv[arg])==0) { RmPML=FALSE; }
	   else print_error(VSI2PML_USAGE);
	}
#endif
	// Create a *pse file for a specific group and file.
	if(!isdigit(argv[2][0])) print_error(VSI2PML_USAGE);
	Int4 i,file=atoi(argv[2]),id=atoi(argv[3]);	
#if 1
        sprintf(str,"chn_vsi %s %d %d -T -skip=W -d2.5 -D",argv[1],id,file);
// fprintf(stderr,"%s\n",str1);
        Argc=string2argv(Argv,(const char *)str); // mode == 'T'
	if(verbose){
	   for(i=0; i < Argc; i++) {
		fprintf(stderr,"%s ",Argv[i]);
	   } fprintf(stderr,"\n"); 
	}
	vsifp=open_file(argv[1],"","r");
        ofp=tmpfile();
        ChainVSI(Argc,Argv,vsifp,ofp); rewind(ofp); ifp=ofp;
	if(vsifp) rewind(vsifp);
        for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);

        sprintf(str1,"chn_vsi %s.crs %d -d2.5 -c -D -pml=%s_out", argv[1],id,argv[1]);
// fprintf(stderr,"%s\n",str1);
        Argc=string2argv(Argv,(const char *)str1); // mode == 'p'
	if(verbose){ 
	   for(i = 0; i < Argc; i++) {
		fprintf(stderr,"%s ",Argv[i]);
	   } fprintf(stderr,"\n"); 
	}
        ChainVSI(Argc,Argv,ifp,0); fclose(ifp);
        for(Argc-- ; Argc >= 0; Argc--) free(Argv[Argc]);
#else
	for(Int4 i=0; i < argc; i++) Argv[i]=argv[i];
	sprintf(str,"-pml=%s_out",argv[1]);
	Argv[Argc]=AllocString(str); Argc++;
	ChainVSI(Argc,Argv,0,0);
	Argc--; free(Argv[Argc]); free(Argv);
#endif
	// return 0;
	Int4 rtn=0;
#if 1
	sprintf(str0,"%s_out.pml",argv[1]); 
	sprintf(str1,"%s_%d_%d.pml",argv[1],file,id);
	rtn = rename(str0, str1);
  	if(rtn == 0 ) puts("File successfully renamed");
	else perror( "Error renaming file" );
#endif
	fp=open_file(argv[1],"_script.py","w");
	fprintf(fp,"\nfrom pymol import cmd\n\n");
	fprintf(fp,"cmd.do('@%s_%d_%d.pml')\n",argv[1],file,id);
	fprintf(fp,"cmd.sync()\n");
	fprintf(fp,"cmd.save('%s_%d_%d.pse' )\n\n",argv[1],file,id);
	fclose(fp);
	sprintf(str,"pymol -cqr %s_script.py >& /dev/null\n",argv[1]);
	fprintf(stderr,"%s\n",str);
	rtn=system(str);
	system("sleep 2");	// wait for system to finish???
	if(rtn==0){
	  if(RmPML){
		sprintf(str,"%s_%d_%d.pml",argv[1],file,id);
		remove(str); 
	  } else {
	  }
	}
	sprintf(str,"%s_script.py",argv[1]); remove(str);
	return 0;
}

