/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "sma.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "editcma.h"
#include "table.h"
#include "sset.h"
#include "wdigraph.h"
#include "selexCMSA.h"
#include "dheap.h"
#include "swaln.h"

char    DelimitSubSeq(Int4 *Nterm, Int4 *Cterm, e_type E1, e_type E2)
// char    IsSubSeq(e_type E1, e_type E2)
// If E1 is a subseq of E2 return 1; else if E2 < E1 return 2;
// if E1 == E2 return 3; else return 0.
{
        Int4    sp,sb,end,nSb,nSp;
        char    subsq=0;
        unsigned char   *sup,*sub;
        BooLean IsSub=FALSE;

        if(LenSeq(E1)==LenSeq(E2)){ if(IdentSeqs(E1,E2)) return 3; else return 0; }
        if(LenSeq(E1) < LenSeq(E2)){
          sup=SeqPtr(E2); nSp=LenSeq(E2);
          sub=SeqPtr(E1); nSb=LenSeq(E1); subsq=1;
          end=LenSeq(E2)-LenSeq(E1)+1;
        } else {
          sup=SeqPtr(E1); nSp=LenSeq(E1);
          sub=SeqPtr(E2); nSb=LenSeq(E2); subsq=2;
          end=LenSeq(E1)-LenSeq(E2)+1;
        }
        for(Int4 st=1; st<= end; st++){
          for(IsSub=TRUE,sp=st,sb=1; sb <= nSb; sb++,sp++){
            if(sup[sp] != sub[sb]){ IsSub=FALSE; break; }
          } if(IsSub) return subsq;
        } return 0;
}

#define	USAGE_START	"USAGE: subcma cma1_prefix cma2_prefix [options]\n\
   options:\n\
     -w            - write msa files\n\
\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	Int4	arg,i,j,s,cutoff=-999,blk=0,lenrm,mingap;
	Int4    time1,*len,t,n,N,left=0,right=0,x,TrimMax=3;
	char	str[300],mode=' ',*rm=NULL,*seqid,*look=0,*keep=0;
	UInt4   seed=7061950;
	cma_typ	cma2,cma=0;
	a_type	A;
	char	status=0;

	time1=time(NULL); 
	if(argc < 3) print_error(USAGE_START);
	for(arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
             case 'T': mode = 'T'; 
		break;
	     default: print_error(USAGE_START);
	   }
	}
	if(seed == 7061950) seed = (UInt4) time(NULL);
	sRandom(seed);
	A = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	sprintf(str,"%s.cma",argv[1]);
	cma=ReadCMSA2(str,A);
	if(!cma) print_error("cma file read error");
	if(nBlksCMSA(cma) != 1) print_error("Fatal: cma file contains multiple blks");
	sprintf(str,"%s.cma",argv[2]);
	cma2=ReadCMSA2(str,A);
	if(!cma2) print_error("cma file read error");
	if(nBlksCMSA(cma2) != 1) print_error("Fatal: cma file contains multiple blks");
	e_type E=TrueSeqCMSA(1,cma2);
	e_type csq=TrueSeqCMSA(1,cma);
	BooLean IsSub=IsSubSeq(E,csq);
	// If E1 is a subseq of E2 return 1; else if E2 < E1 return 2;
	// if E1 == E2 return 3; else return 0.
	if(IsSub == 0) print_error("Fatal: input sequence does not match cma file");
	Int4	Nterm,Cterm;
	// char    rtn=DelimitSubSeq(Int4 &Nterm, Int4 &Cterm, E, csq);

	Int4 os=OffSetSeq(E);
	Int4 ex=0;	// was C-terminal extension; no longer used.

	// if(blk < 1 || blk > nBlksCMSA(cma)) print_error(USAGE_START);
	blk=1;
	if(ex > 0){
			Int4 lemon; 
			for(i=1; i<=ex; i++){
			   lemon = LengthCMSA(blk,cma);
			   if(lemon <= 3) print_error(USAGE_START);
			   RmColumnMSA(blk, lemon, cma);
			}
	} 
	if(os > 0){
			for(i=1; i<=os; i++){
			   if(LengthCMSA(blk,cma) <= 3) print_error(USAGE_START);
			   RmColumnMSA(blk, 1, cma);
			}
	} 
	// SaveBestCMSA(cma); InitMAPCMSA(cma);
	FILE *fptr = open_file(argv[1],".edit.cma","w");
#if 0
	cma_typ IN_CMA[3]; IN_CMA[1]=cma;
	PutMergedCMSA(fptr,1,IN_CMA); 
#else
    	PutCMSA(fptr,cma); 
#endif
	fclose(fptr);
	if(cma) TotalNilCMSA(cma);
	// if(data != NULL) NilSeqSet(data);
	NilAlpha(A);
	fprintf(stderr,
		"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return status;
}

