/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmsa.h"
#include "sma.h"
#include "gibbs.h"
#include "seqset.h"
#include "residues.h"
#if 0
#include "compare_sma.h"
#endif


#define	USAGE_START	"USAGE: msadiff file1 msafile2 [options]\n\
   options:\n\
     -o         - reorder sequences in msa using order in file1\n\
     -g         - put gap lengths\n\
     -p         - put difference \n\
     -m<file>   - merge alignments\n\
     -x         - dummy\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	Int4	arg,i,j,s,cutoff=-999;
	Int4    time1,*len,t,n;
	char	str[300],*name;
	sma_typ MA[3];
	a_type	A;
	ss_type	data;
	BooLean	reorder=FALSE,gaps=FALSE,merge=FALSE,putdiff=FALSE;
	cma_typ	ma1,ma2,ma;
	char    *argument[200];
	Int4	*num,narg;
	st_type	S;

	time1=time(NULL); 
	if(argc < 3) print_error(USAGE_START);
	for(arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'x': break;
	     case 'm': merge=TRUE; name = argv[arg]+2; break;
	     case 'g': gaps=TRUE; break;
	     case 'p': putdiff=TRUE; break;
	     case 'o': reorder=TRUE; break;
	     default: print_error(USAGE_START);
	   }
	}
  if(gaps){
	MA[1]=ReadSMA(argv[1]);
	fprintf(stdout,"gaps for %s: \n",argv[1]);
	PutGapsSMA(stdout, MA[1]);
	NilSMA(MA[1]); 
#if 0
	MA[2]=ReadSMA(argv[2]);
	fprintf(stdout,"gaps for %s: \n",argv[2]);
	PutGapsSMA(stdout, MA[2]);
	NilSMA(MA[2]); 
#endif
  } else if(merge){
	MA[1]=ReadSMA(argv[1]);
	MA[2]=ReadSMA(argv[2]);
	ma1=SMA2CMSA(name,MA[1]);
	ma2=SMA2CMSA(name,MA[2]);
	ma = IntersectionCMSA(ma1, ma2);

	S = SitesCMSA(ma);
	NEW(num,nBlksCMSA(ma)+3,Int4);
	for(j=1; j<=nBlksCMSA(ma); j++) num[j] = SiteLen(j,S);
	narg=string2argv(argument,"-t1");
	SimulatedAnnealingGibbs(narg,argument,&ma,'D',150);

	PutAlnCMSA("test_msadiff", ma,NULL);
	NilSMA(MA[1]); NilSMA(MA[2]); 
	NilCMSA(ma1); NilCMSA(ma2);
	NilCMSA(ma);
  } else if(putdiff){
	MA[1]=ReadSMA(argv[1]);
	MA[2]=ReadSMA(argv[2]);
	PutDiffSMA(stdout, MA[1], MA[2]);
	NilSMA(MA[1]); NilSMA(MA[2]); 
  } else if(reorder){
	MA[1]=ReadSMA(argv[2]);
	if(MA[1]==NULL) print_error(USAGE_START);
	ReOrderSMA(stdout, argv[1], MA[1]);
	NilSMA(MA[1]); 
  } else {
    	for(i=1; i<=2; i++){
		MA[i]=ReadSMA(argv[i]);
		if(MA[i]==NULL) print_error(USAGE_START);
#if 0
		PutSMA(stdout, MA[i]);
#endif
    	}
    	DiffSMA(stderr,MA[1], MA[2]);
    
	NilSMA(MA[1]); NilSMA(MA[2]); 
  }
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

