/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "histogram.h"
#include "afnio.h"
#include "random.h"

#define USAGE "usage: histogram <int>[,int]\n\
        -x        dummy\n\
\n"

int	main(int argc, char *argv[])
{
	time_t	time1=time(NULL);
	Int4	values[1000];
	

	if(argc < 2) print_error(USAGE);
	Int4 Nval=ParseIntegers(argv[1],values, "histogram input error");
	
	//***************************** 2. Get input options *******************************
        for(Int4 arg = 2; arg < argc; arg++){
           if(argv[arg][0] != '-') print_error(USAGE);
           switch(argv[arg][1]) {
	     case 'x':
		break;
             default: print_error(USAGE);
           }
        }

	//***************************** 2. Initialize search *******************************
   h_type HG = Histogram("integer values",0,1,0.02);
   for(Int4 i=1; i <=100000; i++) {
	double rand = ((double) Random()/(double) RANDOM_MAX);
	IncdHist(rand, HG);
   }
   PutHist(stdout,60,HG); NilHist(HG);
   HG = Histogram("integer values",0,5000,10);
   for(Int4 s=1; s <= Nval; s++){
	IncdHist(values[s], HG);
   } PutHist(stdout,60,HG); NilHist(HG);
   double runtime = difftime(time(NULL),time1);
   fprintf(stderr,"time = %0.2f minutes (%0.1f seconds)\n",runtime/60.0,runtime);
}


