/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "random.h"
#include "purge.h"
#include "sequence.h"
#include "alphabet.h"
#include "residues.h"
#include "histogram.h"

#define	USAGE_START	"USAGE: findfullsq subseq database [options]\n\
   options:\n\
     -z         - usage\n\n"

/**************************** Global Variables ******************************/

int	main(Int4 argc,char *argv[])
{ 
	Int4	m,n,i,j,k,length,arg,number,num,*counts,time1,total;
	Int4	MAX_IN_SEQS=1000000;
	unsigned short	*nsize;
	double	*freq;
	int	return_status=0,test=0;
	a_type	A;
        FILE    *fptr,*ofp,*pfp=NULL,*ifp;
	UInt4 seed=18364592;
	Int4	cutoff=-1;
	char	mode = ' ';
	h_type	H;
	e_type	qE;

	time1=time(NULL);
	if(argc < 3) print_error(USAGE_START);
	sRandom((UInt4) time(NULL)/2);
	A=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	for(arg = 3; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'z': print_error(USAGE_START); break;
	     default: print_error(USAGE_START);
	   }
	}
	if(seed == 18364592)  seed = (UInt4) time(NULL)/2;
	sRandom(seed);
	number = GetFastaInfo(argv[2], MAX_IN_SEQS, &counts, &nsize, A);
	for(total=0, i=0; i<=nAlpha(A); i++) total += counts[i];
	for(arg = 0; arg < argc; arg++) fprintf(stderr, "%s ",argv[arg]); 
	fprintf(stderr,"\n");
	NEW(freq,nAlpha(A)+2,double);
    	for(i=0; i<=nAlpha(A); i++) freq[i]= (double)counts[i]/(double)total;
	for(m=0,i=1; i<= number; i++) m = MAXIMUM(Int4,nsize[i],m);

	ss_type data = SeqSet(argv[1],A);
	// qE=ReadSeqFA(argv[1], 0, A);
	for(n=1; n <= NSeqsSeqSet(data); n++){
	 qE = SeqSetE(n,data);
	 fptr = open_file(argv[2],"","r");
	 for(i=1; i<= number; i++){
	  e_type E = ReadSeq(fptr,i,nsize[i],A); assert(E);
	  if(LenSeq(E) >= LenSeq(qE) && IsSubSeq(qE,E)) {
		PutSeq(stdout,E,A);
	  } NilSeq(E);
	 } fclose(fptr);
	}
	NilSeqSet(data);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	NilAlpha(A); free(counts); free(nsize); free(freq);
	return return_status;
}

