/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "pdb.h"

#define WUSAGE "Usage: find_triad pdbfa [options]\n\
       -S        output sequences in fasta format\n\
       -z        simulate evolved sequences (using PAM value)\n\n"

int	main(int argc,char *argv[])
{ 
	Int4	start,arg,n;
	char	c=' ';
	BooLean	silent = TRUE;
	UInt4 seed=18364592;
	Int4    time1;
	pdb_typ	P;
	Int4	res0=200,C,C1=1,C2=1;
	float	dmax=1.;


	if(argc < 2) print_error(WUSAGE);
	start = 2; 
        for(arg = start; arg < argc; arg++){
           if(argv[arg][0] != '-') print_error(WUSAGE);
           switch(argv[arg][1]) {
	 	case 'd':
		  if(sscanf(argv[arg],"-d%f",&dmax) != 1 || dmax > 100 || dmax < 0)
                        print_error(WUSAGE);
                  break;
	 	case 'S': c = 'S'; silent = TRUE; break;
                case 'x': c = 'x'; break;
                default: print_error(WUSAGE);
            }
        }
	if(!silent) {
          for(arg=0; arg < argc; arg++) printf("%s ",argv[arg]); printf("\n");
	}
	time1=time(NULL);
        if(seed == 18364592) seed = (unsigned int) (time(NULL)/2);
	if(!silent) fprintf(stdout,"seed = %d\n",seed);
	sRandom(seed);
	P = MkPDB(argv[1]);
	switch(c){
	   case 'S': 
		for(C=1; C <= nChainsPDB(P); C++){
		   PutPDBSeq(stdout, C, P);
		}
	   break; 
	   default:
		Int4	*triad[5],a,i;
		float	d1,d2;
		atm_typ	a1,a2;
		n=TriadPDB(C1, P, triad);
		for(i=1; i <= n; i++){
		   if(triad[0][i] != 0){
		     a1=AtomPDB(C1, triad[1][i], P);
		     a2=AtomPDB(C1, triad[2][i], P);
		     d1 = DistanceAtoms(a1, a2);
		     PutAtom(stdout,a1); PutAtom(stdout,a2);
		     printf("   %1.2f Angstroms\n",d1);
		     a1=AtomPDB(C1, triad[3][i], P);
		     a2=AtomPDB(C1, triad[4][i], P);
		     d2 = DistanceAtoms(a1, a2);
		     PutAtom(stdout,a1); PutAtom(stdout,a2);
		     printf("   %1.2f Angstroms (%1.2f Angstroms total)\n\n",d2,d1+d2);
		   } 
		}
		if(n>0) for(a=0; a < 5; a++) free(triad[a]);
		// fprintf(stdout,"n=%d\n",n);
	   break; 
	}
	// PutPDB(stdout,P);
	NilPDB(P);
	if(!silent)
	  fprintf(stdout,"\ttime: %d seconds (%0.2f minutes)\n",
		time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
}

