/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "stdinc.h"
#include "alphabet.h"
#include "probability.h"
#include "table.h"

#include <math.h>	// math_errhandling
#include <errno.h>	// errno, EDOM
#include <fenv.h>	// feclearexcept, fetestexcept, FE_ALL_EXCEPT, FE_INVALID 
#pragma STDC FENV_ACCESS on


#define	USAGE_START	"USAGE: exact red_out black_out red_in black_in [options]\n\
   Fisher's Exact test\n\
   options:\n\
     -x         - dummy\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	Int4	arg,s,time1;
	Int4	red,black,in,out;
	Int4	red_out,black_out,red_in,black_in;

	time1=time(NULL); 
	if(argc < 5) print_error(USAGE_START);
	red_out = atoi(argv[1]);
	black_out= atoi(argv[2]);
	red_in= atoi(argv[3]);
	black_in= atoi(argv[4]);
	for(arg = 5; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'x': break;
	     default: print_error(USAGE_START);
	   }
	}
/*************** Fisher's Exact Test for a 2x2 contingency table *****
 *  observed:
 *
 *             red    black
 *      ----+-------+-------+-------
 *      out |   a   |   b   | a + b
 *      ----+-------+-------+-------
 *      in  |   c   |   d   | c + d
 *      ----+-------+-------+-------
 *          | a + c | b + d |a+b+c+d
 *
 *      see p. 81 of thesis.
 *
 **********************************************************************/
	long double	K,P,Q,end,p,OneTail,TwoTail,total;
	Int4	i,j,a,b,c,d;
	BooLean	failed=FALSE;
#if 0	// debug lgammal
long double  Value=1.45e+490,Dd=lgammal(Value+1.0);
fprintf(stderr,"lgammal(%Lg)=%Lg\n",Value+1,Dd); 
  // if (math_errhandling & MATH_ERREXCEPT) feclearexcept(FE_ALL_EXCEPT);
  if(isinf(Dd)==1) printf ("+infinity\n");
  else if(isinf(Dd)==-1) printf ("negative infinity\n");
  // errno = 0;
  // if (math_errhandling & MATH_ERREXCEPT) feclearexcept(FE_ALL_EXCEPT);
  // printf ("Error handling: %d",math_errhandling);

exit(1);
#endif
	
	OneTail=TwoTail=total=0.0;
	a = red_out; b = black_out;
	c = red_in; d = black_in;
	red = a+c; black = b+d; out = a+b; in = c+d;
#if 0
// 1. Find the most extreme configuration???
//  ... or leave this as it is because not interested in opposite arrangement?
	end = MINIMUM(double,a,d);
        K = lgammal(out+1.0) + lgammal(red+1.0)
                + lgammal(black+1.0) + lgammal(in+1.0) - lgammal(a+b+c+d+1.0);
	if(isinf(K)==1){ fprintf(stderr,"input overflow (+infinity)\n"); failed=TRUE; }
	else if(isinf(K)==-1){ fprintf(stderr,"input underflow (-infinity)\n"); failed=TRUE; }
        P = lgammal(a+1.0) + lgammal(b+1.0) + lgammal(c+1.0) + lgammal(d+1.0); 
	if(isinf(P)==1){
	  fprintf(stderr,"input overflow (+infinity)\n"); failed=TRUE; 
	} else if(isinf(P)==-1){
	  fprintf(stderr,"input underflow (-infinity)\n"); failed=TRUE; 
	}
        for(i=MAXIMUM(Int4,-b,-c); i <= end; i = i + 1) {
            Q = lgammal(a-i+1.0) + lgammal(b+i+1.0)
                        + lgammal(c+i+1.0) + lgammal(d-i+1.0);
	    p = expl(K-Q);
	    if(p==0.0) failed=TRUE;
            printf(" [%d : %d | %d : %d] (Q = %Lg; = = %Lg)\n", 
			(Int4)(a-i), (Int4) (b+i),(Int4) (c+i), (Int4) (d-i),Q,p);
            if(P <= Q){
		TwoTail += p;
		if((a-i) >= a) OneTail += p;
	    } total+=p;
        }
#endif
	TwoTail=FisherExactTest(0,a,b,c,d,OneTail);
	printf("Drew %d balls out of an urn with %d red and %d black balls\n",
			out,red,black);
	printf("Among these there were %d red balls.\n",red_out);
	printf("One tail prob = %Lg\n",OneTail);
	printf("Two tail prob = %Lg\n",TwoTail);
	// fprintf(stderr,"total = %.9Lg\n",total);
	if(failed) fprintf(stdout,"WARNING: Underflow occurred: test is unreliable\n");
	// fprintf(stdout,"LDBL_MAX = %Lg\n",LDBL_MIN);
	return 0;
}



