/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "dom_typ.h"

#define	USAGE_START	"USAGE: domains domfile [options]\n\
   options:\n\
     -R<name>   - Remove domains of type <name> from domfile\n\
     -r<int>    - Remove sequence <int> from domfile\n\
     -o<int>    - output domains with sequence number offset = <int>\n\
     -c         - color domains\n\
     -x         - dummy\n\n"

/**************************** Global Variables ******************************/
int	main(Int4 argc,char *argv[])
{ 
	FILE	*fp;
	Int4	arg,time1=time(NULL); 
	Int4	skip_sq=0,offset=0;
	char	*skip_name=0,mode=' ';
	BooLean	*skip=0;

	if(argc < 2) print_error(USAGE_START);

	fp = open_file(argv[1],"","r");
	dom_typ	*dom; dom = new dom_typ(fp); fclose(fp);

	for(arg = 2; arg < argc; arg++){
	   if(argv[arg][0] != '-') print_error(USAGE_START);
	   switch(argv[arg][1]) {
	     case 'R': if(!isalnum(argv[arg][2])) print_error(USAGE_START);
			else skip_name=argv[arg]+2; break;
	     case 'r': skip_sq=IntOption(argv[arg],'r',1,dom->NumSeq( ),USAGE_START);
		break;
	     case 'o': offset=IntOption(argv[arg],'o',0,5000,USAGE_START);
		break;
	     case 'c': mode='c'; break;
	     case 'x': break;
	     default: print_error(USAGE_START);
	   }
	}
	if(mode == 'c'){
	  for(Int4 s=1; s <= dom->NumSeq( ); s++){
	    for(Int4 d=1; d <= dom->NumDomains(s); d++){
		fprintf(stderr,"sq %d(%d):%u-%u->%s; %.1f; color = %c; shape = %c\n",
			s,d,dom->SqStart(s,d),dom->SqEnd(s,d),
        		dom->DomainName(s,d),dom->Evalue(s,d),
			dom->Color(s,d),dom->Shape(s,d));
	    }
	  }
	  for(Int4 t=1; t <= dom->NumTypes( ); t++){
		fprintf(stderr,"%s(%d): color = %c; shape = %c; avelen=%d\n",
			dom->NameThisType(t), dom->NumThisType(t),
			dom->Color(t), dom->Shape(t), dom->AveLen(t));
		
	  }
	} else {
	  if(skip_sq > 0){
		NEW(skip, dom->NumSeq( )+3,BooLean);
		skip[skip_sq] = TRUE;
	  }
	  dom->Put(stdout,skip,skip_name,offset);
	  if(skip) free(skip);
	}
#if 0
	// dom->Put(stdout);
	for(Int4 s=1; s <= dom->NumSeq( ); s++){
	  for(Int4 d=1; d <= dom->NumDomains(s); d++){
		fprintf(stderr,"sq %d(%d):%u-%u->%s; %.1f\n",
			s,d,dom->SqStart(s,d),dom->SqEnd(s,d),
        		dom->DomainName(s,d),dom->Evalue(s,d));
	  }
	}
	if(TRUE){ 
		dom_typ *dom2= new dom_typ;
		*dom2=*dom;
	  	dom2->Put(stdout);
		delete dom2;
	}
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
#endif
	delete dom;
	return 0;
}



