/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cmsa.h"
#include "residues.h"
#include "hat_typ.h"
#include "hpt_typ.h"

#define USAGE_START "Usage: ConvertHpt infile [options]\n\
        (converts infile.hpt using template file infile.tpl )\n\
       -x          dummy\n\n"

hpt_typ *ConversionViaTemplateHpt(cma_typ TmplCMA, hpt_typ *Hpt);

int	main(Int4 argc,char *argv[])
{
	char	str[300];
	FILE	*fp;
	hpt_typ *nHpt,*Hpt;
	Int4    N,i,j,arg,Num=25;
        cma_typ cma=0,tpl;

	if(argc < 2) print_error(USAGE_START);
        for(arg = 3; arg < argc; arg++){
          if(argv[arg][0] == '-'){
           switch(argv[arg][1]) {
             case 'm':
                Num=IntOption(argv[arg],'m',1,100,USAGE_START);
                        break;
             case 'x': break;
             default : print_error(USAGE_START);
           }
          } // else if(arg > 1) print_error(USAGE_START);
        }
        a_type AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
        fp=open_file(argv[1],".tpl","r"); tpl=ReadCMSA(fp,AB);  fclose(fp);
        N = NumSeqsCMSA(tpl);
        BooLean *skip; NEW(skip,N+3,BooLean);
        for(i=2;i <= N; i++) skip[i]=TRUE;      // print out first sequence only..
        PutSelectCMSA(stdout,skip,tpl); free(skip);
        fp=open_file(argv[1],".hpt","r"); Hpt= new hpt_typ(fp); fclose(fp);
        Hpt->Put(stderr);
        nHpt=ConversionViaTemplateHpt(tpl,Hpt);
        // TotalNilCMSA(tpl);

	return 0;
}


