/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "compare_sma.h"

Int4    max_int_csa_array(Int4 *I, Int4 *L)
/** sets *I to integer repeated most often; returns number of repeats **/
{
        Int4    i,j,N,maxI,n,x,t;

        /** BubbleSortIArray(Int4 *L); **/
        for(i=1; i <= L[0]; i++){
                for(j=i;j > 1 && (L[j-1] > L[j]);j--){
                        t=L[j]; L[j]=L[j-1]; L[j-1]=t;
                }
        }
#if 0	/** Debug: output array **/
        fprintf(stderr,"\n\t[");
        for(i=1; i <= L[0]; i++){ 
                fprintf(stderr,"%4d",L[i]);
                if(i%10==0) fprintf(stderr,"\n\t");
        }
        fprintf(stderr," ]\n");

#endif
        i=1; maxI=-1; N = 0;
        while(i <= L[0]){
           for(x=L[i], n=0; i <= L[0] && L[i] == x; ){
                n++; i++;
           }
           if(n > N) { N= n; maxI = x; }
        } 
        *I = maxI;
        return N;
}

#if 0
void	PutGapsSMA(FILE *fp, csa_typ MA)
/** get totGaps using nseqSMA(MA) macro ***/
{
	Int4	t,n,g,t1,t2;
	h_type	H;
	char	str[100];

   for(t1 = 1; t1 < MA->ntyps; t1++){
	t2 = t1 +1;
	sprintf(str,"gap lengths between block %d and %d",t1,t2);
	H =Histogram(str,0,100,1.0);
        for(n=1; n <= MA->nseqs; n++) {
           g = MA->start[n][t2] - MA->end[n][t1] - 1;
	   IncdHist(g,H);
	}
	PutHist(fp,60,H); NilHist(H);
   }
}
#endif

csa_typ	MakeCSA(sma_typ MA1, sma_typ MA2)
/*********************************************************************
  (print the difference between MA1 and MA2)
  Optimally align MA1 and MA2 
  Want to add statistics, recombination, and subalignment routines later.
  Will allow speed up of Gibbs alignment algorithm.
  Want to incorporate these into cmsa datatype. 
 *********************************************************************/
{ 
    Int4	n,t1,t2,os,max;
    sma_typ	ma1,ma2;
    csa_typ	C;
    
    /** 1. Check to see that alignments use the same sequences. **/
    if(nseqSMA(MA1) != nseqSMA(MA2)){
    	fprintf(stderr,"inconsistent alignments; can't be compared\n");
	return NULL;
    } else {
      for(n = 1; n <= nseqSMA(MA1); n++) {
	if(strcmp(infoSMA(n,MA1),infoSMA(n,MA2)) != 0) {
    		fprintf(stderr,"inconsistent alignments; can't be compared\n");
		return NULL;
	}
      }
    }
    if(ntypSMA(MA1) <= ntypSMA(MA2)) { ma1 = MA1; ma2 = MA2; }
    else { ma2 = MA1; ma1 = MA2; }
    NEW(C,1,compare_sma_type);
    C->ntyps = ntypSMA(ma1);
    C->nseqs = nseqSMA(ma1);
    NEW(C->max_n,C->ntyps +3,Int4);
    NEW(C->max_t,C->ntyps +3,Int4);
    NEW(C->maxos,C->ntyps +3,Int4);
    NEW(C->rm_front,C->ntyps +3,Int4);
    NEW(C->rm_end,C->ntyps+3,Int4);
    NEW(C->offset,C->nseqs+3, Int4);
#if 0
    /** 2. For each block in ma1 find best block in ma2. **/
    for(Total=0,t1=1; t1 <= C->ntyps; t1++) {
	C->max_n[t1] = 0;
        for(t2=1; t2 <= ntypSMA(ma2); t2++) {
            for(n=1; n<= C->nseqs; n++){
		C->offset[n] = startSMA(t2,n,ma2) - startSMA(t1,n,ma1);
	    } C->offset[0]=C->nseqs;
#if 0
	    fprintf(stderr,"motif %d versus %d: \n", t1,t2);
#endif
	    n = max_int_csa_array(&os,C->offset);
	    if(n > max_n){ max_n = n; C->maxos[t1] = os; C->max_t[t1] = t2; }
#if 0
	    fprintf(stderr,"  %d matches (offset = %d)\n---------\n\n", n,os);
#endif
	}
	Total += (C->nseqs - max_n);
	fprintf(stderr,"BLKS %d & %d: alignments differ by %d/%d sites (os = %d)\n",
		t1,max_t,C->nseqs - max_n,C->nseqs, C->maxos[t1]);
	fprintf(stderr," %d versus %d columns\n", ma1->length[t1], 
		ma2->length[max_t]);
	if(TRUE || strcmp(ma1->null[t1],ma2->null[max_t]) != 0){
		fprintf(stderr," column configuration difference: \n\t");
		if(C->maxos[t1] < 0){
			for(os = C->maxos[t1]; os < 0; os++) fprintf(stderr," ");
			fprintf(stderr,"%s\n\t%s\n", ma1->null[t1],ma2->null[max_t]);
		} else {
			fprintf(stderr,"%s\n\t", ma1->null[t1]);
			for(os = maxos; os > 0; os--) fprintf(stderr," ");
			fprintf(stderr,"%s\n", ma2->null[max_t]);
		}
	}
#if 0	/** report gaps here **/
	if(t2 > 1){
            for(n=1; n<= ma1->nseqs; n++){
		ma2->start[n][t2] - ma1->start[n][t1];
	    }
	}
#endif
#if 1
	if(maxos < 0){
		rm_front[t1] =  0;
	} else {
		rm_front[t1] =  maxos;
	}
	n  = ((ma1->length[t1] - maxos) - ma2->length[max_t]);
	rm_end[t1] = MAXIMUM(Int4,n,0);
#endif
    }
    /** 3. Use dynamic programming to find the best alignment of ma1 with ma2. **/
    free(offset);
    fprintf(stderr,"Alignments differ by a total of %d sites\n\n",Total);
#if 0	/*** TEST ***/
    fp= open_file("junk_diffmsa",".msa","w");
    PutSMA(fp, ma1); fclose(fp);
    MA = ReadSMA("junk_diffmsa.msa");
    for(t1=1; t1 <= ma1->ntyps; t1++) {
      if(rm_front[t1] > 0){
       fp= open_file("junk_diffmsa",".msa","w");
       PutTruncateBlkSMA(fp, t1, rm_front[t1], MA);
       fclose(fp); NilSMA(MA);
       MA = ReadSMA("junk_diffmsa.msa");
      }

      if(rm_end[t1] > 0){
       fp= open_file("junk_diffmsa",".msa","w");
       PutTruncateBlkSMA(fp, t1, -rm_end[t1], MA);
       fclose(fp); NilSMA(MA);
       MA = ReadSMA("junk_diffmsa.msa");
      }
    }
    NilSMA(MA);
#endif
#if 1
    free(rm_front); free(rm_end);
#endif
#endif
    return C;
}

csa_typ	NilCSA(csa_typ MA)
{
	Int4	n,t;

	return NULL;
}


