/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

double	GetResDistance(FILE *fptr, Int4 resC,Int4 resD, char chnC, char chnD, pdb_typ P,
		BooLean noMainChn=TRUE)
/************************************************************
 ************************************************************/
{
	Int4 res0,C,D,ai,aj,r,i,j,x,num_resC,num_resD,nI,nJ;
	C=GetChainNumberPDB(P,chnC); // C = query residue chain.
	D=GetChainNumberPDB(P,chnD); // D = query residue chain.
	if(C==0){ fprintf(stderr,"chnC = %c\n",chnC); print_error("chain not found!"); }
	if(D==0){ fprintf(stderr,"chnD = %c\n",chnD); print_error("chain not found!"); }
	res_typ *ResAllC=MakeResPDB(C,&num_resC,P);
	res_typ *ResAllD=MakeResPDB(D,&num_resD,P);

	a_type AB = AminoAcidAlphabetPDB(P);
	// Find minimum Res-Res distance ...
	atm_typ	atmI,atmJ,minAI,minAJ;
	res_typ	ResI,ResJ;
	char	cI,cJ;
	float	max,min,dd;
	for(i=1; i <= num_resC; i++){
	   ResI=ResAllC[i]; cI=GetCharResidue(ResI,AB);
	   nI=ResidueID(ResI);
	   if(nI != resC) continue;
	   for(j=1; j <= num_resD; j++){
	        ResJ=ResAllD[j]; cJ=GetCharResidue(ResJ,AB);
	        nJ=ResidueID(ResJ);
	        if(nJ != resD) continue;
		dd=0.0; min=999999.0;
		for(ai=1; ai <= ResidueAtomNumber(ResI); ai++){
		  atmI=AtomResidue(ai,ResI);
		  if(noMainChn){
		    if(!(SideAtom(atmI) || (cI=='G' && AlphaCarbonAtom(atmI)))) continue;
		  }
		  //fprintf(stderr,"%s: \n",ResidueName(ResI)); PutAtom(stderr,atmI);
		  for(aj = 1; aj <= ResidueAtomNumber(ResJ); aj++){
		    atmJ=AtomResidue(aj,ResJ);
		    if(noMainChn){
		      if(!(SideAtom(atmJ) || (cJ=='G' && AlphaCarbonAtom(atmJ)))) continue;
		    }
		    dd=DistanceAtoms(atmI,atmJ);
		    if(dd < min){ min=dd; minAI=atmI; minAJ=atmJ; }
		  }
		}
		if(0 && min <= 5.0){
		    fprintf(fptr,"%c%d%c\t%c%d%c\t%.2lf\n",cI,nI,chnC,cJ,nJ,chnD,min); 
		} // PutAtom(fptr,minAI); PutAtom(fptr,minAJ);
		for(x=1; x <= num_resC; x++) NilRes(ResAllC[x]); free(ResAllC); 
		for(x=1; x <= num_resD; x++) NilRes(ResAllD[x]); free(ResAllD); 
		return min;
	   }
	}
	for(i=1; i <= num_resC; i++) NilRes(ResAllC[i]); free(ResAllC); 
	for(i=1; i <= num_resD; i++) NilRes(ResAllD[i]); free(ResAllD); 
	return 0.0;
} 

int     main(int argc, char *argv[])
{
        int	arg,Argc=0;
        char	*Argv[50],str[20];
	Int4	i,j;
// for(i=0; i < argc; i++) fprintf(stderr,"%d %s\n",i,argv[i]);
	edc_typ *edc= new edc_typ(argc,argv);
	dci_typ *dci=edc->RunDCA( ); 
	if(dci){ 
	        if(edc->DoShowPairs()) dci->Put(stdout);
		char *Chns=edc->RtnChains(); 
		if(edc->UsePPV){
		   fprintf(stdout,"mthd\tchn\tr(A)\tPPV\tBIU\tL\tD\tX\td\tR\tF\n");
		   dci->PutResults(stdout,'M',Chns);
		} else dci->PutResults(stdout,edc->Mode,Chns); 
	        Int4 *bpps=edc->RtnBPPS();
	        set_typ SetB=0;
	        if(bpps){
		    SetB=MakeSet(5000);
		    for(i=1; i <= bpps[0]; i++) AddSet(bpps[i],SetB);
		    if(0 && SetB) PutSet(stdout,SetB);
#if 0	// numbers of contacts.
		 h_type HG=Histogram("Residue-to-Residue Contacts",0,100,1.0);
		 for(Int4 x=100; x <= 950; x++){ 
		    char str[100],*pdbfile=0; // edc->pdbFileRtn();
		    // pdb_typ pdb=MakePDB(pdbfile);
		    sprintf(str,"pdbs/%drp_H.pdb",x);
		    pdb_typ pdb=MakePDB(str);
		    Int4 hits=0;
		    for(i=1; i < bpps[0]; i++){
		      for(j=i+1; j <= bpps[0]; j++){
			
			double  dd=GetResDistance(stderr,bpps[i],bpps[j],
					Chns[0],Chns[0],pdb,TRUE);
			if(dd <= 4.0){
			   hits++;
			}
			// double dd=DistancePDB(i,"CA",cI,nJ,"CA",cJ,pdb)
		      }
		    }
		    IncdHist(hits,HG);
		    fprintf(stdout,"%d\t%d\n",x,hits); fflush(stdout);
		    // fprintf(stdout,"%s\t%d\n",pdbfile,hits);
		    //free(pdbfile);
		 } PutHist(stdout,60,HG); NilHist(HG);
#endif
	        }
		free(Chns);
	  	if(edc->DoShowPairs()){
	          fprintf(stdout,"highest DCA scoring pairs in %s %s\n",argv[1],argv[2]);
		  dci->PutBest(stdout,edc->ShowPairs,SetB,edc->RtnKeyChain());
	        } delete dci; 
		if(SetB) NilSet(SetB);
	} else print_error("Input error");
	delete edc;
	return 0;
}

