#include "spc_typ.h"
#include "edc_typ.h"
#include "ihd_typ.h"
#include "dca_typ.h"

extern "C" int run_ccmpred(int argc, char **argv);

int	main(int argc, char *argv[])
{
    // mode: d2d 
    if(argc > 1 && argv[1][0]=='-'){
	for(int x=0; x <= 1; x++){
	  Int4 time1=time(NULL);
	  if(x==0) run_ccmpred(argc,argv);
	  else {
	    dca_typ *dca = new dca_typ(argc,argv);
	    dca->Run(); 
	    delete dca;
	  }
	  fprintf(stderr, "\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	}
    } else if((argc > 1 && strcmp("hetmer",argv[1])==0)){
	Int4    time1=time(NULL);
	ihd_typ	*ihd= new ihd_typ(argc,argv);
	ihd->Run(); delete ihd;
    } else {
	spc_typ *spc= new spc_typ(argc,argv);
	spc->Run(); 
	if(strcmp(argv[1],"sc2sb")==0) spc->PutSIPRIS(argv[2]); 
	delete spc;
    }
	return 0;
}

