/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "lps_typ.h"

double	MaxHist(double &ValBlw, double &ValAbv, double &PcBlw, h_type H)
/************************************************************************
 ************************************************************************/
{
	Int4	start,total,sum,i,j,n,max_i;
	Int4	pcb,pca,max,max_s;	// percent below and above.
	double	d,dd,val,valB,valA,maxval=0.0,cutB,cutA;
	double	median=MedianHist(H); 
	double	mean=MeanHist(H); 
	
	for(sum=max=max_i=0,i=0;i<=H->nbins+1;i++) sum += H->bin0[i];
	if(sum == 0) { print_error("FATAL: histogram empty.\n"); }
	total=sum;
	for(sum=max=max_i=0,i=0;i<=H->nbins+1;i++) {
		sum += H->bin0[i];
		dd=(double) sum/(double) total;
	   // if(H->bin0[i] > max){ max = H->bin0[i]; max_i=i; max_s=sum; }
	   if(max==0 && dd >= 0.50){ max = H->bin0[i]; max_i=i; max_s=sum; }
	}
	PcBlw=(double)max_s/(double)total;
	cutB=0.9 * PcBlw;
#if 0
	cutA=PcBlw + (0.30 - (1.0 - cutB));
	if(cutA < 0.50) cutA=0.50;
#else
	cutA=0.30;
#endif
fprintf(stderr,"cutB=%.1lf; cutA=%.1lf\n",cutB,cutA);
	
	for(pcb=sum=0,i=max_i;i > 0;i--) {
	    sum += H->bin0[i];
	    d=(double)sum/(double)total;
	    if(pcb == 0 && d >= cutB){ pcb=i; break;}
	}
	for(pca=sum=0,i=max_i;i <= H->nbins+1; i++) {
	    sum += H->bin0[i];
	    d=(double)sum/(double)total;
	    if(pca==0 && d >= cutA){ pca=i; break; }
	}

	sum = 0;
	if((n=H->bin0[0]) > 0){ sum=n; start=1; val=H->min; }
	else {
	   for(start=0,val=H->min; H->bin0[start]==0 ;start++){
	      val+=H->inc;
	      if(start >= H->nbins) print_error(" variance too small\n"); 
	   } val-=H->inc;
	}
	for(i=start; i<=H->nbins; val+= H->inc, sum+=H->bin0[i],i++) {
	   n = H->bin0[i];
	   if(i==max_i) maxval=val;
	   if(i==pcb) valB=val;
	   if(i==pca) valA=val;
	   if(sum==total) break; 
	} // print_error("FATAL: histogram MaxHist() error");
	ValBlw=valB; ValAbv=valA;
	return maxval;
}

Int4    lps_typ::RmOutliers()
// remove the shortest and longest sequences from the input file.
{
	Int4	i,j,n,N,min,max;
	ss_type P = SeqSet(argv[1],AB);
	e_type	Sq;
	double	d,dd,D,DD;

	N=NSeqsSeqSet(P); n=MaxSeqSeqSet(P);
	double inc=round((double)n/500.0);
	h_type   HG=Histogram("Seq lengths",0,n,inc);
	dh_type dH=dheap(N+10,4);
        for(n=1; n <= NSeqsSeqSet(P); n++){
            Sq=SeqSetE(n,P);
	    IncdHist((double)LenSeq(Sq),HG);
	    insrtHeap(n,(keytyp)LenSeq(Sq),dH);
	}
	double mean=MeanHist(HG); 
	double median=MedianHist(HG); 
	double stdev = sqrt(VarianceHist(HG));
	PutHist(stderr,60,HG);
	double	val25b,val25a,ValMode,PcBlw;
	ValMode=MaxHist(val25b,val25a,PcBlw,HG);
	min=(Int4)round(val25b); max=(Int4)round(val25a);
	fprintf(stderr,
	     "min=%d; max=%d; median=%.2lf; mode=%.2lf; range=%.2lf..%.2lf; %cbelow=%.2lf\n",
		min,max, MedianHist(HG),ValMode,val25b,val25a,'%',100.0*PcBlw);
	NilHist(HG);
	inc=round((double)max/50.0);
	HG=Histogram("Purged seq lengths",0,max,inc);
	FILE	*fp=open_file(argv[1],"_U","w");
	for(i=0; !emptyHeap(dH); i++){ 
	    j=(Int4)round(minkeyHeap(dH));
	    n=delminHeap(dH);
	    if(j >= min && j <= max){
	    	// fprintf(stderr,"%d: %d\n",i,j);
            	Sq=SeqSetE(n,P);
	    	IncdHist((double)LenSeq(Sq),HG);
		PutSeq(fp,Sq,AB);
	    }
	} PutHist(stderr,60,HG); NilHist(HG);
        fclose(fp); Nildheap(dH); NilSeqSet(P);
	// exit(1);
	return 1;
}

Int4	lps_typ::PutMinColCMSA(const char *name, const char *outname,
		Int4 percent_id, double MinCol)
// -mincol=0.80 ; percent_ident=40;
{
        FILE *fp=open_file(name,"","r");
	cma_typ cma=ReadCMSA(fp,AB); fclose(fp);
	h_type HG=Histogram("fraction of residues aligned",0,1,0.025);
	Int4	i,s,J,n,na,N=NumSeqsCMSA(cma),Len=LengthCMSA(1,cma);
	// 1. remove sequences with >= 20% deletions
        BooLean *skip; NEW(skip,N+3,BooLean);
        for(J=1; J <= N; J++){ skip[J]=TRUE; }
        for(n=0,J=1; J <= N; J++){
		for(na=0,s=1 ; s <= Len;s++){
			Int4 r=ResidueCMSA(1,J,s,cma);
			if(r != UndefAlpha(A)) na++; 
		}
		double fr=(double)na/(double)Len;
		if(fr >= MinCol){ skip[J]=FALSE; n++; }
		IncdHist(fr, HG);
	} assert(skip[1]==FALSE);	// should be a consensus seq.
	if(n < 10) {	
		free(skip); TotalNilCMSA(cma);
		print_error("FATAL: Too many deletions in MSA");
	} else if(n != N && n > 0){
		fp=tmpfile(); PutSelectCMSA(fp,skip,cma); 
		TotalNilCMSA(cma); rewind(fp); cma=ReadCMSA(fp,AB); fclose(fp);
	}	// else if(n == N) do nothing...
	if(HG){ PutHist(stderr,60,HG); NilHist(HG); } free(skip);
	

	// this->Purge(percent_id);
	// 2. Purge the MSA at 40% identity
	FILE *efp=0; // efp=stderr;
	set_typ InSet=MakeSet(NumSeqsCMSA(cma)+4); FillSet(InSet);
        set_typ Set=RtnFastRepSetCMSA(efp,percent_id,InSet,cma);
	AddSet(1,Set);
	fp=tmpfile(); PutInSetCMSA(fp,Set,cma); rewind(fp);
	NilSet(Set); NilSet(InSet); TotalNilCMSA(cma);
	cma=ReadCMSA(fp,AB); fclose(fp);

	// 3 Retain no more than 500 seqs...
	N=NumSeqsCMSA(cma);
	// Int4	RandOut=500;	// RandOut=200;
	if(N > Num2Retain){
	  Set=MakeSet(N+4); ClearSet(Set); AddSet(1,Set);
#if 1
          for(n=2; n <= N; n++){ AddSet(n,Set); }
#else
          dh_type dH=dheap(N+10,4);
          for(n=2; n <= N; n++) insrtHeap(n,(keytyp)Random(),dH);
          for(i=1; i < RandOut; i++){
                n=delminHeap(dH); 
		if(n == 0) break; else AddSet(n,Set);
          } Nildheap(dH); 
#endif
	} else {
	  Set=0;
	}
	fp = open_file(outname,"","w"); IronOutCMSA(cma);
	if(Set){ PutInSetCMSA(fp,Set,cma); NilSet(Set); }
	else PutCMSA(fp,cma);
	fclose(fp); TotalNilCMSA(cma);
	return 1;
}

Int4	lps_typ::CD_Hit()
{
    Int4  x,iter,cutoff=40,threshold=5,wrdlen=3;
    for(iter=1; iter <= 3; iter++){
	ArgC=0;
	NEWP(ArgV, 35, char); ArgV[0]=0; ArgV[ArgC]=AllocString("cdhit"); 
	ArgC++; ArgV[ArgC]=AllocString("-i");
	switch(iter){
	  case 1:
	    cutoff=90;threshold=2;wrdlen=5;
	    sprintf(str,"%s_U",argv[1]);
	    ArgC++; ArgV[ArgC]=AllocString(str);
	    break;
	  case 2: 
	    cutoff=65;threshold=2;wrdlen=4;
	    sprintf(str,"%s_U90",argv[1]);
	    ArgC++; ArgV[ArgC]=AllocString(str);
	    break;
	  case 3:
	    cutoff=40,threshold=5,wrdlen=2;
	    // cutoff=40,threshold=5,wrdlen=3;
	    sprintf(str,"%s_U65",argv[1]);
	    ArgC++; ArgV[ArgC]=AllocString(str);
	    ArgC++; ArgV[ArgC]=AllocString("-sc");  // sort clusters by decreasing size.
	    ArgC++; ArgV[ArgC]=AllocString("1");
	    break;
	  default: print_error("LAPIS: this should not happen");
	}
	ArgC++; ArgV[ArgC]=AllocString("-o");
	sprintf(str,"%s_U%d",argv[1],cutoff);
	ArgC++; ArgV[ArgC]=AllocString(str);
	ArgC++; ArgV[ArgC]=AllocString("-c");
	sprintf(str,"0.%d",cutoff);
	ArgC++; ArgV[ArgC]=AllocString(str);
	ArgC++; ArgV[ArgC]=AllocString("-t");
	sprintf(str,"%d",threshold);
	ArgC++; ArgV[ArgC]=AllocString(str);
	ArgC++; ArgV[ArgC]=AllocString("-n");
	sprintf(str,"%d",wrdlen);
	ArgC++; ArgV[ArgC]=AllocString(str);
	ArgC++; ArgV[ArgC]=AllocString("-M");
	ArgC++; ArgV[ArgC]=AllocString("0");
#if 0	// sort seqs by decreasing cluster size; not working.
	ArgC++; ArgV[ArgC]=AllocString("-sf");	
	ArgC++; ArgV[ArgC]=AllocString("1");
#endif
#if defined(_OPENMP)
	if(NumThrds > 1){
	   Int4 max_thrd=omp_get_max_threads();	// maximum that can be used
	   if(NumThrds > max_thrd) NumThrds=max_thrd; 
	   ArgC++; ArgV[ArgC]=AllocString("-T");
	   sprintf(str,"%d",NumThrds);
	   ArgC++; ArgV[ArgC]=AllocString(str);
	}
#endif
	ArgC++;
	for(x=0; x < ArgC; x++) fprintf(stderr,"%s ",ArgV[x]); fprintf(stderr,"\n");
	int rtn=run_cdhit(ArgC,ArgV);
	for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV);
	clock_t tckE=clock() - tckS;
	Int4 tm=time(NULL)-time1;
    	float secs=(float)(tckE)/CLOCKS_PER_SEC;
	fprintf(stderr,"\ttime: %.2e ticks (%d sec; %0.2f min)\n",
		(float)tckE,tm,(float)tm/60.0);
	if(0 && iter < 3){
	   sprintf(str,"%s_U%d.clstr",argv[1],cutoff); std::remove(str);
	}
    } // end iterations
    return 1;
}

Int4	lps_typ::GetBestRepSeqs(FILE *xfp,Int4 N,ss_type P)
// get representatives from the largest _U40 clusters in _U4.clstr file.
// ">" starts a new cluster  
// "*" at the end means that this sequence is the representative of this cluster 
{
	Int4	i,n,c,sz,id,NN=NSeqsSeqSet(P);
	char	*pstr,Str[200],Str2[200];
	FILE *tfp=open_file(argv[1],"_U40.clstr","r");
	for(n=0; (fgets(str,150,tfp)) != NULL; ){
	   if(sscanf(str,">Cluster %d (%d; %d)",&c,&sz,&id) == 3){
		
	   } else if(strchr(str,'*') != NULL){
	   	assert((pstr=strchr(str,'>')) != NULL);
		pstr++; strcpy(Str,pstr);
	   	assert((pstr=strstr(Str,"...")) != NULL);
		*pstr=0;
		//fprintf(stderr,"%d(%d): '%s'\n",n,sz,Str);
		for(i=1; i <= NN; i++){
		   e_type SqE=SeqSetE(i,P);
		   StrSeqID(Str2,100,SqE);
		   if(strstr(Str2,Str) != NULL){
			n++;
			// fprintf(stderr,"%d(%d): '%s' == '%s'\n",n,sz,Str,Str2);
			fprintf(xfp,">REPSQ_%d_%d CD_HIT ",n,sz);
			PutSeq(xfp,SqE,AB);
			break;
		   }
		} assert(i <= NN);
		if(n >= N) break;
	   }
	} return 1;
}

