/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "lps_typ.h"

Int4	lps_typ::GetGismoSeqs()
{
	Int4 i,n,RandOut=SizeGSM; 	// RandOut=1000; RandOut=500; RandOut=250;
	// fp = open_file(argv[1],"_U40","r");
	sprintf(str,"%s_U40",argv[1]);
	ss_type P = SeqSet(str,AB); 
	fp = open_file(argv[1],"_GSM","w");
#if 1
	this->GetBestRepSeqs(fp,RandOut,P);
#else
	// 1. first round: size for gismo == 1000;
        dh_type dH=dheap(NSeqsSeqSet(P)+10,4);
        for(n=1; n <= NSeqsSeqSet(P); n++) insrtHeap(n,(keytyp)Random(),dH);
        for(i=1; i <= RandOut; i++){
                n=delminHeap(dH); 
		if(n == 0) break; else PutSeq(fp,SeqSetE(n,P),AB);
        } Nildheap(dH); NilSeqSet(P); 
#endif
	fclose(fp);
	return 1;
}

Int4	lps_typ::Gismo()
//=============== Run GISMO on repset ==================
{
	Int4	x;
	NEWP(ArgV, argc + 9, char); ArgC=0; 
	ArgV[ArgC]=AllocString("gismo"); ArgC++;
	sprintf(str,"%s_GSM",argv[1]);
	// sprintf(str,"%s_U%d",argv[1],cutoff);
	ArgV[ArgC]=AllocString(str); ArgC++;
	for(x=2; x < argc; x++){
	   ArgV[ArgC]=AllocString(argv[x]); ArgC++;
	}
#if 0	// This is not working; need to fix code.
	Int4 lft_flnk=40,rght_flnk=40;
	sprintf(str,"-I%d:%d",lft_flnk,rght_flnk);
	ArgV[ArgC]=AllocString(str); ArgC++;
#endif
	RunGISMO(ArgC,ArgV,LAPIS_VERSION,USAGE_LAPIS);
	for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV);
        if(output_rtf){
          ArgC=0;
          NEWP(ArgV, 12, char); ArgV[0]=0; ArgV[ArgC]=AllocString(argv[0]);
          ArgC++; ArgV[ArgC]=AllocString(argv[1]);
          ArgC++; ArgV[ArgC]=AllocString("-S");
          ArgC++; ArgV[ArgC]=AllocString("-F7");
          ArgC++; ArgV[ArgC]=AllocString("-S=P");
          ArgC++; ArgV[ArgC]=AllocString("-N=6");
          ArgC++; ArgV[ArgC]=AllocString("-Q"); ArgC++; ArgV[ArgC]=0;
          chn_typ chn(ArgC,ArgV);
          chn.PutHierarchicalAlignment( );
          for(x=0; x < ArgC; x++) free(ArgV[x]); free(ArgV);
        } ArgV=0;
	return 1;
}

Int4	lps_typ::GetTpl()
{
	// 3. twkcma argv[1] -U30
	//==== purge @ 40% && remove fragments with few columns ====

	// sprintf(str,"%s_U%d.cma",argv[1],cutoff);
	sprintf(str,"%s_GSM.cma",argv[1]);	// source MSA.
	char *tmpStr=AllocString(str);
#if 1	
	sprintf(str,"%s.tpl",argv[1]);	// target MSA with mincol=80%
	this->PutMinColCMSA(tmpStr,str,percent_id,MinCol);
	// std::rename(tmpStr,str);
	free(tmpStr);
#else	//========== rerun gismo on domain regions only. ===========
	sprintf(str,"%s_M80.cma",argv[1]);
	PutMinColCMSA(tmpStr,str,percent_id,MinCol);
	// std::rename(tmpStr,str);
	free(tmpStr);

	Int4	left_flank=40,right_flank=40;
	sprintf(str,"%s_M80.cma",argv[1]);
	cma_typ tcma=ReadCMSA2(str,AB);
	//--------- remove first (consensus) seq ----------
	Int4 N=NumSeqsCMSA(tcma);
	BooLean	*skip; NEW(skip,N+3,BooLean); skip[1]=TRUE;
        fp = tmpfile(); // open_file(argv[1],".new.cma","w");
        PutSelectCMSA(fp,skip,tcma); rewind(fp);
	TotalNilCMSA(tcma);
	tcma=ReadCMSA(fp,AB); fclose(fp); free(skip);
	//---------- end -----------
        fp=open_file(argv[1],"_S","w");
	PutSeqWithFlanksCMSA(fp,left_flank,right_flank,tcma);
	fclose(fp); TotalNilCMSA(tcma);

	// sprintf(str,"%s_U%d",argv[1],cutoff);
	ArgC=0; ArgV[ArgC]=AllocString("gismo"); ArgC++;
	sprintf(str,"%s_S",argv[1]);
	ArgV[ArgC]=AllocString(str); ArgC++;
	for(x=2; x < argc; x++){ ArgV[ArgC]=AllocString(argv[x]); ArgC++; }
	RunGISMO(ArgC,ArgV,LAPIS_VERSION,USAGE_LAPIS);
// Is coredumping in RunGISMO!!!
// Due to Sets issue??
	for(x=0; x < ArgC; x++) free(ArgV[x]); 
	// std::rename(ArgV[1],str);

	sprintf(str,"%s_S.cma",argv[1]);	// source MSA.
	tmpStr=AllocString(str);
	sprintf(str,"%s.tpl",argv[1]);	// source MSA.
	std::rename(tmpStr,str);
#endif
	return 1;
}

