/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "cdd2cma.h"
#include "ftc_typ.h"
#include "cdd2mgs_usage.h"

// int	cdd2cma(int argc,char *argv[]) { return cdd2cma(0,argc,argv,20000); }
// int	cdd2cma(FILE *fp, int argc,char *argv[]) { return cdd2cma(0,argc,argv,20000); }

#if 0
#define USAGE_START "Usage: cdd2mgs <cdd_dir> <target_dir> <cd_ident> [options] \n\
  Input: CDD hierarchal alignments in NCBI mfasta directory format.\n\
	   Download tarball from the NCBI: ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/hiMSA\n\
	   Uncompress and extract the files (one subdirectory for each domain)\n\
	   <cdd_dir> = the main directory containing all of the cd hiMSAs\n\
	   <target_dir> = the directory into which output files will be created\n\
	   <cd_ident> = the identifier for the hiMSA (e.g., 'cd01067')\n\
  Output: Concatenated *.cma files annotated consistent with template.\n\
          This output files are used as input to MAPGAPS.\n\
       \n\n"
#endif

#if 0
       -O=<str>    output filename=<str>\n\
       -depth=<int> print tree as a hpt, but only to depth <int> from root\n\
\n
#endif

static void	PrintError(const char *usage,const char *version)
{ fprintf(stderr,"%s",version); print_error(usage); }

int     main(int argc,char *argv[])
{
	Int4    i,j,n,arg;
	FILE	*ifp,*ofp,*mmafp=0,*tplfp=0,*cmafp=0;
	char	c,*cd_dir,*target_dir,*cd_id,str[1000];

	TurnOffLicenseStatement();
	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	if(argc < 4) PrintError(USAGE_CDD2MGS,CDD2MGS_VERSION);
	cd_dir=argv[1];
	target_dir=argv[2];
	cd_id=argv[3];

	//============ copy the .ph file to target directory as (.nwt file) =====
	// cp -f $CDD_DIR/${file}/${file}_newick.ph ./dir_${file}/MAPGAPS/${file}.nwt
	// sprintf(str,"%s/%s/%s_newick",cd_dir,cd_id,cd_id);
	sprintf(str,"%s/%s_newick",cd_dir,cd_id);
	ifp=open_file(str,".ph","r");
	sprintf(str,"%s/%s",target_dir,cd_id);
	ofp=open_file(str,".nwt","w");
	while((c=fgetc(ifp))!=EOF){ fputc(c,ofp); } fclose(ifp); fclose(ofp);

	//==================== convert fasta files to cma format =============
	//  open cdd_dir/file/root_template_${file}.FASTA
	sprintf(str,"%s/root_template_%s",cd_dir,cd_id,cd_id);
	ifp=open_file(str,".FASTA","r");
	ftc_typ *ftc= new ftc_typ(cd_id,AB); 
	cma_typ cma=ftc->FaToCMA(ifp); fclose(ifp); delete ftc;
	sprintf(str,"%s/%s",target_dir,cd_id);
	ofp=open_file(str,".tpl","w"); // ReNameCMSA(cd_id,cma); 
	LabelSeqsCMSA(cma); PutCMSA(ofp,cma); fclose(ofp);

	//================ create subgroup mma file =============
	sprintf(str,"%s/%s",target_dir,cd_id);
	ofp=open_file(str,".mma","w"); // ReNameCMSA(cd_id,cma); 
	// WARNING: need to utilze the tree structure!!!
	for(i=2; i <= NumSeqsCMSA(cma); i++){
		e_type E=TrueSeqCMSA(i,cma);
		StrSeqID(str,100,E);
		char *sbgrp=AllocString(str);
		// template_cd08919.FASTA
		// cd08920.FASTA
		sprintf(str,"%s/%s",cd_dir,sbgrp);
		ifp=open_file(str,".FASTA","r"); 
		ftc= new ftc_typ(sbgrp,AB); 
		cma_typ tcma=ftc->FaToCMA(ifp); fclose(ifp); delete ftc;
		LabelSeqsCMSA(tcma); PutCMSA(ofp,tcma); 
		free(sbgrp);
	}
	fclose(ofp); // = *.mma

	//============== run cdd2mgs?? =================
	char    *Argv[20];
	Int4    Argc=0;
	Argv[Argc]=AllocString("cdd2mgs"); Argc++;
	sprintf(str,"%s/%s",target_dir,cd_id);
	Argv[Argc]=AllocString(str); Argc++;
	cdd2cma(Argc,Argv,0,Argv[1]);	// creates *_Out files from 
	for(i=0; i < Argc; i++) free(Argv[i]);
	TotalNilCMSA(cma); NilAlpha(AB);
	return 0;
}

