/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "ftc_typ.h"

void	ftc_typ::PressSeq(FILE *ifp, FILE *ofp)
{
	char	c,state='S',last='\n';
	Int4	num=0;
	while((c=fgetc(ifp))!=EOF){ 
		if(last == '\n' && c=='>'){ if(num > 0) fputc('\n',ofp); num++; state = 'D'; }
		else if(c=='\n'){ if(state == 'D') fputc('\n',ofp); state = 'S';  }
		if(state == 'S' && !isspace(c) && c != '\n') fputc(c,ofp); 
		else if(state == 'D'){ fputc(c,ofp); }
		// else if(c == '\n') fputc(c,ofp);
		last=c;
	} fputc('\n',ofp);
}

void	ftc_typ::put_cma_seq(FILE *ofp,char *text, Int4 leng)
{
	unsigned long i,j,match,insert,del;
	unsigned long SeqOffSet=0;
        char    MatchFound=0;
	char c;
	if(num < 1) { fprintf(stderr,"Input error: num = %d\n",num); exit(1); }
	if(num == 1){	// then get Master state information
	   for(Length=i=0; i < leng; i++){
		if(isalpha(text[i])){
			Length++;
			if(Begin==ULONG_MAX) Begin=i;
			End=i;
			MasterSeq[i]='m'; // match state.
		} else if(text[i] == '.' || text[i] == '-'){
			MasterSeq[i]='d'; // del state.
		} else { 
			fprintf(stderr,"text[%d]='%c'\n",i,text[i]);
			fprintf(stderr,"Input error\n"); exit(1); 
		}
	   }
	   fprintf(ofp,"(%d)",Length);
	   for(i=1; i <= Length; i++) fprintf(ofp,"*"); fprintf(ofp,"\n"); 
	   fprintf(ofp,"\n");
	} 
// fprintf(stderr,"text=%s\nMstr=%s\n\n",text,MasterSeq);;
	for(match=insert=del=0, j=0,i=Begin; i <= End; i++){
		c=text[i];
		if(isalpha(c)){
				if(MasterSeq[i]=='m'){		// a match in subject
				   Seq[j]=toupper(c); j++;
				   match++;
				   MatchFound=1;
				} else if(MasterSeq[i]=='d'){  // an insert in subject
				   Seq[j]=tolower(c); j++;
				   insert++;
				   if(!MatchFound) SeqOffSet++;
				} else { 
				   fprintf(stderr,"text[%d]='%c'\n",i,text[i]);
				   fprintf(stderr,"Input error\n"); exit(1); 
				}
		} else if(c == '.' || c == '-'){
				if(MasterSeq[i]=='m'){		// a deletion in subject
				   Seq[j]= '-';	j++;
				   del++;
				} else if(MasterSeq[i]=='d'){  // ignore (collapse) these positions 
				   ;
				}
		} Seq[j]=0;
	}
// fprintf(stderr,"%s\n{()%s()}*\n\n",SeqId,Seq);
	fprintf(ofp,"$%d=%d(%d):\n",num,match+insert,match+del);
	fprintf(ofp,"%s [os=%d]\n{()%s()}*\n\n",SeqId,SeqOffSet,Seq);
	// fprintf(stderr,"$%d=%d(%d):\n",num,match+insert,match+del);
	// fprintf(stderr,"%s [os=%d]\n{()%s()}*\n\n",SeqId,SeqOffSet,Seq);
}

cma_typ ftc_typ::FastaToCMSA(FILE *ifp)
{
	char	last='\n',c,state=' ';
	Int4	len,i,j,n,N=0,Max=INT4_MAX;
	char	*text;
	FILE	*ofp=0;
	cma_typ	cma=0;

	ofp=stderr; ofp=tmpfile();
	for(i=n=0,last='\n'; (c=fgetc(ifp))!=EOF; last=c){ 
		if(last == '\n' && c=='>'){ Max=i; i=0; n++; }
		last=c; i++;
	} N=n; rewind(ifp); 
	NEW(text,Max+5,char);
	for(num=0,last='\n'; (c=fgetc(ifp))!=EOF; ){ 
		while(num==0 && c != '>' && c != EOF){ c=fgetc(ifp); }
		if(last == '\n' && c=='>'){
                   num++;
                   if(num==1){
                        fprintf(ofp,
			   "[0_(1)=%s(%d){go=10000,gx=2000,pn=1000.0,lf=0,rf=0}:\n",
				name,N);
                   }
                   for(i=0; c != '\n' && c != EOF; i++){
			if(i < 500) SeqId[i]=c;
			c=fgetc(ifp); 
			if(c == '\n') break;
			// fprintf(stderr,"%c",c);
		   } last=c;
		   if(i > 500) i=500; SeqId[i]=0; 
		   if(c==EOF) break; else ungetc(c,ifp);
		}
		while(isspace(c) && c != EOF) c=fgetc(ifp); 
		if(c == EOF) break;
                for(j=0; c != '\n' && c != EOF; ){
			text[j]=c; j++; last=c; c=fgetc(ifp);
		} 
		// text[j]='\n'; text[j+1]=0;
		text[j]=0; len=strlen(text);
// fprintf(stderr,"%d(%d):%s\n%s\n\n",num,len,SeqId,text);
		if(1 && len > 0){ 
			put_cma_seq(ofp,text,len);
		} last='\n';
	} fprintf(ofp,"_0].\n\n"); 
	rewind(ofp); 
	free(text); // free(MasterSeq); free(Seq);
	cma=ReadCMSA(ofp,AB); fclose(ofp);
	return cma;
}

