#if !defined (CDD2MGS_USAGE)
#define CDD2MGS_USAGE

#define CDD2MGS_VERSION "\
  ----------------------------------------------------\n\
     CDD2MGS v1.0.3 (May 11, 2022)\n\
     www.igs.umaryland.edu/labs/neuwald/software/mapgaps/\n\
     Copyright 2019-2022 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_CDD2MGS "\
  Usage: cdd2mgs <cdd_dir> <target_dir> <cd_ident> [options] \n\
  Input: CDD hierarchal alignments in NCBI mfasta directory format.\n\
           Download input files from the NCBI: ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/hiMSA\n\
           <cdd_dir> = the directory containing the downloaded files\n\
           <target_dir> = the directory into which output files will be created\n\
           <cd_ident> = the identifier for the hiMSA (e.g., 'cd01067')\n\
  Output: Concatenated *.cma files annotated consistent with template.\n\
          This output files are used as input to MAPGAPS.\n\
  Note: Download NCBI Conserved Domain hiMSAs via anonymous ftp using command:\n\
          'ftp ftp.ncbi.nih.gov' and 'cd pub/mmdb/cdd/hiMSA/' \n\
  Reference: Neuwald AF, Lanczycki CJ, Hodges TK, Marchler-Bauer A. 2020 Obtaining\n\
          extremely large and accurate protein multiple sequence alignments from curated\n\
          hierarchical alignments.  Database doi: 10.1093/database/baaa042. PMID: 32500917 \n\
  Funding provided by the National Institutes of Health, National Institute of \n\
        General Medical Sciences grant R01GM125878.\n\
\n\n"

#endif

