#if !defined (BPPS_USAGE)
#define BPPS_USAGE

#define BPPS_VERSION "\
  ----------------------------------------------------\n\
     BPPS v1.1.6 (September 3, 2019)\n\
     www.igs.umaryland.edu/labs/neuwald/software/mapgaps/\n\
     Copyright 2019 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_BPPS "\
  Bayesian Partitioning with Pattern Selection\n\
  Usage: bpps <mode> <prefix> [options]\n\
  Options:\n\
     mode = 1: Initial hierarchical partitioning of MSA into subgroups.\n\
        Usage: bpps 1 <prefix> [options]\n\
           type \"bpps 1\" for options\n\
     mode = 2: Create a hiMSA from output from mode 1.\n\
        Usage: bpps 2 <prefix> [options]\n\
           type \"bpps 2\" for options\n\
           creates <prefix>_himsa.* files as input to BPPS 3\n\
     mode = 3: Create a contrast alignment for <int>th node (& optional pymol script).\n\
        Usage: bpps 3 <prefix> <int> [options]\n\
           type \"bpps 3\" for options\n\
     mode = A: Run steps 1-3 using default options with optional structural mapping.\n\
        Usage: bpps A <prefix> [pdb_paths]\n\
          [pdb_paths] is an optional file listing paths to pdb coordinate files\n\
            list one pdb path per line (e.g., /tmp/pdb_nat/4ag9_H.pdb)\n\
     mode = Q: Query-centric bpps run (step 1 only).\n\
        Usage: bpps Q <prefix1> <int> [options]\n\
          type \"bpps Q\" for options\n\
          The <int>th sequence in the input MSA file is the query.\n\
     mode = E: Evaluate the consistency between hierarchies.\n\
        Usage: bpps E <prefix1> <prefix2> [options]\n\
          type \"bpps E\" for options\n\
          requires MSA (.mma) & checkpoint (.chk) files from bpps 1 or bpps Q as input\n\
        Note: <prefix1>.mma file must be identical to <prefix2>.mma file.\n\
     mode = H: BPPS with an non-tree hyperpartition\n\
        Usage: bpps H <prefix> [options]\n\
          type \"bpps H\" for options\n\
          Requires an MSA (.mma), a hyperpartition (.hpt) and seed MSA (.sma) as input\n\
        Note: Can be used to obtain an updated MSA (as <prefix>_new.mma)\n\
   Reference:\n\
     Neuwald, A.F., L. Aravind & S.F. Altschul. Inferring Joint Sequence-Structural Determinants\n\
        of Protein Functional Specificity. eLife 2018. doi: 10.7554/eLife.29880.001.\n\
   Funding provided by the National Institutes of Health, National Institute of\n\
        General Medical Sciences grants R01GM078541 & R01GM125878.\n\
\n"

#if 0

     mode = U: Update an existing hierarchy based on a new MSA (not yet working)\n\
        Usage: bpps U <new_infile> <old_infile> [options]\n\
          type 'bpps U' for options\n\
          <old_infile> = MSA (.mma) & checkpoint (.chk) files from bpps 1\n\

#endif

#endif

