/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

BooLean	RtnOffSet(res_typ *ResAI,res_typ *ResAJ,Int4 numResI, Int4 numResJ,Int4 &OS,a_type AB)
{
	Int4	i,j,si,sj,os;
	char	cI,cJ,okay=0;
	res_typ	ResI,ResJ;
	for(OS=os=0; os < numResI; os++){
	    i=os; j=0; okay=0;
	    do {
	      j++; if(j > numResJ){ OS=os; okay=1; break; }
	      i++; if(i > numResI){ OS=os; okay=1; break; }
	      si=ResidueID(ResAI[i]); cI=GetCharResidue(ResAI[i],AB); 
	      sj=ResidueID(ResAJ[j]); cJ=GetCharResidue(ResAJ[j],AB); 
	      // fprintf(stderr,"os=%d: %c%d (i=%d) vs %c%d (j=%d)\n",os,cI,si,i,cJ,sj,j);
	    } while(cI == cJ || cI=='X' || cJ == 'X');
	    if(okay) return TRUE;
	} return FALSE;
}

// from dcm_run.cc
#if 0	//********* Testing Relative Entropy effect *****************************
#if 0	//*********************************************************************
    {
        assert(MtrxBPPS); assert(N==L);
	set_typ SetRO=MakeSet(N+3),SetRI=MakeSet(N+3),SetBO=MakeSet(N+3),SetBI=MakeSet(N+3);
	for(Int4 m=1; m <= pos[X]; m++){  // consider only high DCA scoring pairs...
	     // if(m > Pos[x]) continue;	
	     n=SortedByScoreDCA[m];
	     Int4 i=n2i[n],j=n2j[n];
	     if(!(MtrxPDB[i][j] > 0 && Used[i][j])) continue;
	     if(MtrxPDB[i][j] <= MaxDist) {	/// Out balls...
	        if(MemberSet(n,SetBP)){	AddSet(n,SetRO); } // red == high RE pairs...
		else { AddSet(n,SetBO); }
	     } else {		// In balls...
	        if(MemberSet(n,SetBP)){	AddSet(n,SetRI); } // red in...
		else { AddSet(n,SetBI); }
	     }
	} // PutSet(stderr,SetBPPS);	// DEBUG...
	ro=CardSet(SetRO); ri=CardSet(SetRI); bo=CardSet(SetBO); bi=CardSet(SetBI);
	if(0) fprintf(stderr,"ri=%d; ro=%d; bi=%d; bo=%d; biu=%.3Lg.\n",
				ri,ro,bi,bo,biu);
	biu = OneTailCumHyperGeomProb(ro+ri,bo+bi,ro);
	red = ri+ro; black = bi + bo; numO=ro+bo; numX=ro+bo; redout=ro;
	if(0){
	  fprintf(stderr," Consider only the %d (=X) highest DCA-scoring pairs\n",red+black);
	  fprintf(stderr," Red pairs = %d highest RE-scoring among these pairs.\n", red);
	  fprintf(stderr," Black pairs = %d lower RE-scoring pairs.\n", black);
	  fprintf(stderr," Out = %d pairs <= %.2f Angstroms apart\n", ro+bo,MaxDist);
	  fprintf(stderr," In = %d pairs > %.2f Angstroms apart\n", ri+bi,MaxDist);
	  fprintf(stderr," Red out = %d high RE-scoring pairs <= %.2f Angstroms apart\n", ro,MaxDist);
	  fprintf(stderr," Red in = %d high RE-scoring pairs > %.2f Angstroms apart\n", ri,MaxDist);
	  fprintf(stderr,"  biu p=%.3Lg;",biu);
	  fprintf(stdout,"  -log10(p)=%.3Lf.\n",-log10l(biu));
	} NilSet(SetRI); NilSet(SetRO); NilSet(SetBI); NilSet(SetBO); 
   }
#else	// alternative for relative entropy testing...
    {
        assert(MtrxBPPS); assert(N==L);
	set_typ SetRO=MakeSet(N+3),SetRI=MakeSet(N+3),SetBO=MakeSet(N+3),SetBI=MakeSet(N+3);
	for(Int4 m=1; m <= L; m++){
	     n=SortedByScoreDCA[m];
	     if(!MemberSet(n,SetBP)) continue;	// consider high RE pairs only. 
	     Int4 i=n2i[n],j=n2j[n];
	     // if(!(MemberSet(i,SetBPPS) && MemberSet(j,SetBPPS))) continue; 
	     if(!(MtrxPDB[i][j] > 0 && Used[i][j])) continue;
	     if(m <= pos[X]){	// Out balls...
		if(MtrxPDB[i][j] <= MaxDist) {	AddSet(n,SetRO); }	// Red == contacts.
		else { AddSet(n,SetBO); }
	     } else {		// In balls...
		if(MtrxPDB[i][j] <= MaxDist) {	AddSet(n,SetRI); }	// Red == contacts.
		else { AddSet(n,SetBI); }
	     }
	}
	// PutSet(stderr,SetBPPS);	// DEBUG...
	ro=CardSet(SetRO); ri=CardSet(SetRI); bo=CardSet(SetBO); bi=CardSet(SetBI);
	if(0) fprintf(stderr,"ri=%d; ro=%d; bi=%d; bo=%d; biu=%.3Lg.\n",
				ri,ro,bi,bo,biu);
	biu = OneTailCumHyperGeomProb(ro+ri,bo+bi,ro);
	red = ri+ro; black = bi + bo; numO=ro+bo; numX=ro+bo; redout=ro;
	if(0){
	  fprintf(stderr," Consider only the %d highest RE-scoring pairs\n",red+black);
	  fprintf(stderr," Red pairs = %d highest DCA-scoring among these pairs.\n", red);
	  fprintf(stderr," Black pairs = %d lowest DCA-scoring among these pairs.\n", black);
	  fprintf(stderr," Out = %d pairs <= %.2f Angstroms apart\n", ro+bo,MaxDist);
	  fprintf(stderr," In = %d pairs > %.2f Angstroms apart\n", ri+bi,MaxDist);
	  fprintf(stderr," Red out = %d high DCA-scoring pairs <= %.2f Angstroms apart\n", ro,MaxDist);
	  fprintf(stderr," Red in = %d low DCA-scoring pairs <= %.2f Angstroms apart\n", ri,MaxDist);
	  fprintf(stderr,"  biu p=%.3Lg;",biu);
	  fprintf(stdout,"  -log10(p)=%.3Lf.\n",-log10l(biu));
	} NilSet(SetRI); NilSet(SetRO); NilSet(SetBI); NilSet(SetBO); 
   }
#endif	//***********************************************************************
#endif	//**************** End of Relative Entropy test *************************
