/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

int     main(int argc, char *argv[])
{
	long double NegLog10P;
	Int4 NumPairsL;
        int	arg,Argc=0;
        char	*Argv[50],str[20];
	Int4	i,j;
// for(i=0; i < argc; i++) fprintf(stderr,"%d %s\n",i,argv[i]);
	edc_typ *edc= new edc_typ(argc,argv);
	dci_typ *dci=edc->RunDCA( ); 
	if(dci){ 
	        if(edc->DoShowPairs()) dci->Put(stdout);
		char *Chns=edc->RtnChains(); 
		if(edc->UsePPV){
		   fprintf(stdout,"mthd\tchn\tr(A)\tPPV\tBIU\tL\tD\tX\td\tR\tF\n");
		   dci->PutResults(stdout,'M',Chns);
		} else dci->PutResults(stdout,edc->Mode,Chns); 
		free(Chns);
	        Int4 *bpps=edc->RtnBPPS();
	        set_typ SetB=0;
	        if(bpps){
		    SetB=MakeSet(5000);
		    for(i=1; i <= bpps[0]; i++) AddSet(bpps[i],SetB);
		    if(0 && SetB) PutSet(stdout,SetB);
	        }
	  	if(edc->DoShowPairs()){
	          fprintf(stdout,"highest DCA scoring pairs in %s %s\n", argv[1],argv[2]);
		  dci->PutBest(stdout,edc->ShowPairs,SetB);
	        } delete dci; 
	} delete edc;
	return 0;
}

