/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#include "edc_typ.h"

Int4	*dcm_typ::stdh_typ::SortArrayDCA(FILE *fp,FILE *dcfp,Int4 num_dc, char *chns)
//===========  3. Sort all residue pairs based on their DC-scores. ============
{
	Int4	ith_DC,i,CntBPPS=0,cntBPPS=0,cntLine=0,Line=0;
	Int4	*SortedByScoreDCA; NEW(SortedByScoreDCA,LLL+5,Int4);
	FILE	*afptr=that->afptr,*efptr=that->efptr;
	// fprintf(stderr,"items in heap;%d\n",ItemsInHeap(dH_dca));
	h_type HG=Histogram("BPPS pairs per line",0,150,1.0);
	SetBP=CopySet(SetPDB); ClearSet(SetBP);
	if(afptr && fp && that->MtrxBPPS){
	    fprintf(afptr,"\n=========== ICA array(%s): ===========\n",that->PDBID);
	} else if(afptr && fp){
	    fprintf(afptr,"\n=========== DCA/3D array(%s %c): ===========\n",
		FilenamePDB(that->PDB),that->KeyChain);
	}
	FILE *tfp=0; 
	// Int4 numX=0,numD=0,numB=0,numO=0,numAll=0;
	numX=0;numD=0;numB=0;numO=0;numAll=0;
	// long double biu;
	for(ith_DC=1,i=1; !emptyHeap(dH_dca); i++) {
		double dP = (double) minkeyHeap(dH_dca);
		assert((n=delminHeap(dH_dca)) != 0); SortedByScoreDCA[i]=n;
		//========= Print out direct couplings used for pymol scripts. ==========
		if(dcfp && ith_DC <= num_dc){
		   if(MemberSet(n,SetPDB)){ 
		     Int4 xi=n2i[n],xj=n2j[n]; 
		     Int4 ii=n2I[n]-that->dca2pdbOS,jj=n2J[n]-that->dca2pdbOS; 
		     char chnI=that->AdjChn[xj][xi],chnJ=that->AdjChn[xi][xj],flag='*';
		     if(chnI) chnJ=that->KeyChain;
		     else if(chnJ) chnI=that->KeyChain;
		     else chnI=chnJ=flag=' ';
		     if(flag =='*' || chns[1] == 0){
		       fprintf(dcfp,"%d\t%c%d%c\t%c%d%c\t%.2f\t%.3f\t%c",i,n2cI[n],ii,chnI,
				n2cJ[n],jj,chnJ, that->MtrxPDB[xi][xj],
				-that->MtrxDCA[xi][xj],flag);
		       if(chns[1] == 0) fprintf(dcfp,"\n"); else fprintf(dcfp,"\t%s\n",chns);
		     } ith_DC++;
		   } else if(0){	// print out non-discriminating pairs as well
		     Int4 xi=n2i[n],xj=n2j[n]; 
		     Int4 ii=n2I[n]-that->dca2pdbOS,jj=n2J[n]-that->dca2pdbOS; 
		     fprintf(dcfp,"(%d\t%c%d\t%c%d\t%.2f\t%.3f)",i,n2cI[n],ii,n2cJ[n],jj,
				that->MtrxPDB[xi][xj],-that->MtrxDCA[xi][xj]);
		   }
		}
		//========== 3b. Print out the ICA array. ==========
		if(afptr && fp){
		   if(that->MtrxBPPS){	// Include BPPS information in the array.
		     Int4 ii=n2i[n],jj=n2j[n];
		     if(that->MtrxBPPS[ii][jj] > 0){ AddSet(n,SetBP);}
		     if(MemberSet(n,SetPDB) && that->MtrxBPPS[ii][jj] > 0){
			fprintf(afptr,"O");  numO++; 
		     } else if(MemberSet(n,SetPDB)){ fprintf(afptr,"D"); numD++; }
		     else if(that->MtrxBPPS[ii][jj] > 0){ 
if(0){	// DEBUG...
  res_typ ResI=that->ResALL[ii],ResJ=that->ResALL[jj];
  Int4 I=ResidueID(ResI),J=ResidueID(ResJ);
  fprintf(stderr,"%d: ii=%d; jj=%d; resI=%d; resJ=%d; MtrxDCA=%.3f\n",
		n,ii,jj,I,J,that->MtrxDCA[ii][jj]);
}
			fprintf(afptr,"B"); numB++; 
		     } else fprintf(afptr,".");  numAll++;
		     if(MemberSet(n,SetPDB) && that->MtrxBPPS[ii][jj] > 0){
			cntBPPS++; cntLine++;
		     } else if(!MemberSet(n,SetPDB) && that->MtrxBPPS[ii][jj] > 0){
			CntBPPS++; cntLine++; 
		     }
		     if(i%100 == 0) {
			fprintf(afptr,"(%d)\n",cntLine);  Line++;
			IncdMHist(Line, cntLine, HG); cntLine=0; 
		     }
		   } else {
		     if(MemberSet(n,SetPDB)){
		      if(Rank[n] < 10) fprintf(afptr,"%d",Rank[n]); 
		      else if(Rank[n] <= 35) fprintf(afptr,"%c",'A'+(char)(Rank[n]-10)); 
		      else if(0 && Rank[n] <= 49) fprintf(afptr,"#"); // for STARC paper...
		      else fprintf(afptr,"*"); 
		     } else fprintf(afptr,".");
		     if(i%100 == 0) fprintf(afptr,"\n");
		   }
		//========== 3c. Else obtain BPPS information only. ===========
		} else if(that->MtrxBPPS){
		     Int4 ii=n2i[n],jj=n2j[n];
		     if(that->MtrxBPPS[ii][jj] > 0){ AddSet(n,SetBP);}
		     if(MemberSet(n,SetPDB) && that->MtrxBPPS[ii][jj] > 0){ numO++; }
		     else if(MemberSet(n,SetPDB)){ numD++; }
		     else if(that->MtrxBPPS[ii][jj] > 0){ numB++; }
		     numAll++;
		}
	} // Nildheap(dH_dca); 

        if(that->MtrxBPPS && efptr && fp){
                IncdMHist(Line, cntLine, HG);
                fprintf(efptr,"\n"); PutHist(stderr,60,HG);
                fprintf(efptr,"\ncntBPPS=%d (%d blocked); num bpps=%d\n",
			CntBPPS,cntBPPS,that->bpps[0]);
        }
        if(efptr && fp) fprintf(efptr,"\n");
        if(afptr && fp){
            fprintf(afptr,"\n");
            if(0) {
		fprintf(afptr,"\n   symbols: 'B' = BPPS pair; 'D' = 3D contact pair; ");
                fprintf(afptr,"'O' = 'B' & 'D'; '.' = none.\n");
	    }
        } NilHist(HG);
	return SortedByScoreDCA;
}

Int4	dcm_typ::stdh_typ::LoadUp( )
// There is a problem with this routine...
{
	Int4	i,j,II,JJ,N;
	for(n=0,i=1; i < that->num_resC; i++){
           II=ResidueID(that->ResALL[i]);
	   for(j=i+1; j <= that->num_resC; j++){
		JJ=ResidueID(that->ResALL[j]);  // EV-fold requires |JJ-II| > 5.
              	if(abs(II-JJ) <= that->MinSqSeparation) continue;       
              	// fprintf(stderr,"%d: %d vs %d\n",i,II,JJ);
              	if(that->MtrxPDB[i][j] > 0 && that->Used[i][j]){  // is pair legitimate?
		   this->Insert(i,j,II,JJ);
		}
	   }
	} N=ItemsInHeap(dH_pdb); assert(n == N); assert(ItemsInHeap(dH_dca) == N);
	MaxDist=that->MaxDist; LLL=N;
	return N;
}

Int4  dcm_typ::stdh_typ::ShuffleRanks()
{
//============ 2'. Shuffle the ranks if performing simulations. ============
	Int4 i,*Tmp=0; NEW(Tmp,MM+5,Int4);
        dh_type dH = dheap(MM+5,4);
        for(i=1; i <= LLL; i++){ if(MemberSet(i,SetPDB)) insrtHeap(i,(keytyp)Random(),dH); }
        for(i=1; !emptyHeap(dH); i++) {
                if(!MemberSet(i,SetPDB)) continue;
                assert((n=delminHeap(dH)) != 0);
                Tmp[i]=Rank[n];
        } free(Rank); Rank=Tmp; Nildheap(dH);
}

Int4	dcm_typ::stdh_typ::MkArrayPDB( )
//============ 2. Pick D closest 3D pairs as the distinguished set. ============
{
	assert(MaxDist > 0);
        SetPDB=MakeSet(MM); NEW(Rank,MM+5,Int4);
        for(Int4 i=1; !emptyHeap(dH_pdb); i++) {
                dD=(float) minkeyHeap(dH_pdb); assert((n=delminHeap(dH_pdb)) != 0);
                if(dD > MaxDist) break;
                AddSet(n,SetPDB); Rank[n]=i; // i = rank of 3D-scored distinguishing pair.
		// if(i >= NumDistinguished) break;
        }
#if 0
        dD=(float) minkeyHeap(dH_pdb); assert((n=delminHeap(dH_pdb)) != 0);
        assert(dD > MaxDist);
#endif
	Nildheap(dH_pdb); dH_pdb=0;
	return 0;
}

Int4	dcm_typ::stdh_typ::Insert(Int4 i, Int4 j, Int4 II, Int4 JJ)
{
	n++;    // pair identifier == n;
        insrtHeap(n,(keytyp)that->MtrxPDB[i][j],dH_pdb);
        insrtHeap(n,(keytyp)that->MtrxDCA[i][j],dH_dca);
        // fprintf(stderr,"MD[%d][%d]=%.4f\n",i,j,MtrxDCA[i][j]);
        n2i[n]=i; n2j[n]=j;
        if(that->TheOtherMtrx){ n2d[n]=that->TheOtherMtrx[i][j] - that->MtrxPDB[i][j]; }
	else { n2d[n]=that->MtrxPDB[i][j]; }
        n2dc[n]=that->MtrxDCA[i][j];
        n2I[n]=II+that->dca2pdbOS; n2J[n]=JJ+that->dca2pdbOS;
        n2cI[n]=GetCharResidue(that->ResALL[i],that->AB); 
	n2cJ[n]=GetCharResidue(that->ResALL[j],that->AB);
        // PrintResidueAtoms(stderr,ResALL[i]); PrintResidueAtoms(stderr,ResALL[j]);
}

void	dcm_typ::stdh_typ::Init()
{
	numX=0;numD=0;numB=0;numO=0;numAll=0;
	SetPDB=SetBP=0; Rank=0; LLL=0;
	NEW(n2cI, MMP+9, char); NEW(n2cJ, MMP+9, char); 
	NEW(n2i, MMP+9, Int4); NEW(n2j, MMP+9, Int4);
        NEW(n2I, MMP+9, Int4); NEW(n2J, MMP+9, Int4); 
	NEW(n2d, MMP+9, float); NEW(n2dc, MMP+9, float);
        dH_pdb=dheap(MM+5,4); dH_dca=dheap(MM+5,4);
}

void	dcm_typ::stdh_typ::Free()
{ 
	if(SetPDB) NilSet(SetPDB);
	if(SetBP) NilSet(SetBP);
	if(Rank) free(Rank);
	if(n2i) free(n2i); if(n2j) free(n2j); 
	if(n2d) free(n2d); if(n2dc) free(n2dc); 
	if(n2I) free(n2I); if(n2J) free(n2J); 
	if(n2cI) free(n2cI); if(n2cJ) free(n2cJ);
	if(dH_pdb) Nildheap(dH_pdb); if(dH_dca) Nildheap(dH_dca);
}

