/****
A Gibbs Sampler algorithm for finding multiple sites in multiple sequences 
****/
#include "gibbs.h"

void	PutWilcoxBGibbs(FILE *fptr,Int4 first, Int4 last, Int4 t, gs_type G)
/* Wilcoxon using MAP sampled probabilities and sites */
{
	ss_type	P=G->data;
	Int4	n,s,N;
	double	***prob,p;
	e_type	E;
   
	if(G->readprob==NULL) print_error("Wilcox() error");
	prob = G->readprob; N = NSeqsSeqSet(P);
	fprintf(fptr,"\n\n");
	first = MAX(Int4,1,first); first = MIN(Int4,first,N);
	last = MAX(Int4,1,last); last= MIN(Int4,last, N);
	for(n=first; n<= last; n++){
	   E=SeqSetE(n,P);
	   for(s=1; s<=(Int4)LenSeq(E); s++){
	     p=prob[t][n][s];
	     if(p >= G->readcutoff){
		if(first == 1) fprintf(fptr,"0 %.4f\n",p);
		else fprintf(fptr,"%.4f 0\n",p);
	     }
	   }
	}
	fprintf(fptr,"\n\n");
}

