/* defines.h - generic codes and constants for afn biosequence programs. */
#if !defined(STDINC)
#define STDINC
#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <float.h>
#include <math.h>

/* VALUES */
#define NIL    		-1
#define FALSE		0	
#define TRUE		1	

#define ILLEGAL		-1.0
#define BELL		((char) 7)	

#define FILE_BEGIN	0
#define FILE_CURRENT	1
#define FILE_END	2

#define Boolean		char

/* CONSTANTS */
#define MAX_INTEGER		LONG_MAX

/* MACROS - standard macro definitions and static types */
#define	MEW(x,n,t)	(( (x=(t*) malloc(((n)*sizeof(t))))==NULL) ? \
			 (t*) (fprintf(stderr,"MEW: Out of Memory.\n"),exit(1),0):x)

#define	NEW(x,n,t)	(( (x=(t*) calloc(n,sizeof(t)))==NULL) ? \
			 (t*) (fprintf(stderr,"NEW: Out of Memory.\n"),exit(1),0):x)

#define	NEWP(x,n,t)	(( (x=(t**) calloc(n,sizeof(t*)))==NULL) ? \
			(t**) (fprintf(stderr,"NEWP: Out of Memory.\n"),exit(1),0):x)

#define	NEWPP(x,n,t)	(( (x=(t***) calloc(n,sizeof(t**)))==NULL) ? \
			(t***) (fprintf(stderr,"Out of Memory.\n"),exit(1),0):x)

#define	NEWP3(x,n,t)	(( (x=(t****) calloc(n,sizeof(t***)))==NULL) ? \
			(t****) (fprintf(stderr,"Out of Memory.\n"),exit(1),0):x)

#define	GETCHAR(m,C)	do{ fprintf(stderr,"%s ", m); \
			  if(fscanf(stdin,"%c",(C)) == 1) { \
                	    while(getchar()!='\n') if(feof(stdin)) exit(1);\
			    break;\
 			  } while(getchar()!='\n') if(feof(stdin)) exit(1);\
			} while(TRUE);

#define	GETINT(m,i)	do{ fprintf(stderr,"%s ",m); \
			  if(fscanf(stdin,"%d",(i)) == 1) { \
                	    while(getchar()!='\n') if(feof(stdin)) exit(1);\
			    break;\
 			  } while(getchar()!='\n') if(feof(stdin)) exit(1);\
			} while(TRUE);

typedef unsigned char   Uint1, *Uint1Ptr;

typedef short           Int2,*Int2Ptr;
typedef unsigned short  UInt2;

typedef int             Int4,*Int4Ptr;
typedef unsigned int    UInt4;

typedef long            Int8;
typedef unsigned long   UInt8;

#define INT2_MIN        SHRT_MIN
#define INT2_MAX        SHRT_MAX

#define INT4_MIN        INT_MIN
#define INT4_MAX        INT_MAX
#define UINT4_MAX       UINT_MAX

#ifndef INT8_MAX
#define INT8_MAX        LONG_MAX
#endif

#ifndef INT8_MIN
#define INT8_MIN        LONG_MIN
#endif

#ifndef UINT8_MAX
#define UINT8_MAX       ULONG_MAX
#endif

#define print_error(str) for(fprintf(stderr,"%s\n",str); TRUE; exit(1))
#define DIGIT2INT(c)    ((int)(c - 48))
#define MIN(t,x,y)	(((t)(x) < (t)(y)) ? (t)(x) : (t)(y))
#define MAX(t,x,y)	(((t)(x) > (t)(y)) ? (t)(x) : (t)(y))
#define SUM(x)		(((x) * (x+1)) / 2)
#endif
