#if !defined (SMATRIX)
#define	SMATRIX
#include "stdinc.h"
#include "alphabet.h"
#include "probability.h"
/*************************** ADT PROFILE ***************************
	
			scoring matrix data type

**********************************************************************/

/*************************** SMatrix Type **************************/
typedef struct {
	Int4	*cmax,*max;		/* maximum */
	Int4	*cmin,*min;		/* minimum */
	Int4	K;			/* length */
	char	*maxseg;		/* maximum scoring segment */ 
	Int4	**score;		/* scoring matrix */
	double	mean,var,sd;
	double	nsd;			/* minimum # std. dev. above mean */
	double	*f,*f0,*fx;
	double	*freq;			/* freq[r] */
	a_type	A;			/* alphabet */
	Int4	nlet;
	Int4	neginf;			/* lowest permissible score */
	Boolean	changed,calc_stats,calc_prob;	/* update data */
} smatrix_type;
typedef smatrix_type *smx_typ;

/******************************* private *****************************/
Boolean smatrix_prob(register Int4 k, register double *f, smx_typ M);
Int4     min_max_smatrix(smx_typ M);
Int4     stats_smatrix(smx_typ M);
double  smatrix_prob_fast(register Int4 k, register double *f, smx_typ M);
void    smatrix_error(char *s);

/******************************* Public ******************************/
/***************************** operations ****************************/
void    PutSMatrix(FILE *fptr, smx_typ M);
smx_typ MkSMatrix(double nsd, Int4 K, double *freq, a_type A);
void    NilSMatrix(smx_typ M);
Int4     MaxScoreSMatrix(smx_typ M);
char    *MaxSegSMatrix(smx_typ M);
Int4     SetSMatrix(Int4 r, Int4 row , Int4 score, smx_typ M);
Int4     ScoreSMatrix(register char *seq, register Int4 start,
			register smx_typ M);
Int4     SplitScoreSMatrix(char **seq, Int4 n, Int4 *start, Int4 *leng, smx_typ M);
double  SMatrixProb(Int4 score, smx_typ M);
double  SMatrixProbFast(Int4 score, smx_typ M);
/**************************** macro operations **********************/
#define kSMatrix(M)		((M)->K)
#define meanSMatrix(M)	(((M)->changed)? stats_smatrix(M),(M)->mean:\
				(M)->mean)
#define sdSMatrix(M)	(((M)->changed)? stats_smatrix(M),(M)->sd:(M)->sd)
#define ValSMatrix(pos,r,M)	((M)->score[(pos)][(r)])
#define NegInfSMatrix(M)	((M)->neginf)

#endif

