/* entity.h - entity data type. */
#if !defined(SEQUENCE)
#define SEQUENCE
#include "stdinc.h"
#include "alphabet.h"
#include "dheap.h"
#include "random.h"
/**************************** Sequence ADT ***************************
		E == <I,S>	2-tuple
		I == sequence identification key
		S == biological sequence 
**********************************************************************/
/*************************** Sequence type *****************************/
typedef struct {
	unsigned short		I;	/* identifier for entity */
	unsigned short		n;	/* length of entity sequence */
	Boolean			xnu;	/* sequences xnu'ed */
	char			*S;	/* sequence */
	char			*X;	/* if !xnu'ed == S; else X'ed seq */
	char			*info;	/* description of entity */
} sequence_type;
typedef sequence_type	*e_type;
/******************************** private **********************************/
Int4     get_diagonal_ends_seq(char *seq1, char *seq2, char **R, Int4 n,
        Int4 *begin, Int4 *end);
e_type  EmptySeq(Int4 I, Int4 length);
Int4     seq_error(char *s);
/******************************** PUBLIC **********************************/
e_type  ReadSeq(FILE *fptr, Int4 I, Int4 size, a_type A);
e_type  ReadSeqFA(char *infile, Int4 I, a_type A);
e_type  MergeSeqs(e_type *E);
Boolean IdentSeqs(e_type E1, e_type E2);
Boolean NonNullIdentSeqs(register e_type E1, register e_type E2);
Int4     CenterSeqHSP(Int4 offset, e_type E1, e_type E2, a_type A);
Int4     GetFastaInfo(char *DBS_NAME, Int4 max, Int4 **pcounts,
        unsigned short **psize, a_type A);
e_type	NilSeq(e_type E);			/* undefine entity */
double  *FreqResSeq(e_type E, double *freq, a_type A);
Int4	*CountsSeq(e_type E, a_type A);
void    MaskSeq(Int4 start, Int4 end, e_type E);
Int4    *NumResSeq(e_type E,a_type A);
void    PutSeqID(FILE *fptr,e_type E);
void    PutSeqInfo(FILE *fptr,e_type E);
void	PutSeqDefLine(FILE *fptr,e_type E);
void    PutSeq(FILE *fptr,e_type E,a_type A);
void    PutXnuSeq(FILE *fptr,e_type E,a_type A);
void	ProcessSeq(e_type E,a_type A,double lambda,double K,double H);
e_type  CopySeq(e_type E);
e_type	ShuffleSeq(e_type E);
e_type  RandomSeq(Int4 length, Int4 I, double *freq, a_type A);
e_type	RtnShuffleSeq(e_type E);
e_type  RandomizeSeq(e_type E, double *freq, a_type A);
void    PutSeqRegion(FILE *fptr,Int4 start, Int4 length, e_type E, a_type A);
void    PutSeqRegion2(FILE *fptr,Int4 start, Int4 length, e_type E,
        Int4 flank, a_type A);
Int4     PutDiagonalSeq(FILE *fptr, Int4 offset, e_type E1, e_type E2, a_type A);
char    RandomResSeq(register e_type E);
/**************************** Macros ********************************/
#define	LenSeq(E)		((E)->n)
#define	ResSeq(i,E)		((E)->S[(i)])
#define	XnuSeq(i,E)		((E)->X[(i)])
#define EqSeq(i,x,E)		((E)->S[(i)]=(char) (x))
#define EqSeqKey(x,E)		((E)->info=(x))
#define RmSeq(E)		((E)->I=NULL)
#define EqSeqI(i,E)		((E)->I=(unsigned short) (i))
#define SeqI(E)			((E)->I)
#define SeqKey(E)		((E)->info)
#define SeqPtr(E)		((E)->S)
#define XnuSeqPtr(E)		((E)->X)
#endif
