/* scan.h - codes and constants for scan program. */
#if !defined (SCAN)
#define SCAN
/*** #include <time.h> /****/
#include "afnio.h"
#include "histogram.h"
#include "probability.h"
#include "sequence.h"
#include "smatrix.h"
#include "smodel.h"
#include "mheap.h"
#include "sites.h"
#include "residues.h"

typedef struct {
	a_type  A;
	char	*snfile;
	Boolean	seqfile,repeats,shuffle,new_way;
	Boolean	neg_mask;
	Int4	min_segs, max_segs;
	Int4	N;			/** number of motif models **/
	Int4	hpsz;
	Int4	**pos;
	double	total;
	double	*freq;
	double	maxEval,logmaxEval;
	double	singlePval;	/** single Pval min **/
	sm_type  *M;
	mh_type H;
	h_type	HG;
	e_type	*E;
	char	method;		/** method used for model: g,c,r **/
} scan_type;
typedef scan_type *scn_typ;

#define MAX_BLOCK_SIZE  1000
#define MAX_BLOCK_LENGTH 200
#define MAX_NUM_MODELS	50
#define	ID_LENGTH	200

/********************************* PRIVATE ********************************/
Int4     foo_scan(Int4 start, Int4 m, Int4 N, Int4 **Items, Int4 **scores, 
		Int4 **site,Int4 *path, Int4 *w, Int4 *tmp, Int4 tmp_score, 
		Int4 *best);

/********************************* PUBLIC ********************************/
scn_typ MkScan(double pseudo, char *snfile, Int4 *counts, a_type A, 
	Int4 hpsz, char method);
void    NilScan(scn_typ F);
Int4     MaskScan(FILE *fptr,Int4 number, unsigned short *nsize, scn_typ F);
Int4     ScanScan(FILE *fptr,Int4 number, unsigned short *nsize, scn_typ F);
Int4     ScanRScan(FILE *fptr,Int4 number, unsigned short *nsize, scn_typ F);
Int4     OrderScanScan(FILE *fptr,Int4 number, unsigned short *nsize, scn_typ F);
Int4	OrderScanMtf(char *name, scn_typ F);
Int4     PutScan(FILE *fptr, scn_typ F);
Int4     PutRScan(FILE *fptr, scn_typ F);
Int4     ReadScan(scn_typ F, double pseudo,char *snfile, Int4 *counts);
Int4     SetMaxEvalScan(double maxEval, scn_typ F);

/********************************* MACROS ********************************/
#define OpenSeqFileScan(b,F)	((F)->seqfile = (b))
#define ShuffleSegsScan(F)	((F)->shuffle = TRUE)
#define SetMinSegsRScan(x,F)    ((F)->min_segs = (x))
#define SetMethodScan(x,F)	((F)->method = (char)(x))
#define SetMaxSegsRScan(x,F)    ((F)->max_segs = (x))
#define SetSinglePvalScan(x,F)  ((F)->singlePval = (double)(x))
#define UseNegMaskScan(F)	((F)->neg_mask = TRUE)
#define NumModelsScan(F)    	((F)->N)
#define SMatrixScan(m,F)	(((m) <= (F)->N && (m) > 0)?\
					GetSMatrixSModel((F)->M[(m)]): NULL)

#endif

