#include "random.h"

/*
	Additive random number generator

	Modelled after "Algorithm A" in
	Knuth, D. E. (1981). The art of computer programming, volume 2, page 27.

	7/26/90 WRG
*/

static Int4	state[33] = {
	(Int4)0xd53f1852,  (Int4)0xdfc78b83,  (Int4)0x4f256096,  (Int4)0xe643df7,
	(Int4)0x82c359bf,  (Int4)0xc7794dfa,  (Int4)0xd5e9ffaa,  (Int4)0x2c8cb64a,
	(Int4)0x2f07b334,  (Int4)0xad5a7eb5,  (Int4)0x96dc0cde,  (Int4)0x6fc24589,
	(Int4)0xa5853646,  (Int4)0xe71576e2,  (Int4)0xdae30df,  (Int4)0xb09ce711,
	(Int4)0x5e56ef87,  (Int4)0x4b4b0082,  (Int4)0x6f4f340e,  (Int4)0xc5bb17e8,
	(Int4)0xd788d765,  (Int4)0x67498087,  (Int4)0x9d7aba26,  (Int4)0x261351d4,
	(Int4)0x411ee7ea,  (Int4)0x393a263,  (Int4)0x2c5a5835,  (Int4)0xc115fcd8,
	(Int4)0x25e9132c,  (Int4)0xd0c6e906,  (Int4)0xc2bc5b2d,  (Int4)0x6c065c98,
	(Int4)0x6e37bd55 };

#define r_off	12

static Int4	*rJ = &state[r_off], *rK = &state[DIM(state)-1];

void sRandom(int x)
{
	register int i;

	state[0] = x;
	/* linear congruential initializer */
	for (i=1; i<DIM(state); ++i) {
		state[i] = 1103515245*state[i-1] + 12345;
	}

	rJ = &state[r_off];
	rK = &state[DIM(state)-1];

	for (i=0; i<10*DIM(state); ++i) (void) Random();
}


/*
	Random --  return value in the range 0 <= x <= 2**31 - 1
*/
int Random(void)
{
	register int r;

	r = *rK;
	r += *rJ--;
	*rK-- = r;

	if (rK < state)
		rK = &state[DIM(state)-1];
	else
		if (rJ < state)
			rJ = &state[DIM(state)-1];
	return (r>>1)&0x7fffffff; /* discard the least-random bit */
}


