/* pairaln.h - pairwise alignment methods . */
#if !defined(PAIRALN)
#define PAIRALN
#include "stdinc.h"
#include "alphabet.h"
#include "sequence.h"
#include "mheap.h"

/******************************** private **********************************/
Boolean relate_seq(register char *seq1, register char *seq2,
        register char **R, register Int4 n, register Int4 cutoff);
Int4     diagonal_score_seq(register char *seq1, register char *seq2,
        register char **R, register Int4 n);
Int4     get_diagonal_ends_seq(char *seq1, char *seq2, char **R, Int4 n,
        Int4 *begin, Int4 *end);
Int4     repeat_score_seq(register char *seq, register char **R,
                register Int4 o, register Int4 n);
/******************************** PUBLIC **********************************/
Int4     PutDiagonalSeq(FILE *fptr, Int4 offset, e_type E1, e_type E2, a_type A);
Boolean RelatedSeqs(Int4 cutoff, e_type E1, e_type E2, a_type A);
Int4     AlignSeqFastp(e_type E1, e_type E2, a_type A);
Boolean RelateSeqFastp(e_type E1, e_type E2, a_type A,Int4 score);
Int4     RepeatScoreSeq(e_type E, a_type A, Int4 *offset);

#endif
