#if !defined (OLIST)
#define OLIST
#include "stdinc.h"
/**************************  ADT olist ********************************
 Header file for data structure representing ordered list of small 
positive integers.

	list: x  x  x   ... x   where x < x < x < ... < x
               1  2  3       n         1   2   3         n

	and 0 < n <= N.	(note: next[x ] = x   .)
				     i     i+1
**********************************************************************/

typedef struct {
	Int4	N;		/* list defined on ints in {1,...,N} */
	Int4	n;		/* number of elements in list */
	Int4	*next;		/* next[i] is successor of i in list */
} orderlist_type;

typedef orderlist_type *ol_type;

void olist_error(char *s);
/****************************** PUBLIC ***************************/
ol_type	Olist(Int4 N);
Int4	RmOlist(Int4 i, ol_type L);
Int4	InsertOlist(Int4 i, ol_type L); /* access item i in THETA(i) time */
void	PutOlist(FILE *fptr, ol_type L);/* print item i on list */
void    GetOlist(Int4 *array, ol_type L);
void	NilOlist(ol_type L);

/********************** MACROS **********************************/

/* Return number of elements in list */
#define LengthOlist(L)	((L)->n)
#define ClearOlist(L)	((L)->next[0]=0)

#endif
