#include "olist.h"

ol_type	Olist(Int4 N) 
/* Create an ordered list of zero items. */
{
	ol_type L;
	NEW(L,1,orderlist_type);
	L->N = N; 
	L->n = 0;
	NEW(L->next,N+1,Int4);
	L->next[0] = 0;		/* 0 = null */
	return L;
}

void	NilOlist(ol_type L) { free(L->next); free(L); }

Int4	RmOlist(Int4 i, ol_type L)
/* Remove item i from list L.  */
{
	Int4	x=0;
	do{
		if( L->next[x] == i){
			L->next[x] = L->next[L->next[x]];
			L->n--;
			return i;
		} else x =  L->next[x];
	} while( x != 0);
	return 0;
}

Int4	InsertOlist(Int4 i, ol_type L)
/* Add item i to list L in theta(i) time. */
{
	Int4 x,t;
	if(i > L->N) olist_error("item larger than N");
	for(x=0; L->next[x] != 0; x =  L->next[x]) {
	   if(L->next[x] >= i){
		if(L->next[x] == i) return 0;
		break;
	   }
	}
	t = L->next[x]; L->next[x] = i; L->next[i] = t;
	L->n++;
	return i;
}

void	GetOlist(Int4 *array, ol_type L)
/*  put the items into the array (starting from i=1) as ordered on list L. */
{
	Int4 x,i;
	for(x=0,i=1; L->next[x] != 0; x=L->next[x],i++)
			array[i]=L->next[x];
	array[i] = 0;
}

void PutOlist(FILE *fptr, ol_type L)
/* Print the list L. */
{
	Int4 i;
	for(i=0; L->next[i] != 0; i=L->next[i])
		fprintf(fptr,"%d ", L->next[i]);
}

void olist_error(char *s){fprintf(stderr,"olist: %s\n",s); exit(1); }


