/************ mlist.h - multiple linked list abstract data type.***********/
#if !defined(MLIST)
#define MLIST
#include "stdinc.h"
/************************** alphabet datatype *****************************/
typedef struct {
	Int4     M;			/* number of elements for lists */
	Int4     N;			/* number of lists */
	Int4	*first;			/* pointers to beginning of lists */
	Int4	*item;			/* items on lists */
	Int4	*next;			/* pointer to next element */
	Int4	free;			/* pinter to free list */
} multi_list_type;
typedef	multi_list_type *ml_type;

/******************************** PRIVATE **********************************/
void	mlist_error(char *s);

/******************************** PUBLIC ***********************************/
/**************************** mlist operations **************************/
ml_type	MkMList(Int4 M, Int4 N);
Int4     Add2MList(register Int4 i, register Int4 n, register ml_type L);
Int4     GetListMList(register Int4 *list, register Int4 n, 
        register ml_type L);
void	NilMList(ml_type L);


/***************************************************************************/
#define EmptyMList(n,L)		((L)->first[(n)]==0)

#endif

