#include "mlist.h"

ml_type MkMList(Int4 M, Int4 N)
/******************************************************************
  N = number of lists; M = number of elements.
  sets all N lists to empty and creates the list of free cells.
 ******************************************************************/
{
	ml_type	L;
	Int4	i,n;

	MEW(L,1,multi_list_type);
	L->M = M; L->N = N;
	NEW(L->first,N+2,Int4);	/* all set to zero = empty lists */
	MEW(L->item,M+2,Int4); MEW(L->next,M+2,Int4);
	for(L->free=1, i=1; i < M; i++){
		L->next[i]=i+1;
	}
	L->next[i] = 0;
	return L;
}

Int4	Add2MList(register Int4 i, register Int4 n, register ml_type L)
/******************************************************************
 add item i to the nth list.
 ******************************************************************/
 {
	register Int4	New,t;

	if(n > L->N || n <= 0) mlist_error("list number out of range");
	if((New = L->free) == 0) mlist_error("out of memory");
	L->free = L->next[New]; 
	t = L->first[n];		/* first[n] = t[?:?]->  */
	L->item[New] = i;
	L->next[New] = t;		/** New[item:t]-> t[?:?]-> **/
	L->first[n] = New; 		/** first[n] = New[i:t]-> t[?:?]-> */
}

Int4	GetListMList(register Int4 *list, register Int4 n, 
	register ml_type L)
/******************************************************************
 convert list to contain the nth list in L; returns list length.
 WARNING: assumes list[ ] is Int4 enough.
 ******************************************************************/
{
	register Int4	i,c;
	
	for(i=0, c = L->first[n] ; c != 0; c=L->next[c]){
		list[i++] = L->item[c];
	}
	return i;
}

void    NilMList(ml_type L)
{
	free(L->first);
	free(L->item);
	free(L->next);
	free(L);
}

void    mlist_error(char *s){ fprintf(stderr,"mlist: %s\n",s); exit(1); }
