/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_DCI_TYP_)
#define _DCI_TYP_

#include "stdinc.h"
#include "residues.h"
// #include "pdb.h"
#include "mheap.h"
#include "histogram.h"
#include "afnio.h"
#include "set_typ.h"

/************************************************
       |---- dist x 1000 ----|---- c1 ---|---- c2 ---|------- site 1 ------|------- site 2 ------| 
	1111 1111  1111 1111   1111 1111   1111 1111  1111 1111  1111 1111   1111 1111  1111 1111
cmask:  0000 0000  0000 0000   0000 0000   0000 0000  0000 0000  0000 0000   0000 0000  1111 1111
smask:  0000 0000  0000 0000   0000 0000   0000 0000  0000 0000  0000 0000   1111 1111  1111 1111
pmask:  0000 0000  0000 0000   1111 1111   1111 1111  1111 1111  1111 1111   1111 1111  1111 1111
 ***********************************************/
class dci_typ {         // Direct coupling information type
public:
                dci_typ(){ print_error("dci_typ( ) constructor disallowed"); }
                dci_typ(char *name,float dm,Int4 m,Int4 l, Int4 dp, Int4 x, Int4 ldp,
					long double pv,long double biu,Int4 r_out,float ff){
        		L=l; D=dp; d=ldp; X=x; pval=pv; pBiU=biu; N=0; max=m; R=r_out,F_factor=ff;
			NEW(rank,max + 5,Int4); NEW(array,max + 5,UInt8); NEW(dist,max + 5,float); 
			NEW(chain2,max + 5, char); NEW(DCscore,max + 5, float);
			dca_file=AllocString(name); Dmax=dm;
			bpS=bpBIU=0;  bpD=bpX=bpd=bpL=0; color_code=0;
			// fprintf(stderr,"dca_file=%s; L=%d\n",dca_file,L);
		}
                ~dci_typ( ){
		  free(DCscore); 
		  free(dist); free(array); free(rank); free(dca_file); free(chain2); 
		}
	void	PutVSI(FILE *fp,Int4 End);
	void	PyMolLines(FILE *fp,Int4 End, char chn, char adj_chn=0);
	void	PutBest(FILE *fp,Int4 End, set_typ SetB=0,char chn=' ');
	Int4	PutSameDiff(FILE *fp,dci_typ *that, char mode='D',set_typ SetB=0);
	Int4	PutDiff(FILE *fp,dci_typ *that, set_typ SetB, double cutoff=0.33);
	Int4	PutSame(FILE *fp,Int4 NN,dci_typ **that);
        Int4	add(Int4 rnk, char c1, Int2 s1, char c2, Int2 s2, float dd,float dc,char chn2=0);
        Int4	rtnN(){ return N; }
        void	Put(FILE *fp,Int4 n=0);
	long double RtnScores(long double &biuS){ biuS=-log10l(pBiU); return -log10l(pval); }
	double	PutResults(FILE *fp,char Mode=0,char *Chns=0,char *pdb_id=0,double S0=0.0);
	long double	RtnNegLog10P(){ return -expm1l(-pval); }
	Int4	RtnNumPairsL() { return L; }
	void	AddBPPS(long double s, long double b, Int4 l, Int4 bD, Int4 x, Int4 bd, char cc){
			bpS=s; bpBIU=b; bpD=bD; bpX=x; bpd=bd; bpL=l; color_code=cc;
		}
private:
	Int4    PutGraph(FILE *fp);
	char	*chain2;	// chain of 2nd residue...
#if 1	// when chn2 not needed.
        Int4	rtn(Int4 n, char &c1, Int4 &s1, char &c2, Int4 &s2, float &dd, float &dc){
		    char chn2; Int4 x=rtn(n,c1,s1,c2,s2,dd,dc,chn2); return x;
		}
#endif
        Int4	rtn(Int4 n, char &c1, Int4 &s1, char &c2, Int4 &s2, float &dd, float &dc, char &chn2);
        Int4	put(FILE *fp, Int4 n, float DD=-1,set_typ SetB=0);
#if 1	// BPPS data...
	long double	bpS,bpBIU;
	Int4		bpD,bpX,bpd,bpL;
#endif
        Int4    N,max,L,D,X,d,R;
	long double pval,pBiU;
	float	*dist,*DCscore;
	float	Dmax,F_factor;
	char	*dca_file,color_code;
        UInt8   *array;
        Int4	*rank;
	static const UInt8 cmask= 0xFF; // size of char; see above.
	static const UInt8 smask= 0xFFFF; // size of Int2; see above.
	static const UInt8 pmask= 0xFFFFFFFFFFFF; // size of pair info; see above.
};

class dch_typ {
public:
        dch_typ(){ print_error("dch_typ( ) constructor disallowed"); }
        dch_typ(Int4 hs){ 
		hpsz=hs;
		NEWP(DCI,hpsz+2,dci_typ);
		NEWP(Chns,hpsz+2,char);
		NEWP(pdbid,hpsz+2,char);
		NEW(S0,hpsz+2,double);
		mH=Mheap(hpsz, 3);
	}
	~dch_typ(){ Free(); }
	Int4	Put(FILE *fp,char mode=0);
	Int4    Insert(dci_typ *dci, char *chns, char *id, double s0);
	dci_typ *DelMin(double &key, Int4 &item, char *&chns, char *&id, double &s0);
	dci_typ *DelMax(double &key, Int4 &item, char *&chns, char *&id, double &s0);
	Int4	RtnHpsz(){ return hpsz; }
	Int4	RtnItemsInMheap(){ return ItemsInMheap(mH); }
private:
	void	Free();
	Int4	hpsz;
	dci_typ	**DCI;
	char	**Chns;
	char	**pdbid;
	double	*S0;
	mh_type	mH;
};

#endif

