#if !defined (_LN_NUM_ROOTED_TREES_)
#define _LN_NUM_ROOTED_TREES_

/******************
https://oeis.org/A000081
N. J. A. Sloane and Robert G. Wilson v, Table of n, a(n) for n = 0..1000
        (first 201 terms from N. J. A. Sloane)

# This is the b000081.txt text file.
# A000081: Number of rooted trees with n nodes (or connected functions with a fixed point).
# Dated 16 September 2014.
 for n=0 to 1000.

 The On-Line Encyclopedia of Integer Sequences:
A000081  Number of unlabeled rooted trees with n nodes (or connected functions with a fixed point).
(Formerly M1180 N0454)

Also, number of planted trees with n+1 nodes.
Also called "Polya trees" by Genitrini (2016). - N. J. A. Sloane, Mar 24 2017

References:
D. E. Knuth, The Art of Computer Programming, Vol. 1: Fundamental Algorithms, 3d Ed. 1997, pp. 386-388.
D. E. Knuth, The Art of Computer Programming, vol. 1, 3rd ed., Fundamental Algorithms, p. 395, ex. 2.
D. E. Knuth, TAOCP, Vol. 4, Section 7.2.1.6.
A. Cayley, On the analytical forms called trees, Amer. J. Math., 4 (1881), 266-268.
F. Goebel, On a 1-1-correspondence between rooted trees and natural numbers, J. Combin. Theory, B 29 (1980), 141-143.
F. Harary, G. Prins, The number of homeomorphically irreducible trees, and other species, Acta Math. 101 (1-2) (1959) 141-161, see page 146.
F. Harary & R. W. Robinson, The number of achiral trees, Jnl. Reine Angewandte Mathematik 278 (1975), 322-335. (Annotated scanned copy)
D. Matula, A natural rooted tree enumeration by prime factorization, SIAM Rev. 10 (1968) 273.
N. Pippenger, Enumeration of equicolorable trees, SIAM J. Discrete Math., 14 (2001), 93-115.
Eric Weisstein's World of Mathematics, Rooted Tree (http://mathworld.wolfram.com/RootedTree.html)

 ******************/

// from 0..650 nodes...

#define MaxNodesForlnNumRootedTrees 650

const long double lnNumRootedTrees[]={ 0, 0, 0, 0.693147181, 1.386294361, 2.197224577,
 2.995732274, 3.871201011, 4.744932128, 5.655991811, 6.577861358,
 7.518607217, 8.469262658, 9.432363296, 10.403444324, 11.382942057,
 12.368960757, 13.361139304, 14.358508459, 15.360660798, 16.367002695,
 17.377176676, 18.390790251, 19.407552411, 20.427181879, 21.449448606,
 22.474140204, 23.501074308, 24.530085343, 25.561027239, 26.593767808,
 27.628188621, 28.664182237, 29.701651426, 30.740507595, 31.780669980,
 32.822064640, 33.864623770, 34.908285003, 35.952990867, 36.998688268,
 38.045328069, 39.092864695, 40.141255805, 41.190461987, 42.240446500,
 43.291175029, 44.342615484, 45.394737807, 46.447513807, 47.500917004,
 48.554922499, 49.609506844, 50.664647938, 51.720324921, 52.776518084,
 53.833208786, 54.890379379, 55.948013138, 57.006094197, 58.064607492,
 59.123538708, 60.182874228, 61.242601093, 62.302706955, 63.363180042,
 64.424009124, 65.485183475, 66.546692850, 67.608527451, 68.670677906,
 69.733135241, 70.795890859, 71.858936519, 72.922264320, 73.985866675,
 75.049736303, 76.113866205, 77.178249658, 78.242880193, 79.307751585,
 80.372857844, 81.438193199, 82.503752090, 83.569529156, 84.635519227,
 85.701717315, 86.768118605, 87.834718448, 88.901512350, 89.968495972,
 91.035665116, 92.103015723, 93.170543865, 94.238245741, 95.306117670,
 96.374156088, 97.442357540, 98.510718679, 99.579236261, 100.647907136,
 101.716728252, 102.785696646, 103.854809441, 104.924063845, 105.993457145,
 107.062986705, 108.132649966, 109.202444436, 110.272367696, 111.342417391,
 112.412591231, 113.482886987, 114.553302491, 115.623835630, 116.694484348,
 117.765246643, 118.836120562, 119.907104205, 120.978195718, 122.049393295,
 123.120695174, 124.192099637, 125.263605007, 126.335209650, 127.406911969,
 128.478710408, 129.550603445, 130.622589595, 131.694667408, 132.766835468,
 133.839092390, 134.911436823, 135.983867444, 137.056382961, 138.128982112,
 139.201663660, 140.274426399, 141.347269146, 142.420190745, 143.493190065,
 144.566265998, 145.639417463, 146.712643397, 147.785942763, 148.859314542,
 149.932757740, 151.006271381, 152.079854509, 153.153506188, 154.227225500,
 155.301011546, 156.374863444, 157.448780331, 158.522761358, 159.596805697,
 160.670912530, 161.745081060, 162.819310503, 163.893600090, 164.967949066,
 166.042356690, 167.116822237, 168.191344992, 169.265924257, 170.340559342,
 171.415249574, 172.489994289, 173.564792837, 174.639644579, 175.714548886,
 176.789505142, 177.864512740, 178.939571085, 180.014679592, 181.089837686,
 182.165044801, 183.240300381, 184.315603880, 185.390954762, 186.466352497,
 187.541796566, 188.617286460, 189.692821674, 190.768401716, 191.844026098,
 192.919694343, 193.995405980, 195.071160546, 196.146957586, 197.222796650,
 198.298677298, 199.374599095, 200.450561613, 201.526564431, 202.602607135,
 203.678689317, 204.754810574, 205.830970511, 206.907168738, 207.983404870,
 209.059678530, 210.135989345, 211.212336947, 212.288720976, 213.365141074,
 214.441596891, 215.518088081, 216.594614301, 217.671175217, 218.747770497,
 219.824399814, 220.901062847, 221.977759277, 223.054488792, 224.131251084,
 225.208045847, 226.284872782, 227.361731594, 228.438621989, 229.515543681,
 230.592496385, 231.669479821, 232.746493712, 233.823537787, 234.900611776,
 235.977715414, 237.054848439, 238.132010592, 239.209201618, 240.286421267,
 241.363669288, 242.440945438, 243.518249473, 244.595581156, 245.672940250,
 246.750326522, 247.827739743, 248.905179685, 249.982646124, 251.060138839,
 252.137657612, 253.215202226, 254.292772469, 255.370368129, 256.447988999,
 257.525634873, 258.603305548, 259.681000825, 260.758720504, 261.836464391,
 262.914232291, 263.992024014, 265.069839371, 266.147678176, 267.225540244,
 268.303425393, 269.381333443, 270.459264216, 271.537217536, 272.615193230,
 273.693191126, 274.771211053, 275.849252844, 276.927316333, 278.005401356,
 279.083507750, 280.161635355, 281.239784013, 282.317953566, 283.396143860,
 284.474354740, 285.552586057, 286.630837658, 287.709109396, 288.787401125,
 289.865712698, 290.944043973, 292.022394808, 293.100765061, 294.179154595,
 295.257563270, 296.335990952, 297.414437506, 298.492902799, 299.571386698,
 300.649889074, 301.728409797, 302.806948741, 303.885505777, 304.964080782,
 306.042673632, 307.121284204, 308.199912377, 309.278558031, 310.357221047,
 311.435901308, 312.514598697, 313.593313100, 314.672044402, 315.750792490,
 316.829557252, 317.908338579, 318.987136360, 320.065950487, 321.144780853,
 322.223627350, 323.302489875, 324.381368323, 325.460262589, 326.539172573,
 327.618098173, 328.697039288, 329.775995820, 330.854967670, 331.933954740,
 333.012956934, 334.091974156, 335.171006312, 336.250053308, 337.329115051,
 338.408191449, 339.487282411, 340.566387846, 341.645507665, 342.724641779,
 343.803790101, 344.882952543, 345.962129019, 347.041319443, 348.120523732,
 349.199741800, 350.278973566, 351.358218946, 352.437477858, 353.516750223,
 354.596035959, 355.675334987, 356.754647229, 357.833972606, 358.913311041,
 359.992662457, 361.072026778, 362.151403929, 363.230793835, 364.310196422,
 365.389611616, 366.469039346, 367.548479537, 368.627932120, 369.707397023,
 370.786874176, 371.866363509, 372.945864953, 374.025378440, 375.104903901,
 376.184441269, 377.263990478, 378.343551460, 379.423124151, 380.502708485,
 381.582304398, 382.661911825, 383.741530703, 384.821160969, 385.900802561,
 386.980455416, 388.060119473, 389.139794672, 390.219480950, 391.299178250,
 392.378886510, 393.458605673, 394.538335679, 395.618076470, 396.697827989,
 397.777590179, 398.857362983, 399.937146345, 401.016940208, 402.096744518,
 403.176559220, 404.256384259, 405.336219581, 406.416065133, 407.495920860,
 408.575786711, 409.655662634, 410.735548575, 411.815444484, 412.895350309,
 413.975265999, 415.055191505, 416.135126775, 417.215071762, 418.295026414,
 419.374990683, 420.454964521, 421.534947880, 422.614940712, 423.694942969,
 424.774954604, 425.854975571, 426.935005823, 428.015045314, 429.095093998,
 430.175151831, 431.255218767, 432.335294761, 433.415379769, 434.495473748,
 435.575576652, 436.655688440, 437.735809067, 438.815938492, 439.896076671,
 440.976223562, 442.056379124, 443.136543315, 444.216716095, 445.296897421,
 446.377087253, 447.457285551, 448.537492275, 449.617707384, 450.697930841,
 451.778162604, 452.858402636, 453.938650897, 455.018907350, 456.099171956,
 457.179444676, 458.259725474, 459.340014313, 460.420311154, 461.500615962,
 462.580928699, 463.661249330, 464.741577817, 465.821914126, 466.902258221,
 467.982610066, 469.062969627, 470.143336868, 471.223711754, 472.304094252,
 473.384484327, 474.464881946, 475.545287074, 476.625699677, 477.706119724,
 478.786547180, 479.866982014, 480.947424191, 482.027873681, 483.108330450,
 484.188794466, 485.269265699, 486.349744116, 487.430229687, 488.510722379,
 489.591222162, 490.671729005, 491.752242878, 492.832763751, 493.913291593,
 494.993826374, 496.074368064, 497.154916635, 498.235472056, 499.316034299,
 500.396603334, 501.477179132, 502.557761666, 503.638350906, 504.718946825,
 505.799549393, 506.880158584, 507.960774369, 509.041396721, 510.122025613,
 511.202661017, 512.283302906, 513.363951253, 514.444606033, 515.525267217,
 516.605934780, 517.686608695, 518.767288937, 519.847975480, 520.928668297,
 522.009367363, 523.090072653, 524.170784142, 525.251501804, 526.332225614,
 527.412955548, 528.493691580, 529.574433687, 530.655181844, 531.735936027,
 532.816696211, 533.897462374, 534.978234490, 536.059012536, 537.139796489,
 538.220586326, 539.301382022, 540.382183556, 541.462990904, 542.543804043,
 543.624622950, 544.705447604, 545.786277981, 546.867114060, 547.947955818,
 549.028803233, 550.109656283, 551.190514946, 552.271379201, 553.352249027,
 554.433124401, 555.514005303, 556.594891711, 557.675783604, 558.756680962,
 559.837583764, 560.918491988, 561.999405615, 563.080324623, 564.161248994,
 565.242178705, 566.323113738, 567.404054073, 568.484999688, 569.565950566,
 570.646906685, 571.727868027, 572.808834571, 573.889806300, 574.970783193,
 576.051765231, 577.132752395, 578.213744668, 579.294742028, 580.375744459,
 581.456751941, 582.537764456, 583.618781985, 584.699804511, 585.780832014,
 586.861864478, 587.942901883, 589.023944213, 590.104991448, 591.186043573,
 592.267100568, 593.348162417, 594.429229101, 595.510300605, 596.591376910,
 597.672457999, 598.753543855, 599.834634462, 600.915729803, 601.996829860,
 603.077934617, 604.159044057, 605.240158165, 606.321276923, 607.402400315,
 608.483528325, 609.564660937, 610.645798134, 611.726939902, 612.808086223,
 613.889237082, 614.970392463, 616.051552351, 617.132716729, 618.213885583,
 619.295058897, 620.376236656, 621.457418845, 622.538605447, 623.619796449,
 624.700991835, 625.782191590, 626.863395699, 627.944604148, 629.025816921,
 630.107034005, 631.188255384, 632.269481044, 633.350710971, 634.431945150,
 635.513183567, 636.594426208, 637.675673059, 638.756924105, 639.838179332,
 640.919438727, 642.000702276, 643.081969965, 644.163241780, 645.244517708,
 646.325797735, 647.407081847, 648.488370032, 649.569662275, 650.650958563,
 651.732258883, 652.813563223, 653.894871568, 654.976183906, 656.057500223,
 657.138820507, 658.220144746, 659.301472925, 660.382805033, 661.464141056,
 662.545480982, 663.626824799, 664.708172494, 665.789524055, 666.870879468,
 667.952238723, 669.033601806, 670.114968705, 671.196339409, 672.277713905,
 673.359092181, 674.440474225, 675.521860025, 676.603249570, 677.684642847,
 678.766039845, 679.847440552, 680.928844957, 682.010253047, 683.091664812,
 684.173080240, 685.254499319, 686.335922039, 687.417348387, 688.498778353,
 689.580211925, 690.661649092, 691.743089843, 692.824534167, 693.905982054, 0 };

#endif

