
double	gsm_typ::MP_gibbs_sampler(gs_type G, FILE *rfp)
{
	Int4	n,iter,i,j,r,s,t,N=NumSeqsCMSA(G->cmsa);
	Int4	nruns=G->nruns,nconverg=G->nconverge;
	Int4	run,number,num_fail;
	double	TotLike,best,lastbest,map,map2,T;
	BooLean	flag;
	dh_type dH;
	char	stage;
	/**** DEBUG *****/
	BooLean	debug=FALSE; // debug=TRUE;
	UInt4	time1;
	Int4	*ncols,c;
	/**** DEBUG *****/
	BooLean	*moved;
	Int4	*sq_moves,sqmv,tot_moves,cmvN,tot_try;
	double	*prob,prb,max_prb,min_prb,ave_prb,max_max_prb;
	double	oldMap,newMap;
	keytyp	key;
   ppg_typ *ppg= new ppg_typ(G);

   FILE *fp=0;
   if(debug) {
	NEW(ncols, nBlksCMSA(G->cmsa)+2, Int4);
	time1=time(NULL);
	fp = open_file(NameSeqSetCMSA(G->cmsa),".prn","a");
   }

   //========================== 1. Set up memory ============================
   // fprintf(stderr,"nconv = %d\n", nconverg); 
   assert(N < INT4_MAX && N > 0);
   map=lastbest=-DBL_MAX; 
   ppg->Update('c');
   dH = dheap(N,3);
   NEW(sq_moves,N+2,Int4); NEW(prob,N+2,double);
   mem_typ memS(N,'S'); // Sites: number of actions == number of sequences.
   mem_typ memG(N,'G'); // Gaps: number of actions == number of gapped sequences

   unsigned short x=0,X=0;
   if(N < (Int4) (USHRT_MAX-20)) X= (unsigned short) N; else X = (USHRT_MAX-20);
   X = MINIMUM(unsigned short,X,nBlksCMSA(G->cmsa)*1000);	// no need to make this so huge!
   x = MAXIMUM(unsigned short,X/5,5);
   if(x >= X) X = x + 1;
   mem_typ memB(nBlksCMSA(G->cmsa),'B',x,X,0.10); // BLOCKS: # actions == # blocks.
   // mem_typ memB(nBlksCMSA(G->cmsa),'B',5,35,0.10); // BLOCKS: # actions == # blocks.
   mem_typ memC(5,'C',3,15,0.33); // Columns: 5 types of operations.
   memC.Clear(4); // set cardinality of these to zero.
   moved = new BooLean [nBlksCMSA(G->cmsa)+2]; 

   //========================== 2. Perform sampling ============================
   for(run = 1; (nruns <= 0 || run <= nruns); run++){
	if(debug) {
		if(run<=0) fprintf(fp,"************* tweaking **************\n");  
		else fprintf(fp,"************* new run **************\n");  
	}
	// fprintf(stderr,"."); 
	best=-DBL_MAX; 
	if(nruns <= 0) { 
	    iter=0; G->stage=stage=1; 
            cmvN=NumColumnsCMSA(G->cmsa); 
	    SetPseudoToMapCMSA(G->cmsa);
	    if(nruns == 0){
		best=map=lastbest=TotLikeGibbs(G); TotLike=0.0; 
		SaveBestCMSA(G->cmsa); // don't discard previous map for this one
	    } else { map=0.01; TotLike=0.0; iter=-2; SaveBestCMSA(G->cmsa); }
	} else {
		map=TotLike=0.0; 
		ppg->Update('i'); 
		G->stage=stage=0; iter=-3; cmvN=nBlksCMSA(G->cmsa); 
	}
	ppg->Update('p'); flag=FALSE;
	max_max_prb=-999999999.0; 
        /********************* MAIN Gibbs sampling loop ************************/
	for(number=num_fail=0; iter <= nconverg; iter++) {
        /********************* 2a. SLIDE COLUMNS SAMPLING ROUTINES *********************/
	  if(SmplBlksCols && map > 0.0){  
	  // if(map > 0.0 || !memC.Empty(4))  // at start only.
if(debug) std::cerr << "sliding columns loop\n";
	    for(t=1; t < nBlksCMSA(G->cmsa); t++){
		newMap=oldMap=0.0; T = 1.0;	// T = temperature.  // T = 0.5;
		// if(iter > 5) T = G->temp; else T = 0.5;
		if(dfsSlideColLtCMSA(t,&oldMap,&newMap,G->cmsa,T)){
			memC.Success(4); flag=TRUE;
         		if(newMap > best){ number = 0; best = newMap; }
		} else {
		   memC.Failure(4); 
         	   if(oldMap > best){ number = 0; best = oldMap; }
         	   if((nruns >= 0 || stage > 1) && map < best){ map=best; SaveBestCMSA(G->cmsa); }
		   newMap=oldMap=0.0;
		   if(dfsSlideColRtCMSA(t,&oldMap,&newMap,G->cmsa,T)){
			  memC.Success(4); flag=TRUE;
         		  if(newMap > best){ number = 0; best=newMap; }
		   } else { memC.Failure(4); if(oldMap > best){ number = 0; best=oldMap; } }
		}
         	if((nruns >= 0 || stage > 1) && map < best){ map=best; SaveBestCMSA(G->cmsa); }
	    }
	  }
	  /********************* 2b. COLUMN SAMPLING. **********************/
	  if(SmplBlksCols && map > 0.0){
	    if(debug) std::cerr << "starting column sampling loop\n";
	    for(n = 1; n <= cmvN; n++){
   	      if(!G->test[1]){
	        do { t=random_integer(nBlksCMSA(G->cmsa))+1;
	        } while(memB.Chance(t) < SampleUniformProb());
		switch(random_integer(4)){	// return 0..3
		  case 0: 
		    if(ContigBlkCMSA(t,G->cmsa)){
			if(ShiftCMSA(G->cmsa,t)){ memC.Success(1); flag=TRUE; }
			else { memC.Failure(1); }
		    } break;
		  case 1:
		    if(SampAddColTempCMSA(t,G->temp,G->cmsa)){ memC.Success(2); flag=TRUE; }
		    else { memC.Failure(2); } break;
		  case 2: // do more often.
		    if(SampRmColTempCMSA(t,G->temp,G->cmsa)){ memC.Success(3); flag=TRUE; }
		    else { memC.Failure(3); } break;
		  default: 
		    if(SampleEndColCMSA(t,G->temp,G->cmsa)){
				memC.Success(5); EnlargeGibbs(G); flag=TRUE;
		    } else { memC.Failure(5); } break;
		}
              }
	    }
	  } else for(t = 1; t <= nBlksCMSA(G->cmsa); t++){
	      if(ContigBlkCMSA(t,G->cmsa) && memC.Chance(1) >= SampleUniformProb()){
		if(ShiftCMSA(G->cmsa,t)){ memC.Success(1); flag=TRUE; }
	      }
	  }
	  if(flag) { ppg->Update('p'); flag=FALSE; }
	  // for(t=1; t<=nBlksCMSA(G->cmsa); t++){ std::cerr << "BLOCKS:";  memB.Put(stderr,t); }
	  // for(i=1; i<=4; i++) if(memC.Chance(i) > 0.5){ std::cerr << "COLUMNS:";  memC.Put(stderr,i); }
	  // if(G->test[1]) for(i=1; i<=4; i++)if(!memC.Empty(i)){ std::cerr << "COLUMNS:";  memC.Put(stderr,i); }
if(debug) if(stage > 0 && !memC.Empty(5)){ std::cerr << "END COLUMNS:";  memC.Put(stderr,5); }

	  if(G->mod_temp && G->temp0 > 0){
		// if(G->temp0 > 75.) SetTemperatureGibbs(G->temp0-1.0, G);
		if(G->temp0 > 75.){ SetTemperatureGibbs(G->temp0-2.0, G);
		    // fprintf(stderr,"*************** temperature = %2f K **************\n", G->temp0);
		}
	  } else {
	    /********************* 2d. BLOCK-BASED SEQ. SAMPLING. ********************/
if(map > 0.0){  	//=================== sticky sampling... =======================
	   double  dd,MaxFrctn=0.20;
	   Int4    percent_ident=50,NumSets,sq,N=NumSeqsCMSA(G->cmsa);
	   set_typ *set=RtnTargetSizeSetsCMSA(NumSets, percent_ident,G->cmsa,MaxFrctn);
	   dh_type dH=0; 
	   for(i=1; i <= NumSets; i++){
	      x=CardSet(set[i]);
              if(x==1){ Int4 *Sq=ListSet(set[i]); ppg->Propagate(Sq[0],&prb,moved);  free(Sq); }
              else {
                for(dH=dheap(N+5,4),sq=1; sq <= N; sq++){
                   if(MemberSet(sq,set[i]))	// align worst first...
                      { insrtHeap(sq,(keytyp)GetTotalProbCMSA(sq, G->cmsa),dH); }
                } ppg->MultiPropagate(set[i],&dd,dH); Nildheap(dH);
              }
              if((TotLike=TotLikeGibbs(G)) > best){ 
	        best=TotLike;
	        if((nruns >= 0 || stage > 1) && map < best){
		  map=best; SaveBestCMSA(G->cmsa);
		  if(G->mod_temp && G->temp0 > 0){ fprintf(stderr,"map=%.2f (%.2f K)\n",map,G->temp0); }
	        }
	      } else {
		if(map > 0 && TotLike < 0.8*map){  // then start over...
		     if(AlignedCMSA(G->cmsa)){ InitMAPCMSA(G->cmsa); ppg->Update('p'); }
	        }
	      } NilSet(set[i]);
	   } free(set);
} else { 	//=================== sample one-at-a-time ======================
	    max_prb=-999999999.0; min_prb=+999999999.0;
   	    tot_try=tot_moves=0;
       	    for(n = 1; n <= N; n++) insrtHeap(n,(keytyp) Random(),dH); 
       	    while((n=delminHeap(dH)) != NULL){ 
             if((sqmv=ppg->Propagate(n,&prb,moved)) > 0){
         	if((TotLike=TotLikeGibbs(G)) > best){ 
         	   num_fail=number=0; best=TotLike; 
         	   if((nruns >= 0 || stage > 1) && map < best){ 
		     map=best; SaveBestCMSA(G->cmsa); 
		     if(G->mod_temp && G->temp0 > 0)
			{ fprintf(stderr,"map = %.2f @ %.2f K\n", map,G->temp0); }
		   }
	        } else if(map > 0 && TotLike < 0.8*map){  // then start over...
			if(AlignedCMSA(G->cmsa)){ InitMAPCMSA(G->cmsa); ppg->Update('p'); }
	        }
	     }
          } ave_prb=((max_prb-min_prb)/4.0) + min_prb;
}
	}
	/********************* checkpoint for map ************************/
	if(G->mod_temp && G->temp0 > 0){
	   if(G->temp0 > 75.){
		SetTemperatureGibbs(G->temp0-2.0, G);
	        // fprintf(stderr,"*************** temperature = %2f K **************\n", G->temp0);
	   }
	}
	if(iter > 0){ // simulated annealing option 
	     TotLike = TotLikeGibbs(G);
	     if(TotLike > best){ 
	       if(debug) {
		ConfigCMSA(ncols, G->cmsa);
		fprintf(fp,"%4d  %5.2f ",iter,TotLike);
		for(c=0, t=1; t<=nBlksCMSA(G->cmsa); t++){	 
			fprintf(fp,"%6.1f ",FieldRelMapCMSA(G->cmsa,t));
			c+=ncols[t];
		}
		fprintf(fp,"%3d ",c);
		for(t=1; t<=nBlksCMSA(G->cmsa); t++){ fprintf(fp,"%3d ",ncols[t]); }
		fprintf(fp,"\n");
	       }
		num_fail=number=0; best=TotLike; 
		// if(stage > 0 && map < best){ map=best; SaveBestCMSA(G->cmsa); }
		if((nruns >= 0 || stage > 1) && map < best){
			map=best; SaveBestCMSA(G->cmsa); }
	     } else {
		num_fail++;
		if(TotLike < 0.8*map){  // then start over...
		 if(AlignedCMSA(G->cmsa)){
if(debug) std::cerr << "starting over with previous best alignment...\n\n"; 
		  InitMAPCMSA(G->cmsa); ppg->Update('p');
		 }
		}
	     }
	}
	if(debug) fprintf(stderr,
		"********** %d: cols=%d; blks=%d; num_fail=%d; LLR=%.1f *********\n",
		run,NumColumnsCMSA(G->cmsa),nBlksCMSA(G->cmsa),num_fail, map);
/********************* check for convergence ************************/
	if(iter <= 0) number=0;
	// if(++number > G->limit || num_fail > NumSeqsCMSA(G->cmsa)) {
	if(++number > G->limit) {
		if(stage == 3) {
			G->stage++; stage++; break; 
		} else if(stage == 2) { 
			G->stage++; stage++; number=G->limit-3; G->mod_temp=2; G->temp0=0;
		} else if(stage==1) { G->stage=stage=2; 
			number=G->limit-3; 
			// max_max_prb=-9999999999999.; map = 0.0;
			// number=0; // best=map=0.0;
		} else {  /** stage == 0 **/
		   G->stage=stage=1; number=0; 
		   cmvN=NumColumnsCMSA(G->cmsa);
		   SetPseudoToMapCMSA(G->cmsa);
		   best=TotLikeGibbs(G); 
		   if((nruns >= 0 || stage > 1) && map < best){
			map=best; SaveBestCMSA(G->cmsa); }
		   if(map < G->stage1_minmap){ map=0.0; break; }
		   if(nruns > 0 && G->test[1]) break;
                   if(best < 0){ /** THEN ABORT **/ break; }
		}
	}
      } // end of 'for(number=num_fail=0; iter <= nconverg; iter++)'
	if(best==lastbest || nruns <= 0) break; 
	if(lastbest < best) lastbest = best;
    } // end of 'for(run = 1; (nruns <= 0 || run <= nruns); run++)'
    Nildheap(dH); free(sq_moves); free(prob);
    if(debug) {
        if(map > 10.0) fprintf(stderr," %.1f\n", map);
	fclose(fp); 
	free(ncols);
	if(nruns > 0){
	    fp = open_file(NameSeqSetCMSA(G->cmsa),".log","a");
	    fprintf(fp,"%5.1f %3d %3ld %3d %3d\n",
		map,iter,time(NULL)-time1, c,nBlksCMSA(G->cmsa));
	    fclose(fp);
  	}
    }
    delete [] moved; delete ppg;
    return map;
}

double  gsm_typ::core_gibbs_MP(cma_typ *M, char mode, double temp, double minmap)
{
        double  map;
        gs_type G;
        cma_typ ma=*M;
        char    *Opt[100];
        Int4    i,nopt=string2argv(Opt,options); assert(nopt < 100);

        assert(ma != NULL);
        G = blank_gibbs( ); G->cmsa=ma;
        G->stage1_minmap=minmap;
        OptionsGibbs(nopt,Opt,G);
        switch (mode){
           case 'N': if(AlignedCMSA(ma)) G->nruns=0; // if ma->best != NULL: save previous best alignment.
                G->mod_temp=FALSE; G->temp0=0; G->temp=1.0; break;
           case 'D': G->nruns=-1; break; // discard previous bestmsa.
           case 'd': G->nruns=-1; break; // discard previous bestmsa.
           case 'S': G->nruns=0; break; // don't discard previous bestmsa.
           case 'H': G->mod_temp=FALSE; G->nruns=-1; G->temp0 = 0;
                G->mod_temp=FALSE; // don't change temperature during sampling
            break;      // discard previous bestmsa.
           default: print_error("SimulatedAnnealingGibbs( ) input error");
        }
        if(temp >= 0.0){ assert(SetTemperatureGibbs(temp,G)); }
        if(mode == 'N' || mode == 'd') G->mod_temp=FALSE;
        map = this->MP_gibbs_sampler(G);
        if(mode == 'H'){ SaveBestCMSA(G->cmsa); map = RelMapCMSA(G->cmsa); }
        else if(map > 0.0) InitMAPGibbs(G);
        *M = NilGibbs(G);
        for(i=0; i<nopt; i++) free(Opt[i]);
        return map;
}


// gmp_typ gmp();	openmp version of gsm_typ.
cma_typ	gsm_typ::gibbs_MP(char tweakmode)
{
	Int4	b,c,j;
	FILE 	*efp=0;
	cma_typ	rcma=0;

	{	//================= return a new rcma... ===============
	 // char	other_options[]="-T1";
	 // char	other_options[]="-T1 -m10 ";	// -m == nconverge.
	 char	other_options[]=" ";
	 {
	
	  if(cycle == 1){
	   if(use_gseq) sprintf(options,"-t1 -l%d -g %s ",limit,other_options);
	   else sprintf(options,"-t1 -l%d %s ",limit,other_options);
	   BLK=aveblk; COL=avecol;
	   if(fix){ BLK = MAXIMUM(Int4,BLK,minblk); BLK = MINIMUM(Int4,BLK,maxblk); }
	   assert(BLK > 0); assert(aveblk==BLK);
	   assert(COL <= maxlenModels);
	   assert(COL <= MAX_LENG_SITES);
	   b = SampleConfig( );
	  } else {  // cycle != 1..

	    if(use_gseq) sprintf(options,"-t1 -g -l%d %s ",limit,other_options);
	    else sprintf(options,"-t1 -l%d %s ",limit,other_options);
// std::cerr << options;  std::cerr << std::endl;
	    if(cycle > 15){ over=1; under=0; }
	    else if(cycle > 5){ over=2; under=1; } else { over=3; under=2; }
	    b = SampleConfig();
	  }	// end cycle != 1.
	 }	// end of 'else // i.e., not Run ==1 ...'
	 for(j=1; j<= b; j++){
		if(num[j] > MAX_LENG_SITES){
		    if(cmsa_in != 0){
	 		PutConfigCMSA(stderr,cmsa_in);
			FILE *Xfp=open_file("core_dump",".cma","w");
			PutCMSA(Xfp,cmsa_in); fclose(Xfp);
		    } assert(num[j] <= MAX_LENG_SITES);
		}
	 }
	 if(StrtLens) rcma=RandomCMSA(StrtBlks,StrtLens,*gss); 
	 else rcma=RandomCMSA(b,num, *gss);	// WARNING: model == NULL.
	BooLean	found;
	Int4 iter=0; // MaxIter=4; by default == five rounds maximum!
	SmplBlksCols=TRUE;
	char mode='S';
	double Temp=100;
	do {
	  found=FALSE;
	  if(efp) PutConfigCMSA(stderr,rcma);
	  if(iter==0){
	     // InitCMSA(rcma);
	     map = core_gibbs(&rcma,'N',150); 
	     if(map < 5.0) break; 
	     if(efp) fprintf(stderr,"iter %d of core_gibbs; map=%.3f; %d blks; %d cols.\n",
			iter,map,nBlksCMSA(rcma),NumColumnsCMSA(rcma));
	     if(efp) PutConfigCMSA(stderr,rcma); iter++;
	  } if(AlignedCMSA(rcma)){ InitMAPCMSA(rcma); } // save the best...
	  for(b=1; b <= nBlksCMSA(rcma); b++){
	      if(nBlksCMSA(rcma) >= MAX_NO_TYPESITES) break;
	      Int4 lft_len,len=LengthCMSA(b,rcma);
	      if(len >= 12){
	        found=TRUE; lft_len=len/2;
	        cma_typ rcma=SplitBlkCMSA(b,lft_len,5,rcma);
	        assert(rcma != 0); NilCMSA(rcma); rcma=rcma;
	  	if(efp) PutConfigCMSA(stderr,rcma); b--;
	      }
  	  }
	  if(found) SaveBestCMSA(rcma);	// save this new configuration as the best...
	  if(iter < 2) found=TRUE;  // go at least 2 iterations.
	  if(iter==MaxIter || !found) this->SmplBlksCols=FALSE;
	  map = core_gibbs(&rcma); this->SmplBlksCols=TRUE;
	  if(map < 5.0) break;
	  if(efp) fprintf(stderr,"iter %d of core_gibbs; map=%.3f; %d blks; %d cols.\n",
			iter,map,nBlksCMSA(rcma),NumColumnsCMSA(rcma));
	  if(efp) PutConfigCMSA(stderr,rcma);
	  Temp = MAXIMUM(double,Temp-50,0.0);
  	  if(iter >= MaxIter) break;	
	  iter++;
	} while(found);
	 if(map <= 5.0) { NilCMSA(rcma); rcma = NULL; return 0; }
  	 Record( ); return rcma; 
	} return 0;
}

Int4	gsm_typ::create_cma_MP(Int4 &num_success,Int4 max_futile)
// BUILD INITIAL POPULATION (MSAHEAP).
{
   Int4		failed_attempts=0;
   UInt4	time0b;
   cma_typ	xcma,zcma;
   double	avelen=0.0,dd,d;
   BooLean	improved;

// called routines: gibbs_MP();	// see above.
// global: cycle, maxcycle,num_success, item,max_futile, maxblk, minblk

   num_success=0; item=NULL; time0b=time(NULL); 
// fprintf(stderr,"********** maxcycle=%d **********\n",maxcycle);
   for(cycle=1; cycle <= maxcycle; cycle++){
	time0=time(NULL); 
	zcma=this->gibbs_MP();
	if(zcma){ InitMAPCMSA(zcma); map=UnGappedRelMapCMSA(zcma); Record( ); }
	if(zcma && map > 0) {  // THEN ADD ALIGNMENT TO HEAP.
   	    while(this->DeletePoor()){
		InitMAPCMSA(zcma); map=UnGappedRelMapCMSA(zcma);
	     	Record( ); // if(map > bestmap){ bestmap=map; PutAlnCMSA(name,zcma,Guide); }
	    }
	    if(bestmsa != 0 && bestmsa != zcma){
		NilCMSA(zcma); zcma=bestmsa; bestmsa=0; bestmap=-9999999999.;
	    }
	    dd=UnGappedRelMapCMSA(zcma);
	    if((item=InsertMSAHeap(zcma,dd,maH))==0){ NilCMSA(zcma); } zcma=0; 
   	    num_success++; ConvergedMSAHeap(maH);
	    if(BestItemMSAheap(maH) != item){ // i.e., new optimum alignment.
		item = BestItemMSAheap(maH);
		xcma=SeeMSAHeap(item,maH);
	    	aveblk = 3 + nBlksCMSA(xcma); 
	    } failed_attempts=0;
	} else {	// found a lousy alignment, so delete it.
		if(zcma!=NULL) NilCMSA(zcma); zcma=NULL; 
		cycle--; failed_attempts++; 
		d = (double)num_success/(double)(num_success + failed_attempts);
		if(failed_attempts > max_futile || d < 0.25){
			return 1; // print_error("failed to find a motif");
		} else if(failed_attempts % 10 == 0) { 
		   if(!fix){
			minblk--; maxblk--; minblk = MAXIMUM(Int4,minblk,1); 
			if(maxblk < minblk) maxblk = minblk;
		   }
		}
	} 
     }
     if(0) fprintf(stderr,"\tcreate_cma time: %d seconds (%0.2f minutes)\n",
                time(NULL)-time0b,(float)(time(NULL)-time0b)/60.0);
     return 0;
}

