/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

/****************** residues.h .***************/
/*************************** for alphabet datastructure *****************
*************************************************************************/
#if !defined(RESIDUES)
#define RESIDUES

/******************************* PROTEIN ******************************/
/* PROTEIN: macro definitions and static types for amino acid alphabet. */
#define AMINO_ACIDS		"XCGASTNDEQKRHWYFVILMP"

/******* ordering of closely related amino acids.  *******/
                     /* . . . . 5 . . . .10 . . . .15 . . . .20 . . . .25 .*/
#define SREL26_BLSM62 "FYIVYWRKLMQEHYILDESTQKNDMIASRQFWLVEKMVNSNHQHFLAGMFNQ"

		/*       . . . . . . . . . . . . . . . . . . . . . . . . . . */
#define	SRELATE_BLSM62 "FYIVYWRKLMQEHYILDESTQKNDMIASRQFWLVEKMVNSNHQHFLAGMFNQTATNVTSQ"

#define GBLAST_BLOSUM62          "\
X -1 -2 -1  0  0  0 -1 -1 -1 -1 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -2 \
C -2  9 -3  0 -1 -1 -3 -3 -4 -3 -3 -3 -3 -2 -2 -2 -1 -1 -1 -1 -3 \
G -1 -3  6  0  0 -2  0 -1 -2 -2 -2 -2 -2 -2 -3 -3 -3 -4 -4 -3 -2 \
A  0  0  0  4  1  0 -2 -2 -1 -1 -1 -1 -2 -3 -2 -2  0 -1 -1 -1 -1 \
S  0 -1  0  1  4  1  1  0  0  0  0 -1 -1 -3 -2 -2 -2 -2 -2 -1 -1 \
T  0 -1 -2  0  1  5  0 -1 -1 -1 -1 -1 -2 -2 -2 -2  0 -1 -1 -1 -1 \
N -1 -3  0 -2  1  0  6  1  0  0  0  0  1 -4 -2 -3 -3 -3 -3 -2 -2 \
D -1 -3 -1 -2  0 -1  1  6  2  0 -1 -2 -1 -4 -3 -3 -3 -3 -4 -3 -1 \
E -1 -4 -2 -1  0 -1  0  2  5  2  1  0  0 -3 -2 -3 -2 -3 -3 -2 -1 \
Q -1 -3 -2 -1  0 -1  0  0  2  5  1  1  0 -2 -1 -3 -2 -3 -2  0 -1 \
K -1 -3 -2 -1  0 -1  0 -1  1  1  5  2 -1 -3 -2 -3 -2 -3 -2 -1 -1 \
R -1 -3 -2 -1 -1 -1  0 -2  0  1  2  5  0 -3 -2 -3 -3 -3 -2 -1 -2 \
H -1 -3 -2 -2 -1 -2  1 -1  0  0 -1  0  8 -2  2 -1 -3 -3 -3 -2 -2 \
W -2 -2 -2 -3 -3 -2 -4 -4 -3 -2 -3 -3 -2 11  2  1 -3 -3 -2 -1 -4 \
Y -1 -2 -3 -2 -2 -2 -2 -3 -2 -1 -2 -2  2  2  7  3 -1 -1 -1 -1 -3 \
F -1 -2 -3 -2 -2 -2 -3 -3 -3 -3 -3 -3 -1  1  3  6 -1  0  0  0 -4 \
V -1 -1 -3  0 -2  0 -3 -3 -2 -2 -2 -3 -3 -3 -1 -1  4  3  1  1 -2 \
I -1 -1 -4 -1 -2 -1 -3 -3 -3 -3 -3 -3 -3 -3 -1  0  3  4  2  1 -3 \
L -1 -1 -4 -1 -2 -1 -3 -4 -3 -2 -2 -2 -3 -2 -1  0  1  2  4  2 -3 \
M -1 -1 -3 -1 -1 -1 -2 -3 -2  0 -1 -1 -2 -1 -1  0  1  1  2  5 -2 \
P -2 -3 -2 -1 -1 -1 -2 -1 -1 -1 -1 -2 -2 -4 -3 -4 -2 -3 -3 -2  7"
/* X  C  G  A  S  T  N  D  E  Q  K  R  H  W  Y  F  V  I  L  M  P */

#define PROT_BLOSUM62          GBLAST_BLOSUM62

#define OLD_PROT_BLOSUM62          "\
X -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 -9 \
C -9  9 -3  0 -1 -1 -3 -3 -4 -3 -3 -3 -3 -2 -2 -2 -1 -1 -1 -1 -3 \
G -9 -3  6  0  0 -2  0 -1 -2 -2 -2 -2 -2 -2 -3 -3 -3 -4 -4 -3 -2 \
A -9  0  0  4  1  0 -2 -2 -1 -1 -1 -1 -2 -3 -2 -2  0 -1 -1 -1 -1 \
S -9 -1  0  1  4  1  1  0  0  0  0 -1 -1 -3 -2 -2 -2 -2 -2 -1 -1 \
T -9 -1 -2  0  1  5  0 -1 -1 -1 -1 -1 -2 -2 -2 -2  0 -1 -1 -1 -1 \
N -9 -3  0 -2  1  0  6  1  0  0  0  0  1 -4 -2 -3 -3 -3 -3 -2 -2 \
D -9 -3 -1 -2  0 -1  1  6  2  0 -1 -2 -1 -4 -3 -3 -3 -3 -4 -3 -1 \
E -9 -4 -2 -1  0 -1  0  2  5  2  1  0  0 -3 -2 -3 -2 -3 -3 -2 -1 \
Q -9 -3 -2 -1  0 -1  0  0  2  5  1  1  0 -2 -1 -3 -2 -3 -2  0 -1 \
K -9 -3 -2 -1  0 -1  0 -1  1  1  5  2 -1 -3 -2 -3 -2 -3 -2 -1 -1 \
R -9 -3 -2 -1 -1 -1  0 -2  0  1  2  5  0 -3 -2 -3 -3 -3 -2 -1 -2 \
H -9 -3 -2 -2 -1 -2  1 -1  0  0 -1  0  8 -2  2 -1 -3 -3 -3 -2 -2 \
W -9 -2 -2 -3 -3 -2 -4 -4 -3 -2 -3 -3 -2 11  2  1 -3 -3 -2 -1 -4 \
Y -9 -2 -3 -2 -2 -2 -2 -3 -2 -1 -2 -2  2  2  7  3 -1 -1 -1 -1 -3 \
F -9 -2 -3 -2 -2 -2 -3 -3 -3 -3 -3 -3 -1  1  3  6 -1  0  0  0 -4 \
V -9 -1 -3  0 -2  0 -3 -3 -2 -2 -2 -3 -3 -3 -1 -1  4  3  1  1 -2 \
I -9 -1 -4 -1 -2 -1 -3 -3 -3 -3 -3 -3 -3 -3 -1  0  3  4  2  1 -3 \
L -9 -1 -4 -1 -2 -1 -3 -4 -3 -2 -2 -2 -3 -2 -1  0  1  2  4  2 -3 \
M -9 -1 -3 -1 -1 -1 -2 -3 -2  0 -1 -1 -2 -1 -1  0  1  1  2  5 -2 \
P -9 -3 -2 -1 -1 -1 -2 -1 -1 -1 -1 -2 -2 -4 -3 -4 -2 -3 -3 -2  7"
/* X  C  G  A  S  T  N  D  E  Q  K  R  H  W  Y  F  V  I  L  M  P */

#define PROT_BLOSUM45          "\
X -1 -2 -1  0  0  0 -1 -1 -1 -1 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1  \
C -2 12 -3 -1 -1 -1 -2 -3 -3 -3 -3 -3 -3 -5 -3 -2 -1 -3 -2 -2 -4  \
G -1 -3  7  0  0 -2  0 -1 -2 -2 -2 -2 -2 -2 -3 -3 -3 -4 -3 -2 -2  \
A  0 -1  0  5  1  0 -1 -2 -1 -1 -1 -2 -2 -2 -2 -2  0 -1 -1 -1 -1  \
S  0 -1  0  1  4  2  1  0  0  0 -1 -1 -1 -4 -2 -2 -1 -2 -3 -2 -1  \
T  0 -1 -2  0  2  5  0 -1 -1 -1 -1 -1 -2 -3 -1 -1  0 -1 -1 -1 -1  \
N -1 -2  0 -1  1  0  6  2  0  0  0  0  1 -4 -2 -2 -3 -2 -3 -2 -2  \
D -1 -3 -1 -2  0 -1  2  7  2  0  0 -1  0 -4 -2 -4 -3 -4 -3 -3 -1  \
E -1 -3 -2 -1  0 -1  0  2  6  2  1  0  0 -3 -2 -3 -3 -3 -2 -2  0  \
Q -1 -3 -2 -1  0 -1  0  0  2  6  1  1  1 -2 -1 -4 -3 -2 -2  0 -1  \
K -1 -3 -2 -1 -1 -1  0  0  1  1  5  3 -1 -2 -1 -3 -2 -3 -3 -1 -1  \
R -1 -3 -2 -2 -1 -1  0 -1  0  1  3  7  0 -2 -1 -2 -2 -3 -2 -1 -2  \
H -1 -3 -2 -2 -1 -2  1  0  0  1 -1  0 10 -3  2 -2 -3 -3 -2  0 -2  \
W -2 -5 -2 -2 -4 -3 -4 -4 -3 -2 -2 -2 -3 15  3  1 -3 -2 -2 -2 -3  \
Y -1 -3 -3 -2 -2 -1 -2 -2 -2 -1 -1 -1  2  3  8  3 -1  0  0  0 -3  \
F -1 -2 -3 -2 -2 -1 -2 -4 -3 -4 -3 -2 -2  1  3  8  0  0  1  0 -3  \
V -1 -1 -3  0 -1  0 -3 -3 -3 -3 -2 -2 -3 -3 -1  0  5  3  1  1 -3  \
I -1 -3 -4 -1 -2 -1 -2 -4 -3 -2 -3 -3 -3 -2  0  0  3  5  2  2 -2  \
L -1 -2 -3 -1 -3 -1 -3 -3 -2 -2 -3 -2 -2 -2  0  1  1  2  5  2 -3  \
M -1 -2 -2 -1 -2 -1 -2 -3 -2  0 -1 -1  0 -2  0  0  1  2  2  6 -2  \
P -1 -4 -2 -1 -1 -1 -2 -1  0 -1 -1 -2 -2 -3 -3 -3 -3 -2 -3 -2  9"
/* X  C  G  A  S  T  N  D  E  Q  K  R  H  W  Y  F  V  I  L  M  P */

#define SSEARCH_PAM250          "\
X -1 -3 -1  0  0  0  0 -1 -1 -1 -1 -1 -1 -4 -2 -2 -1 -1 -1 -1 -1  \
C -3 12 -3 -2  0 -2 -4 -5 -5 -5 -5 -4 -3 -8  0 -4 -2 -2 -6 -5 -3  \
G -1 -3  5  1  1  0  0  1  0 -1 -2 -3 -2 -7 -5 -5 -1 -3 -4 -3 -1  \
A  0 -2  1  2  1  1  0  0  0  0 -1 -2 -1 -6 -3 -4  0 -1 -2 -1  1  \
S  0  0  1  1  2  1  1  0  0 -1  0  0 -1 -2 -3 -3 -1 -1 -3 -2  1  \
T  0 -2  0  1  1  3  0  0  0 -1  0 -1 -1 -5 -3 -3  0  0 -2 -1  0  \
N  0 -4  0  0  1  0  2  2  1  1  1  0  2 -4 -2 -4 -2 -2 -3 -2 -1  \
D -1 -5  1  0  0  0  2  4  3  2  0 -1  1 -7 -4 -6 -2 -2 -4 -3 -1  \
E -1 -5  0  0  0  0  1  3  4  2  0 -1  1 -7 -4 -5 -2 -2 -3 -2 -1  \
Q -1 -5 -1  0 -1 -1  1  2  2  4  1  1  3 -5 -4 -5 -2 -2 -2 -1  0  \
K -1 -5 -2 -1  0  0  1  0  0  1  5  3  0 -3 -4 -5 -2 -2 -3  0 -1  \
R -1 -4 -3 -2  0 -1  0 -1 -1  1  3  6  2  2 -4 -4 -2 -2 -3  0  0  \
H -1 -3 -2 -1 -1 -1  2  1  1  3  0  2  6 -3  0 -2 -2 -2 -2 -2  0  \
W -4 -8 -7 -6 -2 -5 -4 -7 -7 -5 -3  2 -3 17  0  0 -6 -5 -2 -4 -6  \
Y -2  0 -5 -3 -3 -3 -2 -4 -4 -4 -4 -4  0  0 10  7 -2 -1 -1 -2 -5  \
F -2 -4 -5 -4 -3 -3 -4 -6 -5 -5 -5 -4 -2  0  7  9 -1  1  2  0 -5  \
V -1 -2 -1  0 -1  0 -2 -2 -2 -2 -2 -2 -2 -6 -2 -1  4  4  2  2 -1  \
I -1 -2 -3 -1 -1  0 -2 -2 -2 -2 -2 -2 -2 -5 -1  1  4  5  2  2 -2  \
L -1 -6 -4 -2 -3 -2 -3 -4 -3 -2 -3 -3 -2 -2 -1  2  2  2  6  4 -3  \
M -1 -5 -3 -1 -2 -1 -2 -3 -2 -1  0  0 -2 -4 -2  0  2  2  4  6 -2  \
P -1 -3 -1  1  1  0 -1 -1 -1  0 -1  0  0 -6 -5 -5 -1 -2 -3 -2  6"
/* X  C  G  A  S  T  N  D  E  Q  K  R  H  W  Y  F  V  I  L  M  P */

#define PROT_PAM250          "\
X -1 -3 -1  0  0  0  0 -1 -1 -1 -1 -1 -1 -4 -2 -2 -1 -1 -1 -1 -1  \
C -3 12 -3 -2  0 -2 -4 -5 -5 -5 -5 -4 -3 -8  0 -4 -2 -2 -6 -5 -3  \
G -1 -3  5  1  1  0  0  1  0 -1 -2 -3 -2 -7 -5 -5 -1 -3 -4 -3  0  \
A  0 -2  1  2  1  1  0  0  0  0 -1 -2 -1 -6 -3 -3  0 -1 -2 -1  1  \
S  0  0  1  1  2  1  1  0  0 -1  0  0 -1 -2 -3 -3 -1 -1 -3 -2  1  \
T  0 -2  0  1  1  3  0  0  0 -1  0 -1 -1 -5 -3 -3  0  0 -2 -1  0  \
N  0 -4  0  0  1  0  2  2  1  1  1  0  2 -4 -2 -3 -2 -2 -3 -2  0  \
D -1 -5  1  0  0  0  2  4  3  2  0 -1  1 -7 -4 -6 -2 -2 -4 -3 -1  \
E -1 -5  0  0  0  0  1  3  4  2  0 -1  1 -7 -4 -5 -2 -2 -3 -2 -1  \
Q -1 -5 -1  0 -1 -1  1  2  2  4  1  1  3 -5 -4 -5 -2 -2 -2 -1  0  \
K -1 -5 -2 -1  0  0  1  0  0  1  5  3  0 -3 -4 -5 -2 -2 -3  0 -1  \
R -1 -4 -3 -2  0 -1  0 -1 -1  1  3  6  2  2 -4 -4 -2 -2 -3  0  0  \
H -1 -3 -2 -1 -1 -1  2  1  1  3  0  2  6 -3  0 -2 -2 -2 -2 -2  0  \
W -4 -8 -7 -6 -2 -5 -4 -7 -7 -5 -3  2 -3 17  0  0 -6 -5 -2 -4 -6  \
Y -2  0 -5 -3 -3 -3 -2 -4 -4 -4 -4 -4  0  0 10  7 -2 -1 -1 -2 -5  \
F -2 -4 -5 -3 -3 -3 -3 -6 -5 -5 -5 -4 -2  0  7  9 -1  1  2  0 -5  \
V -1 -2 -1  0 -1  0 -2 -2 -2 -2 -2 -2 -2 -6 -2 -1  4  4  2  2 -1  \
I -1 -2 -3 -1 -1  0 -2 -2 -2 -2 -2 -2 -2 -5 -1  1  4  5  2  2 -2  \
L -1 -6 -4 -2 -3 -2 -3 -4 -3 -2 -3 -3 -2 -2 -1  2  2  2  6  4 -3  \
M -1 -5 -3 -1 -2 -1 -2 -3 -2 -1  0  0 -2 -4 -2  0  2  2  4  6 -2  \
P -1 -3  0  1  1  0  0 -1 -1  0 -1  0  0 -6 -5 -5 -1 -2 -3 -2  6"

#define PROT_PAM120          "\
X -2 -4 -2 -1 -1 -1 -1 -2 -1 -1 -2 -2 -2 -5 -3 -3 -1 -1 -2 -2 -2  \
C -4  9 -4 -3  0 -3 -5 -7 -7 -7 -7 -4 -4 -8 -1 -6 -3 -3 -7 -6 -4  \
G -2 -4  5  1  1 -1  0  0 -1 -3 -3 -4 -4 -8 -6 -5 -2 -4 -5 -4 -2  \
A -1 -3  1  3  1  1 -1  0  0 -1 -2 -3 -3 -7 -4 -4  0 -1 -3 -2  1  \
S -1  0  1  1  3  2  1  0 -1 -2 -1 -1 -2 -2 -3 -3 -2 -2 -4 -2  1  \
T -1 -3 -1  1  2  4  0 -1 -2 -2 -1 -2 -3 -6 -3 -4  0  0 -3 -1 -1  \
N -1 -5  0 -1  1  0  4  2  1  0  1 -1  2 -4 -2 -4 -3 -2 -4 -3 -2  \
D -2 -7  0  0  0 -1  2  5  3  1 -1 -3  0 -8 -5 -7 -3 -3 -5 -4 -3  \
E -1 -7 -1  0 -1 -2  1  3  5  2 -1 -3 -1 -8 -5 -7 -3 -3 -4 -3 -2  \
Q -1 -7 -3 -1 -2 -2  0  1  2  6  0  1  3 -6 -5 -6 -3 -3 -2 -1  0  \
K -2 -7 -3 -2 -1 -1  1 -1 -1  0  5  2 -2 -5 -5 -7 -4 -3 -4  0 -2  \
R -2 -4 -4 -3 -1 -2 -1 -3 -3  1  2  6  1  1 -5 -5 -3 -2 -4 -1 -1  \
H -2 -4 -4 -3 -2 -3  2  0 -1  3 -2  1  7 -3 -1 -3 -3 -4 -3 -4 -1  \
W -5 -8 -8 -7 -2 -6 -4 -8 -8 -6 -5  1 -3 12 -2 -1 -8 -6 -3 -6 -7  \
Y -3 -1 -6 -4 -3 -3 -2 -5 -5 -5 -5 -5 -1 -2  8  4 -3 -2 -2 -4 -6  \
F -3 -6 -5 -4 -3 -4 -4 -7 -7 -6 -7 -5 -3 -1  4  8 -3  0  0 -1 -5  \
V -1 -3 -2  0 -2  0 -3 -3 -3 -3 -4 -3 -3 -8 -3 -3  5  3  1  1 -2  \
I -1 -3 -4 -1 -2  0 -2 -3 -3 -3 -3 -2 -4 -6 -2  0  3  6  1  1 -3  \
L -2 -7 -5 -3 -4 -3 -4 -5 -4 -2 -4 -4 -3 -3 -2  0  1  1  5  3 -3  \
M -2 -6 -4 -2 -2 -1 -3 -4 -3 -1  0 -1 -4 -6 -4 -1  1  1  3  8 -3  \
P -2 -4 -2  1  1 -1 -2 -3 -2  0 -2 -1 -1 -7 -6 -5 -2 -3 -3 -3  6"

#define PAM_AMINO_ACIDS		"XARNDCQEGHILKMFPSTWYV"

#define BLST_BLOSUM45          "\
/* X  A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V */\
X -1  0 -1 -1 -1 -2 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  0  0 -2 -1 -1  \
A  0  5 -2 -1 -2 -1 -1 -1  0 -2 -1 -1 -1 -1 -2 -1  1  0 -2 -2  0  \
R -1 -2  7  0 -1 -3  1  0 -2  0 -3 -2  3 -1 -2 -2 -1 -1 -2 -1 -2  \
N -1 -1  0  6  2 -2  0  0  0  1 -2 -3  0 -2 -2 -2  1  0 -4 -2 -3  \
D -1 -2 -1  2  7 -3  0  2 -1  0 -4 -3  0 -3 -4 -1  0 -1 -4 -2 -3  \
C -2 -1 -3 -2 -3 12 -3 -3 -3 -3 -3 -2 -3 -2 -2 -4 -1 -1 -5 -3 -1  \
Q -1 -1  1  0  0 -3  6  2 -2  1 -2 -2  1  0 -4 -1  0 -1 -2 -1 -3  \
E -1 -1  0  0  2 -3  2  6 -2  0 -3 -2  1 -2 -3  0  0 -1 -3 -2 -3  \
G -1  0 -2  0 -1 -3 -2 -2  7 -2 -4 -3 -2 -2 -3 -2  0 -2 -2 -3 -3  \
H -1 -2  0  1  0 -3  1  0 -2 10 -3 -2 -1  0 -2 -2 -1 -2 -3  2 -3  \
I -1 -1 -3 -2 -4 -3 -2 -3 -4 -3  5  2 -3  2  0 -2 -2 -1 -2  0  3  \
L -1 -1 -2 -3 -3 -2 -2 -2 -3 -2  2  5 -3  2  1 -3 -3 -1 -2  0  1  \
K -1 -1  3  0  0 -3  1  1 -2 -1 -3 -3  5 -1 -3 -1 -1 -1 -2 -1 -2  \
M -1 -1 -1 -2 -3 -2  0 -2 -2  0  2  2 -1  6  0 -2 -2 -1 -2  0  1  \
F -1 -2 -2 -2 -4 -2 -4 -3 -3 -2  0  1 -3  0  8 -3 -2 -1  1  3  0  \
P -1 -1 -2 -2 -1 -4 -1  0 -2 -2 -2 -3 -1 -2 -3  9 -1 -1 -3 -3 -3  \
S  0  1 -1  1  0 -1  0  0  0 -1 -2 -3 -1 -2 -2 -1  4  2 -4 -2 -1  \
T  0  0 -1  0 -1 -1 -1 -1 -2 -2 -1 -1 -1 -1 -1 -1  2  5 -3 -1  0  \
W -2 -2 -2 -4 -4 -5 -2 -3 -2 -3 -2 -2 -2 -2  1 -3 -4 -3 15  3 -3  \
Y -1 -2 -1 -2 -2 -3 -1 -2 -3  2  0  0 -1  0  3 -3 -2 -1  3  8 -1  \
V -1  0 -2 -3 -3 -1 -3 -3 -3 -3  3  1 -2  1  0 -3 -1  0 -3 -1  5"

#endif 
