/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

/** input files: wjw.pmf1 wjw.pmf2 wjw.pmf3 wjw.pmf4 wjw.pmf5 wjw.pmf6  **/
#if !defined (CONTACT_ENERGIES)
#define CONTACT_ENERGIES
static double contact_energies[7][22][22] = { 
 { {0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},
  {0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0} }, 
 { /** d = 1 ( 0-5  Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, 1.17714, 0.52237, 0.40872, 0.38994, 0.24592, -0.10319, 0.08566,
    -0.25916, -0.45099, -1.28637, -0.21733, 0.55938, 0.42686, 0.48228,
    0.67893, 0.63831, 1.03205, 0.52081, 0.55670, 0.54278, 0.66780 },
  { 0, 0.52237, 0.08408, -0.03332, 0.00730, 0.05433, -0.21924, -0.03420,
    -0.41523, -0.21032, -0.55487, -0.32435, -0.07318, 0.15176, 0.11117,
    -0.19103, 0.15289, 0.17127, 0.14517, 0.12161, -0.10202, 0.50479 },
  { 0, 0.40872, -0.03332, 0.25197, 0.02519, 0.17905, -0.24285, -0.27770,
    -0.40622, -0.04137, -0.32016, -0.36578, 0.36473, 0.30391, 0.49480,
    0.36583, 0.88581, 1.06611, 0.61844, 0.80213, 0.23572, 0.44752 },
  { 0, 0.38994, 0.00730, 0.02519, -0.05099, 0.26965, -0.09083, 0.08669,
    -0.35871, -0.68891, -0.35244, -0.20761, -0.13550, -0.21902, -0.31818,
    -0.20037, -0.13100, -0.06432, -0.35819, -0.16190, -0.14078, 0.23189 },
  { 0, 0.24592, 0.05433, 0.17905, 0.26965, 0.19534, -0.36700, -0.00553,
    -0.51842, -0.41097, -0.38775, -0.67951, -0.07626, 0.08015, -0.32723,
    0.13947, -0.02564, 0.06398, -0.00222, 0.05094, -0.15055, 0.06978 },
  { 0, -0.10319, -0.21924, -0.24285, -0.09083, -0.36700, -0.44331, -0.16906,
    -0.52742, -0.42802, -1.04457, -0.39113, -0.13863, -0.68293, 0.39045,
    -0.40316, -0.19745, -0.49051, -0.62216, -0.53184, -0.41701, -0.09235 },
  { 0, 0.08566, -0.03420, -0.27770, 0.08669, -0.00553, -0.16906, -1.29530,
    -0.66466, -0.54091, -0.11721, -0.22103, -0.06270, -1.48473, -0.84802,
    -0.23883, -0.53406, -0.31692, -0.56182, -0.27747, -0.53629, -0.34993 },
  { 0, -0.25916, -0.41523, -0.40622, -0.35871, -0.51842, -0.52742, -0.66466,
    -1.98974, -0.02779, -0.18035, -0.11824, -0.49161, -0.19637, -0.23652,
    -0.47788, -0.43459, -0.55901, -0.81191, -0.45546, -0.38372, -0.56612 },
  { 0, -0.45099, -0.21032, -0.04137, -0.68891, -0.41097, -0.42802, -0.54091,
    -0.02779, -0.15123, -0.60762, -0.88291, -0.49235, -0.56941, -0.03043,
    -0.31640, 0.18580, -0.02042, -0.54895, -0.10596, 0.27122, -0.46496 },
  { 0, -1.28637, -0.55487, -0.32016, -0.35244, -0.38775, -1.04457, -0.11721,
    -0.18035, -0.60762, -1.56245, -1.60177, -0.21723, 0.50453, 0.02064,
    -0.49915, -0.46544, -0.14965, -0.35049, -0.64765, -0.54914, -0.50010 },
  { 0, -0.21733, -0.32435, -0.36578, -0.20761, -0.67951, -0.39113, -0.22103,
    -0.11824, -0.88291, -1.60177, -0.59519, -0.43531, 0.05373, -0.18943,
    -0.09430, -0.07359, -0.06537, -0.61131, -0.68125, -0.17704, -0.26087 },
  { 0, 0.55938, -0.07318, 0.36473, -0.13550, -0.07626, -0.13863, -0.06270,
    -0.49161, -0.49235, -0.21723, -0.43531, -0.30131, 0.32309, 0.57436,
    0.44348, 0.32459, 0.39737, 0.14900, -0.05003, 0.02543, -0.07618 },
  { 0, 0.42686, 0.15176, 0.30391, -0.21902, 0.08015, -0.68293, -1.48473,
    -0.19637, -0.56941, 0.50453, 0.05373, 0.32309, -0.34696, 0.50961,
    0.62249, 0.49967, 0.97507, 0.94771, 1.16084, 0.50863, -0.08490 },
  { 0, 0.48228, 0.11117, 0.49480, -0.31818, -0.32723, 0.39045, -0.84802,
    -0.23652, -0.03043, 0.02064, -0.18943, 0.57436, 0.50961, 0.23778,
    0.81669, 0.43462, 0.61499, 0.64624, 0.64020, 0.17020, 0.24556 },
  { 0, 0.67893, -0.19103, 0.36583, -0.20037, 0.13947, -0.40316, -0.23883,
    -0.47788, -0.31640, -0.49915, -0.09430, 0.44348, 0.62249, 0.81669,
    0.67808, 0.83071, 0.89597, 0.85022, 0.95598, 0.35730, 0.00137 },
  { 0, 0.63831, 0.15289, 0.88581, -0.13100, -0.02564, -0.19745, -0.53406,
    -0.43459, 0.18580, -0.46544, -0.07359, 0.32459, 0.49967, 0.43462,
    0.83071, 1.21262, 0.82956, 0.87243, 0.74834, -0.05586, 0.03202 },
  { 0, 1.03205, 0.17127, 1.06611, -0.06432, 0.06398, -0.49051, -0.31692,
    -0.55901, -0.02042, -0.14965, -0.06537, 0.39737, 0.97507, 0.61499,
    0.89597, 0.82956, 0.63225, 0.64577, 0.59039, -0.07440, -0.24490 },
  { 0, 0.52081, 0.14517, 0.61844, -0.35819, -0.00222, -0.62216, -0.56182,
    -0.81191, -0.54895, -0.35049, -0.61131, 0.14900, 0.94771, 0.64624,
    0.85022, 0.87243, 0.64577, 0.33581, 0.58271, 0.31957, -0.17973 },
  { 0, 0.55670, 0.12161, 0.80213, -0.16190, 0.05094, -0.53184, -0.27747,
    -0.45546, -0.10596, -0.64765, -0.68125, -0.05003, 1.16084, 0.64020,
    0.95598, 0.74834, 0.59039, 0.58271, 0.40120, 0.31853, -0.11789 },
  { 0, 0.54278, -0.10202, 0.23572, -0.14078, -0.15055, -0.41701, -0.53629,
    -0.38372, 0.27122, -0.54914, -0.17704, 0.02543, 0.50863, 0.17020,
    0.35730, -0.05586, -0.07440, 0.31957, 0.31853, 0.00063, -0.03980 },
  { 0, 0.66780, 0.50479, 0.44752, 0.23189, 0.06978, -0.09235, -0.34993,
    -0.56612, -0.46496, -0.50010, -0.26087, -0.07618, -0.08490, 0.24556,
    0.00137, 0.03202, -0.24490, -0.17973, -0.11789, -0.03980, 0.00000 }
 },
 { /** d = 2 (>5-6  Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, -0.08073, 0.10222, 0.29488, 0.42065, 0.09073, -0.45763, -0.85145,
    -0.00481, 0.32774, 0.17905, -0.00388, 0.77003, 1.30064, 0.84844,
    1.01742, 0.98098, 0.98514, 0.80402, 0.82301, -0.61457, 0.62654 },
  { 0, 0.10222, -0.18030, -0.09814, -0.25617, 0.03798, -0.67782, -0.47041,
    -0.59644, -0.48140, -0.89758, -0.14947, -0.29202, 0.11230, 0.52572,
    -0.02500, -0.03100, -0.32532, 0.01342, -0.17443, -0.26906, -0.18457 },
  { 0, 0.29488, -0.09814, -0.50774, -0.41348, 0.03400, -0.13082, -0.59017,
    -0.66541, -0.26094, -0.98789, -0.61858, -0.05843, 0.12790, 0.18390,
    0.52903, 0.12708, 0.75063, 0.50448, -0.07242, -0.42415, 0.16152 },
  { 0, 0.42065, -0.25617, -0.41348, -0.31638, -0.26438, -0.01188, -0.25159,
    -0.29081, -0.18366, -0.52875, -0.46991, 0.18622, 0.07881, -0.30097,
    -0.07966, -0.05771, -0.11482, -0.10353, -0.10074, -0.27850, -0.16526 },
  { 0, 0.09073, 0.03798, 0.03400, -0.26438, 0.19136, -0.18459, -0.40306,
    -0.57063, -0.20122, -0.37433, -0.09744, -0.12599, -0.30732, -0.04280,
    -0.26481, 0.15324, 0.34334, 0.06346, -0.24440, -0.14987, 0.01830 },
  { 0, -0.45763, -0.67782, -0.13082, -0.01188, -0.18459, -0.07229, -0.18433,
    0.05459, -0.20919, -0.57790, -0.16557, -0.03368, -0.48727, 0.02872,
    -0.44487, -0.25811, -0.65958, -0.19519, 0.03315, -0.38975, -0.18263 },
  { 0, -0.85145, -0.47041, -0.59017, -0.25159, -0.40306, -0.18433, -1.01517,
    -1.13668, -0.45994, -0.24943, -0.02695, 0.82409, -0.67014, -0.59550,
    -0.91634, -0.54654, -0.09861, -0.53238, -0.35171, -0.92526, -0.36073 },
  { 0, -0.00481, -0.59644, -0.66541, -0.29081, -0.57063, 0.05459, -1.13668,
    -0.56948, -0.68450, 0.02442, -0.00005, -0.25741, -0.21340, -0.84731,
    -0.21102, -0.27646, -0.48624, -0.32629, -0.41980, -0.74050, -0.46893 },
  { 0, 0.32774, -0.48140, -0.26094, -0.18366, -0.20122, -0.20919, -0.45994,
    -0.68450, -0.42085, -0.51813, -0.11462, -0.61623, -0.76410, 0.10901,
    -0.23245, -0.08304, -0.14247, 0.16292, -0.06171, 0.06780, -0.16455 },
  { 0, 0.17905, -0.89758, -0.98789, -0.52875, -0.37433, -0.57790, -0.24943,
    0.02442, -0.51813, -1.23717, -1.32421, -1.13137, -0.78218, 0.28345,
    0.02831, -0.63220, 0.03797, -0.27077, -0.53315, -0.74721, -0.36686 },
  { 0, -0.00388, -0.14947, -0.61858, -0.46991, -0.09744, -0.16557, -0.02695,
    -0.00005, -0.11462, -1.32421, -0.42674, -0.21916, 0.00767, -0.00353,
    -0.00740, -0.38423, 0.35302, 0.10840, -0.38933, -0.66223, -0.13601 },
  { 0, 0.77003, -0.29202, -0.05843, 0.18622, -0.12599, -0.03368, 0.82409,
    -0.25741, -0.61623, -1.13137, -0.21916, -0.80244, 0.52480, 0.30337,
    0.39009, -0.25506, 0.35288, 0.12495, -0.81377, -0.00679, -0.04408 },
  { 0, 1.30064, 0.11230, 0.12790, 0.07881, -0.30732, -0.48727, -0.67014,
    -0.21340, -0.76410, -0.78218, 0.00767, 0.52480, 0.52387, 0.35068,
    0.28575, 0.65819, 0.81273, 0.51881, 0.62563, 0.12194, 0.24014 },
  { 0, 0.84844, 0.52572, 0.18390, -0.30097, -0.04280, 0.02872, -0.59550,
    -0.84731, 0.10901, 0.28345, -0.00353, 0.30337, 0.35068, 0.33437,
    0.49797, 0.38096, 0.63767, 0.80551, 0.65901, -0.03039, 0.28365 },
  { 0, 1.01742, -0.02500, 0.52903, -0.07966, -0.26481, -0.44487, -0.91634,
    -0.21102, -0.23245, 0.02831, -0.00740, 0.39009, 0.28575, 0.49797,
    0.62132, 0.76883, 0.98667, 0.76624, 0.45237, 0.03043, 0.27714 },
  { 0, 0.98098, -0.03100, 0.12708, -0.05771, 0.15324, -0.25811, -0.54654,
    -0.27646, -0.08304, -0.63220, -0.38423, -0.25506, 0.65819, 0.38096,
    0.76883, 0.95593, 1.35185, 1.21975, 0.76895, 0.16895, 0.39805 },
  { 0, 0.98514, -0.32532, 0.75063, -0.11482, 0.34334, -0.65958, -0.09861,
    -0.48624, -0.14247, 0.03797, 0.35302, 0.35288, 0.81273, 0.63767,
    0.98667, 1.35185, 1.41817, 1.31369, 0.78827, 0.26135, 0.37598 },
  { 0, 0.80402, 0.01342, 0.50448, -0.10353, 0.06346, -0.19519, -0.53238,
    -0.32629, 0.16292, -0.27077, 0.10840, 0.12495, 0.51881, 0.80551,
    0.76624, 1.21975, 1.31369, 0.96850, 0.65818, 0.18145, 0.19058 },
  { 0, 0.82301, -0.17443, -0.07242, -0.10074, -0.24440, 0.03315, -0.35171,
    -0.41980, -0.06171, -0.53315, -0.38933, -0.81377, 0.62563, 0.65901,
    0.45237, 0.76895, 0.78827, 0.65818, 0.55097, 0.01824, 0.24084 },
  { 0, -0.61457, -0.26906, -0.42415, -0.27850, -0.14987, -0.38975, -0.92526,
    -0.74050, 0.06780, -0.74721, -0.66223, -0.00679, 0.12194, -0.03039,
    0.03043, 0.16895, 0.26135, 0.18145, 0.01824, -0.56736, -0.12886 },
  { 0, 0.62654, -0.18457, 0.16152, -0.16526, 0.01830, -0.18263, -0.36073,
    -0.46893, -0.16455, -0.36686, -0.13601, -0.04408, 0.24014, 0.28365,
    0.27714, 0.39805, 0.37598, 0.19058, 0.24084, -0.12886, 0.00000 }
 },
 { /** d = 3 (>6-7  Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, -0.88087, 0.19871, 0.32431, 0.28634, 0.16629, -0.49946, -0.51280,
    -0.18287, 0.52140, -0.25726, -0.10880, 0.39881, 1.16706, 0.20495,
    1.02479, 0.60925, 0.78477, 0.80609, 0.78224, 0.30860, 0.49694 },
  { 0, 0.19871, 0.12139, 0.07123, 0.02797, -0.11498, -0.12628, -0.15229,
    -0.55603, -0.10740, -0.15851, -0.09247, -0.02645, 0.05535, 0.14438,
    -0.08612, 0.03308, -0.06094, -0.07884, 0.01470, 0.18713, -0.19651 },
  { 0, 0.32431, 0.07123, -0.18969, -0.04999, -0.09484, -0.28569, -0.43563,
    -0.48608, -0.28214, -0.37756, -0.22206, -0.16237, 0.47672, 0.35473,
    0.57563, 0.25921, 0.16066, 0.45667, 0.31860, -0.12449, 0.14855 },
  { 0, 0.28634, 0.02797, -0.04999, -0.11096, -0.12856, 0.14202, -0.25873,
    -0.60729, -0.29631, -0.72864, -0.44623, 0.19628, -0.33227, -0.08181,
    0.10219, -0.41096, -0.40765, -0.35766, 0.08990, -0.22300, -0.18084 },
  { 0, 0.16629, -0.11498, -0.09484, -0.12856, 0.06030, -0.19299, -0.35468,
    -0.52282, -0.31333, -0.71201, -0.21189, 0.19357, -0.38400, 0.18946,
    -0.04973, 0.08478, 0.21071, 0.14211, -0.26224, -0.13784, 0.01994 },
  { 0, -0.49946, -0.12628, -0.28569, 0.14202, -0.19299, -0.74195, -0.13201,
    -0.31532, -0.20444, -0.64752, -0.61659, 0.10849, 0.10598, 0.15718,
    -0.30713, -0.47021, -0.57868, -0.47396, 0.21873, -0.21731, -0.34166 },
  { 0, -0.51280, -0.15229, -0.43563, -0.25873, -0.35468, -0.13201, -0.54281,
    -0.49870, -0.27312, -0.09797, 0.19732, -0.04207, 0.09776, 0.05102,
    -0.19669, -0.45525, -0.29773, -0.49857, -0.46490, -0.40088, -0.50426 },
  { 0, -0.18287, -0.55603, -0.48608, -0.60729, -0.52282, -0.31532, -0.49870,
    -0.26668, -0.67452, -0.05099, 0.11661, 0.31226, -0.25353, -0.29858,
    -0.43464, -0.76922, -0.55943, -0.37905, -0.20016, -0.06362, -0.52830 },
  { 0, 0.52140, -0.10740, -0.28214, -0.29631, -0.31333, -0.20444, -0.27312,
    -0.67452, -0.79573, -0.90049, -0.29367, 0.11463, -0.19737, 0.20765,
    -0.19762, -0.19465, -0.04693, -0.02408, -0.44754, -0.34572, -0.20230 },
  { 0, -0.25726, -0.15851, -0.37756, -0.72864, -0.71201, -0.64752, -0.09797,
    -0.05099, -0.90049, -1.21749, -1.16863, -0.76454, -0.15604, -0.21423,
    -0.14375, -0.29862, -0.27267, -0.44045, -0.01517, -0.22159, -0.34787 },
  { 0, -0.10880, -0.09247, -0.22206, -0.44623, -0.21189, -0.61659, 0.19732,
    0.11661, -0.29367, -1.16863, -0.49036, -0.34853, -0.13228, 0.28463,
    0.33441, -0.34501, 0.07686, 0.02611, 0.72561, 0.00056, -0.12845 },
  { 0, 0.39881, -0.02645, -0.16237, 0.19628, 0.19357, 0.10849, -0.04207,
    0.31226, 0.11463, -0.76454, -0.34853, -0.73070, 0.99080, 0.16668,
    0.27784, 0.11151, -0.14209, 0.30266, -0.07312, 0.03908, -0.01523 },
  { 0, 1.16706, 0.05535, 0.47672, -0.33227, -0.38400, 0.10598, 0.09776,
    -0.25353, -0.19737, -0.15604, -0.13228, 0.99080, -0.24963, 0.63446,
    0.80179, 0.57026, 0.26520, 0.80660, 0.61752, 0.20162, 0.20596 },
  { 0, 0.20495, 0.14438, 0.35473, -0.08181, 0.18946, 0.15718, 0.05102,
    -0.29858, 0.20765, -0.21423, 0.28463, 0.16668, 0.63446, 0.20322,
    0.63889, 0.47944, 0.48706, 0.42746, 0.68973, 0.05499, 0.21698 },
  { 0, 1.02479, -0.08612, 0.57563, 0.10219, -0.04973, -0.30713, -0.19669,
    -0.43464, -0.19762, -0.14375, 0.33441, 0.27784, 0.80179, 0.63889,
    0.82749, 0.70563, 0.89225, 0.92437, 1.08796, -0.20461, 0.25951 },
  { 0, 0.60925, 0.03308, 0.25921, -0.41096, 0.08478, -0.47021, -0.45525,
    -0.76922, -0.19465, -0.29862, -0.34501, 0.11151, 0.57026, 0.47944,
    0.70563, 0.70731, 0.87982, 1.04122, 0.87436, -0.02192, 0.43485 },
  { 0, 0.78477, -0.06094, 0.16066, -0.40765, 0.21071, -0.57868, -0.29773,
    -0.55943, -0.04693, -0.27267, 0.07686, -0.14209, 0.26520, 0.48706,
    0.89225, 0.87982, 1.20180, 1.23062, 0.80739, 0.27823, 0.45770 },
  { 0, 0.80609, -0.07884, 0.45667, -0.35766, 0.14211, -0.47396, -0.49857,
    -0.37905, -0.02408, -0.44045, 0.02611, 0.30266, 0.80660, 0.42746,
    0.92437, 1.04122, 1.23062, 1.14751, 0.84275, -0.18120, 0.25284 },
  { 0, 0.78224, 0.01470, 0.31860, 0.08990, -0.26224, 0.21873, -0.46490,
    -0.20016, -0.44754, -0.01517, 0.72561, -0.07312, 0.61752, 0.68973,
    1.08796, 0.87436, 0.80739, 0.84275, 1.12340, 0.17719, 0.24486 },
  { 0, 0.30860, 0.18713, -0.12449, -0.22300, -0.13784, -0.21731, -0.40088,
    -0.06362, -0.34572, -0.22159, 0.00056, 0.03908, 0.20162, 0.05499,
    -0.20461, -0.02192, 0.27823, -0.18120, 0.17719, -0.25708, -0.05498 },
  { 0, 0.49694, -0.19651, 0.14855, -0.18084, 0.01994, -0.34166, -0.50426,
    -0.52830, -0.20230, -0.34787, -0.12845, -0.01523, 0.20596, 0.21698,
    0.25951, 0.43485, 0.45770, 0.25284, 0.24486, -0.05498, 0.00000 }
 },
 { /** d = 4 (>7-8  Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, 0.06905, 0.27116, 0.44091, 0.38333, 0.26561, 0.18310, -0.41523,
    0.09129, 0.02800, -0.07770, 0.15273, 0.02639, 0.92172, 0.25935,
    0.67705, 0.34180, 0.81881, 0.72415, 0.34407, -0.08001, 0.42323 },
  { 0, 0.27116, 0.14813, -0.06701, -0.00933, 0.10506, -0.17887, -0.13066,
    -0.50547, -0.12770, -0.19714, -0.08333, -0.23787, -0.13552, 0.15534,
    -0.07026, 0.02425, 0.06843, -0.04645, 0.10561, -0.25543, -0.07761 },
  { 0, 0.44091, -0.06701, -0.14957, -0.08958, -0.01006, -0.12446, -0.12991,
    -0.19144, -0.08068, -0.23735, -0.30973, 0.19716, 0.46465, 0.24016,
    0.45155, 0.23297, 0.36511, 0.16309, 0.57204, 0.03549, 0.06301 },
  { 0, 0.38333, -0.00933, -0.08958, -0.15178, -0.11733, -0.34753, -0.28754,
    -0.34711, -0.39634, -0.12950, -0.09612, 0.19837, -0.11525, 0.03637,
    0.25267, -0.25226, 0.02337, -0.10882, 0.15329, -0.10596, -0.22096 },
  { 0, 0.26561, 0.10506, -0.01006, -0.11733, -0.27005, -0.25134, -0.11697,
    -0.45140, -0.25829, -0.33411, -0.31979, 0.06453, -0.04398, 0.30313,
    0.37024, 0.00051, 0.08692, 0.06721, 0.08148, -0.21197, -0.13425 },
  { 0, 0.18310, -0.17887, -0.12446, -0.34753, -0.25134, -0.00384, -0.26072,
    -0.33409, -0.15854, -0.45907, 0.03846, 0.09842, -0.02791, -0.05969,
    -0.12795, -0.23217, -0.12371, -0.39878, -0.09078, -0.24109, -0.33978 },
  { 0, -0.41523, -0.13066, -0.12991, -0.28754, -0.11697, -0.26072, -0.48162,
    -0.33984, -0.25833, -0.17498, -0.09075, 0.12758, -0.26973, 0.28214,
    -0.11110, -0.21660, -0.41357, -0.40204, -0.10155, -0.27134, -0.33178 },
  { 0, 0.09129, -0.50547, -0.19144, -0.34711, -0.45140, -0.33409, -0.33984,
    -1.08110, -0.26818, -0.22893, -0.28900, 0.22270, 0.14781, -0.14214,
    0.02302, -0.26629, -0.19098, -0.32632, -0.65789, -0.09565, -0.48480 },
  { 0, 0.02800, -0.12770, -0.08068, -0.39634, -0.25829, -0.15854, -0.25833,
    -0.26818, -0.39494, -0.27433, -0.26702, -0.14959, 0.28190, 0.12889,
    0.10507, -0.07537, -0.15985, -0.30132, 0.05958, -0.52797, -0.26634 },
  { 0, -0.07770, -0.19714, -0.23735, -0.12950, -0.33411, -0.45907, -0.17498,
    -0.22893, -0.27433, -0.50429, -0.45114, -0.55709, -0.32239, -0.26989,
    -0.09592, -0.21919, -0.38553, -0.51956, -0.21635, -0.38763, -0.40539 },
  { 0, 0.15273, -0.08333, -0.30973, -0.09612, -0.31979, 0.03846, -0.09075,
    -0.28900, -0.26702, -0.45114, -0.47057, 0.23076, 0.39395, 0.04606,
    0.25786, 0.02430, 0.18630, -0.25599, -0.12954, -0.32533, -0.19468 },
  { 0, 0.02639, -0.23787, 0.19716, 0.19837, 0.06453, 0.09842, 0.12758,
    0.22270, -0.14959, -0.55709, 0.23076, -0.36000, 0.05632, 0.30822,
    0.79996, 0.02481, 0.09076, 0.02015, 0.46406, 0.22704, 0.15862 },
  { 0, 0.92172, -0.13552, 0.46465, -0.11525, -0.04398, -0.02791, -0.26973,
    0.14781, 0.28190, -0.32239, 0.39395, 0.05632, -0.28256, 0.53329,
    0.84096, 0.42625, 0.57852, 0.47466, 0.75228, -0.09185, 0.31130 },
  { 0, 0.25935, 0.15534, 0.24016, 0.03637, 0.30313, -0.05969, 0.28214,
    -0.14214, 0.12889, -0.26989, 0.04606, 0.30822, 0.53329, 0.74687,
    0.44517, 0.43595, 0.56807, 0.47767, 0.71681, 0.09404, 0.26510 },
  { 0, 0.67705, -0.07026, 0.45155, 0.25267, 0.37024, -0.12795, -0.11110,
    0.02302, 0.10507, -0.09592, 0.25786, 0.79996, 0.84096, 0.44517,
    0.98843, 0.62631, 0.94326, 0.75812, 0.91295, 0.11757, 0.31464 },
  { 0, 0.34180, 0.02425, 0.23297, -0.25226, 0.00051, -0.23217, -0.21660,
    -0.26629, -0.07537, -0.21919, 0.02430, 0.02481, 0.42625, 0.43595,
    0.62631, 0.41884, 0.61954, 0.49813, 0.43901, -0.15674, 0.36915 },
  { 0, 0.81881, 0.06843, 0.36511, 0.02337, 0.08692, -0.12371, -0.41357,
    -0.19098, -0.15985, -0.38553, 0.18630, 0.09076, 0.57852, 0.56807,
    0.94326, 0.61954, 0.75132, 0.74708, 0.81354, 0.00247, 0.43823 },
  { 0, 0.72415, -0.04645, 0.16309, -0.10882, 0.06721, -0.39878, -0.40204,
    -0.32632, -0.30132, -0.51956, -0.25599, 0.02015, 0.47466, 0.47767,
    0.75812, 0.49813, 0.74708, 0.82835, 0.56382, 0.07518, 0.38589 },
  { 0, 0.34407, 0.10561, 0.57204, 0.15329, 0.08148, -0.09078, -0.10155,
    -0.65789, 0.05958, -0.21635, -0.12954, 0.46406, 0.75228, 0.71681,
    0.91295, 0.43901, 0.81354, 0.56382, 0.01243, 0.37332, 0.27554 },
  { 0, -0.08001, -0.25543, 0.03549, -0.10596, -0.21197, -0.24109, -0.27134,
    -0.09565, -0.52797, -0.38763, -0.32533, 0.22704, -0.09185, 0.09404,
    0.11757, -0.15674, 0.00247, 0.07518, 0.37332, -0.33073, -0.04591 },
  { 0, 0.42323, -0.07761, 0.06301, -0.22096, -0.13425, -0.33978, -0.33178,
    -0.48480, -0.26634, -0.40539, -0.19468, 0.15862, 0.31130, 0.26510,
    0.31464, 0.36915, 0.43823, 0.38589, 0.27554, -0.04591, 0.00000 }
 },
 { /** d = 5 (>8-9  Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, 0.34653, 0.24006, 0.40682, 0.32468, 0.63680, 0.15522, 0.10429,
    -0.23297, 0.21796, 0.14294, 0.53646, 0.87494, 0.86852, 0.81882,
    0.69375, 0.62425, 0.75099, 0.59154, 0.87435, 0.10431, 0.34882 },
  { 0, 0.24006, -0.04219, 0.05311, -0.20502, 0.00159, -0.15033, -0.16829,
    -0.26778, -0.21189, -0.44138, -0.05730, 0.11044, 0.01312, -0.08837,
    0.19610, -0.03011, 0.07092, -0.06004, 0.11555, -0.17116, -0.18614 },
  { 0, 0.40682, 0.05311, 0.12844, 0.02560, 0.06336, -0.09281, -0.17631,
    -0.25546, -0.30752, -0.19081, -0.05615, -0.00903, 0.39667, 0.28238,
    0.29147, 0.31970, 0.40202, 0.22353, 0.46974, -0.00341, 0.06597 },
  { 0, 0.32468, -0.20502, 0.02560, -0.20759, -0.13087, -0.22307, -0.26685,
    -0.35833, -0.20475, -0.44963, -0.19058, 0.00197, 0.09642, 0.10263,
    -0.24617, 0.17707, 0.10515, 0.07564, 0.16214, -0.39141, -0.18109 },
  { 0, 0.63680, 0.00159, 0.06336, -0.13087, -0.27602, -0.20367, -0.16505,
    -0.33073, -0.21323, -0.29271, -0.18072, 0.08882, 0.23739, 0.00035,
    0.23003, 0.30544, 0.25240, 0.11728, 0.01724, -0.25500, -0.12106 },
  { 0, 0.15522, -0.15033, -0.09281, -0.22307, -0.20367, -0.49221, -0.11018,
    -0.24115, -0.50979, -0.51884, -0.41540, -0.15103, -0.14085, -0.14603,
    -0.15541, -0.25524, -0.08598, -0.15595, -0.02123, -0.33416, -0.31358 },
  { 0, 0.10429, -0.16829, -0.17631, -0.26685, -0.16505, -0.11018, -0.40585,
    -0.67777, -0.34107, -0.21188, 0.01127, -0.02067, 0.19430, 0.17340,
    -0.21898, -0.08010, -0.25208, -0.23360, -0.46391, 0.00192, -0.30067 },
  { 0, -0.23297, -0.26778, -0.25546, -0.35833, -0.33073, -0.24115, -0.67777,
    -0.38942, -0.31305, -0.02769, -0.21648, -0.00845, 0.01543, -0.20609,
    -0.23048, -0.05673, 0.01487, -0.12506, -0.16885, -0.15484, -0.34668 },
  { 0, 0.21796, -0.21189, -0.30752, -0.20475, -0.21323, -0.50979, -0.34107,
    -0.31305, -0.18322, -0.52513, 0.01876, -0.10901, -0.06508, -0.05573,
    -0.16734, 0.05117, 0.01519, 0.01939, -0.27891, -0.25842, -0.16539 },
  { 0, 0.14294, -0.44138, -0.19081, -0.44963, -0.29271, -0.51884, -0.21188,
    -0.02769, -0.52513, -0.49368, -0.46261, -0.42215, -0.05321, -0.14452,
    -0.32523, 0.07588, -0.04807, -0.15866, -0.18222, -0.46886, -0.30354 },
  { 0, 0.53646, -0.05730, -0.05615, -0.19058, -0.18072, -0.41540, 0.01127,
    -0.21648, 0.01876, -0.46261, -0.31973, 0.22434, 0.12585, -0.04216,
    -0.04368, -0.14660, -0.00994, 0.08390, 0.10337, 0.38380, -0.16185 },
  { 0, 0.87494, 0.11044, -0.00903, 0.00197, 0.08882, -0.15103, -0.02067,
    -0.00845, -0.10901, -0.42215, 0.22434, -0.00665, 0.27181, 0.18900,
    0.45944, 0.08062, 0.04968, 0.10936, 0.28794, -0.55937, 0.06143 },
  { 0, 0.86852, 0.01312, 0.39667, 0.09642, 0.23739, -0.14085, 0.19430,
    0.01543, -0.06508, -0.05321, 0.12585, 0.27181, 0.17581, 0.33507,
    0.50419, 0.44370, 0.50955, 0.56316, 0.80051, -0.09756, 0.31155 },
  { 0, 0.81882, -0.08837, 0.28238, 0.10263, 0.00035, -0.14603, 0.17340,
    -0.20609, -0.05573, -0.14452, -0.04216, 0.18900, 0.33507, 0.32358,
    0.45774, 0.53173, 0.46800, 0.50765, 0.46958, 0.03264, 0.21059 },
  { 0, 0.69375, 0.19610, 0.29147, -0.24617, 0.23003, -0.15541, -0.21898,
    -0.23048, -0.16734, -0.32523, -0.04368, 0.45944, 0.50419, 0.45774,
    0.46537, 0.59713, 0.71506, 0.60640, 0.66106, 0.16343, 0.32714 },
  { 0, 0.62425, -0.03011, 0.31970, 0.17707, 0.30544, -0.25524, -0.08010,
    -0.05673, 0.05117, 0.07588, -0.14660, 0.08062, 0.44370, 0.53173,
    0.59713, 0.77534, 0.55370, 0.45667, 0.44931, -0.15000, 0.28729 },
  { 0, 0.75099, 0.07092, 0.40202, 0.10515, 0.25240, -0.08598, -0.25208,
    0.01487, 0.01519, -0.04807, -0.00994, 0.04968, 0.50955, 0.46800,
    0.71506, 0.55370, 0.24224, 0.50072, 0.77423, -0.05450, 0.43027 },
  { 0, 0.59154, -0.06004, 0.22353, 0.07564, 0.11728, -0.15595, -0.23360,
    -0.12506, 0.01939, -0.15866, 0.08390, 0.10936, 0.56316, 0.50765,
    0.60640, 0.45667, 0.50072, 0.51671, 0.47875, 0.11150, 0.37053 },
  { 0, 0.87435, 0.11555, 0.46974, 0.16214, 0.01724, -0.02123, -0.46391,
    -0.16885, -0.27891, -0.18222, 0.10337, 0.28794, 0.80051, 0.46958,
    0.66106, 0.44931, 0.77423, 0.47875, 0.11443, 0.24757, 0.29515 },
  { 0, 0.10431, -0.17116, -0.00341, -0.39141, -0.25500, -0.33416, 0.00192,
    -0.15484, -0.25842, -0.46886, 0.38380, -0.55937, -0.09756, 0.03264,
    0.16343, -0.15000, -0.05450, 0.11150, 0.24757, -0.56605, -0.16243 },
  { 0, 0.34882, -0.18614, 0.06597, -0.18109, -0.12106, -0.31358, -0.30067,
    -0.34668, -0.16539, -0.30354, -0.16185, 0.06143, 0.31155, 0.21059,
    0.32714, 0.28729, 0.43027, 0.37053, 0.29515, -0.16243, 0.00000 }
 },
 { /** d = 6 (>9-10 Angstroms) **/
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0, -0.77128, 0.29522, 0.26289, 0.55478, 0.24757, 0.15165, 0.08760,
    0.00861, -0.17169, 0.04083, 0.26476, 0.72324, 0.31913, 0.59326,
    0.66573, 0.59989, 0.82772, 0.55947, 0.35244, 0.20370, 0.27228 },
  { 0, 0.29522, -0.10200, -0.01814, -0.19708, 0.02681, -0.35274, -0.25536,
    -0.23687, -0.16559, -0.37730, -0.21934, -0.11319, -0.00006, 0.08687,
    0.06850, 0.07439, -0.02234, 0.01315, 0.09473, -0.25924, -0.19484 },
  { 0, 0.26289, -0.01814, 0.12760, 0.04627, -0.04286, 0.05045, -0.02157,
    -0.26321, 0.01504, -0.20877, -0.07270, -0.04355, 0.17023, 0.33443,
    0.27726, 0.34135, 0.30655, 0.29403, 0.32724, -0.04607, 0.05880 },
  { 0, 0.55478, -0.19708, 0.04627, -0.15304, -0.05827, -0.27013, -0.26294,
    -0.23001, -0.28350, -0.38715, -0.27752, -0.00501, 0.18359, 0.11551,
    0.01641, 0.12515, 0.20041, 0.07986, 0.00966, -0.20587, -0.18385 },
  { 0, 0.24757, 0.02681, -0.04286, -0.05827, 0.02264, -0.32860, -0.28237,
    -0.19373, -0.10003, -0.36917, -0.12326, -0.05835, 0.22944, 0.04720,
    0.14300, 0.19163, 0.20943, 0.14945, 0.34625, -0.21862, -0.06928 },
  { 0, 0.15165, -0.35274, 0.05045, -0.27013, -0.32860, -0.14911, -0.31212,
    -0.26758, -0.16974, -0.30909, -0.18012, -0.18939, -0.28338, -0.09773,
    0.00928, -0.06441, 0.01560, -0.06163, -0.14235, -0.07909, -0.21923 },
  { 0, 0.08760, -0.25536, -0.02157, -0.26294, -0.28237, -0.31212, -0.46333,
    -0.27657, -0.33935, -0.51175, -0.43992, -0.08198, -0.17019, 0.16183,
    0.01846, -0.11980, -0.09520, -0.15216, -0.08229, -0.30725, -0.22492 },
  { 0, 0.00861, -0.23687, -0.26321, -0.23001, -0.19373, -0.26758, -0.27657,
    -0.49965, -0.29037, -0.35285, 0.09814, -0.14929, -0.23556, 0.03282,
    -0.19270, -0.13205, -0.07489, -0.10469, -0.28014, -0.34506, -0.24870 },
  { 0, -0.17169, -0.16559, 0.01504, -0.28350, -0.10003, -0.16974, -0.33935,
    -0.29037, -0.43027, -0.31702, 0.00403, -0.12338, 0.32676, -0.07592,
    0.07743, 0.08907, 0.06491, 0.11769, -0.23889, -0.12390, -0.11359 },
  { 0, 0.04083, -0.37730, -0.20877, -0.38715, -0.36917, -0.30909, -0.51175,
    -0.35285, -0.31702, -0.24303, -0.55887, -0.14747, 0.08013, -0.12874,
    -0.15942, -0.06004, -0.07263, -0.04884, -0.18995, -0.32115, -0.25567 },
  { 0, 0.26476, -0.21934, -0.07270, -0.27752, -0.12326, -0.18012, -0.43992,
    0.09814, 0.00403, -0.55887, -0.15449, -0.17724, 0.27981, 0.01233,
    0.15983, 0.06518, 0.05475, 0.04036, -0.01185, -0.26553, -0.08468 },
  { 0, 0.72324, -0.11319, -0.04355, -0.00501, -0.05835, -0.18939, -0.08198,
    -0.14929, -0.12338, -0.14747, -0.17724, 0.20026, 0.15890, 0.15272,
    0.04116, 0.32787, 0.60854, 0.00214, 0.56485, 0.11511, 0.06929 },
  { 0, 0.31913, -0.00006, 0.17023, 0.18359, 0.22944, -0.28338, -0.17019,
    -0.23556, 0.32676, 0.08013, 0.27981, 0.15890, -0.16617, 0.30482,
    0.40665, 0.45367, 0.65623, 0.34976, 0.22832, 0.01480, 0.23735 },
  { 0, 0.59326, 0.08687, 0.33443, 0.11551, 0.04720, -0.09773, 0.16183,
    0.03282, -0.07592, -0.12874, 0.01233, 0.15272, 0.30482, 0.12999,
    0.40185, 0.46081, 0.40650, 0.36985, 0.51944, 0.13712, 0.21988 },
  { 0, 0.66573, 0.06850, 0.27726, 0.01641, 0.14300, 0.00928, 0.01846,
    -0.19270, 0.07743, -0.15942, 0.15983, 0.04116, 0.40665, 0.40185,
    0.55119, 0.49708, 0.53926, 0.60022, 0.53304, -0.10987, 0.33164 },
  { 0, 0.59989, 0.07439, 0.34135, 0.12515, 0.19163, -0.06441, -0.11980,
    -0.13205, 0.08907, -0.06004, 0.06518, 0.32787, 0.45367, 0.46081,
    0.49708, 0.36406, 0.54130, 0.42021, 0.33942, 0.00719, 0.25631 },
  { 0, 0.82772, -0.02234, 0.30655, 0.20041, 0.20943, 0.01560, -0.09520,
    -0.07489, 0.06491, -0.07263, 0.05475, 0.60854, 0.65623, 0.40650,
    0.53926, 0.54130, 0.43951, 0.48297, 0.68124, -0.04822, 0.36875 },
  { 0, 0.55947, 0.01315, 0.29403, 0.07986, 0.14945, -0.06163, -0.15216,
    -0.10469, 0.11769, -0.04884, 0.04036, 0.00214, 0.34976, 0.36985,
    0.60022, 0.42021, 0.48297, 0.37136, 0.47346, 0.03428, 0.34401 },
  { 0, 0.35244, 0.09473, 0.32724, 0.00966, 0.34625, -0.14235, -0.08229,
    -0.28014, -0.23889, -0.18995, -0.01185, 0.56485, 0.22832, 0.51944,
    0.53304, 0.33942, 0.68124, 0.47346, 0.05342, 0.02663, 0.29816 },
  { 0, 0.20370, -0.25924, -0.04607, -0.20587, -0.21862, -0.07909, -0.30725,
    -0.34506, -0.12390, -0.32115, -0.26553, 0.11511, 0.01480, 0.13712,
    -0.10987, 0.00719, -0.04822, 0.03428, 0.02663, -0.11295, -0.17515 },
  { 0, 0.27228, -0.19484, 0.05880, -0.18385, -0.06928, -0.21923, -0.22492,
    -0.24870, -0.11359, -0.25567, -0.08468, 0.06929, 0.23735, 0.21988,
    0.33164, 0.25631, 0.36875, 0.34401, 0.29816, -0.17515, 0.00000 }
 } };


#endif
