/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (BLOSUM62H)
#define BLOSUM62H

static float blosum62[21][21] = {
/*    C           G           A           S           T       
      N           D           E           Q           K       
      R           H           W           Y           F       
      V           I           L           M           P       */
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,   4.2911,    -1.2502,    -0.2043,    -0.4375,    -0.4333, 
   -1.3299,    -1.7300,    -1.8062,    -1.4509,    -1.5182, 
   -1.6946,    -1.4939,    -1.1521,    -1.2036,    -1.1877, 
   -0.4038,    -0.6138,    -0.6387,    -0.7099,    -1.3976, },
{0,   -1.2502,    2.7816,    0.0798,    -0.1462,    -0.7877, 
   -0.2114,    -0.6568,    -1.0551,    -0.8926,    -0.7640, 
   -1.1521,    -1.0204,    -1.2457,    -1.5199,    -1.5537, 
   -1.5694,    -1.8624,    -1.8135,    -1.3383,    -1.0668, },
{0,   -0.2043,    0.0798,    1.9646,    0.5579,    -0.0227, 
   -0.7654,    -0.8767,    -0.4319,    -0.4020,    -0.3670, 
   -0.7068,    -0.8126,    -1.2634,    -0.8820,    -1.1050, 
   -0.0947,    -0.6609,    -0.7323,    -0.4676,    -0.4071, },
{0,   -0.4375,    -0.1462,    0.5579,    1.9422,    0.6906, 
   0.3005,    -0.1305,    -0.0735,    -0.0506,    -0.1017, 
   -0.3824,    -0.4408,    -1.3759,    -0.8429,    -1.1845, 
   -0.8231,    -1.1741,    -1.2213,    -0.7404,    -0.4045, },
{0,   -0.4333,    -0.7877,    -0.0227,    0.6906,    2.2727, 
   -0.0230,    -0.5254,    -0.4316,    -0.3377,    -0.3348, 
   -0.5612,    -0.8429,    -1.2145,    -0.8030,    -1.0538, 
   -0.0278,    -0.3588,    -0.5987,    -0.3331,    -0.5376, },
{0,   -1.3299,    -0.2114,    -0.7654,    0.3005,    -0.0230, 
   2.8266,    0.6358,    -0.1340,    0.0008,    -0.0895, 
   -0.2199,    0.2892,    -1.8480,    -1.0409,    -1.4970, 
   -1.4382,    -1.6085,    -1.6895,    -1.0754,    -1.0002, },
{0,   -1.7300,    -0.6568,    -0.8767,    -0.1305,    -0.5254, 
   0.6358,    2.8871,    0.7552,    -0.1567,    -0.3509, 
   -0.8029,    -0.5595,    -2.1072,    -1.5325,    -1.7419, 
   -1.5713,    -1.5606,    -1.8028,    -1.5293,    -0.7401, },
{0,   -1.8062,    -1.0551,    -0.4319,    -0.0735,    -0.4316, 
   -0.1340,    0.7552,    2.4514,    0.9273,    0.3877, 
   -0.0577,    -0.0588,    -1.4177,    -1.0102,    -1.5962, 
   -1.2211,    -1.5972,    -1.4232,    -0.9990,    -0.5581, },
{0,   -1.4509,    -0.8926,    -0.4020,    -0.0506,    -0.3377, 
   0.0008,    -0.1567,    0.9273,    2.6426,    0.6363, 
   0.4914,    0.2240,    -0.9732,    -0.7105,    -1.5822, 
   -1.0992,    -1.3848,    -1.0670,    -0.2105,    -0.6410, },
{0,   -1.5182,    -0.7640,    -0.3670,    -0.1017,    -0.3348, 
   -0.0895,    -0.3509,    0.3877,    0.6363,    2.2523, 
   1.0544,    -0.3605,    -1.4782,    -0.9100,    -1.5393, 
   -1.1312,    -1.3351,    -1.2234,    -0.6774,    -0.5068, },
{0,   -1.6946,    -1.1521,    -0.7068,    -0.3824,    -0.5612, 
   -0.2199,    -0.8029,    -0.0577,    0.4914,    1.0544, 
   2.7367,    -0.1249,    -1.3397,    -0.8469,    -1.3932, 
   -1.2513,    -1.4951,    -1.0773,    -0.6836,    -1.0543, },
{0,   -1.4939,    -1.0204,    -0.8126,    -0.4408,    -0.8429, 
   0.2892,    -0.5595,    -0.0588,    0.2240,    -0.3605, 
   -0.1249,    3.7555,    -1.1711,    0.8463,    -0.6171, 
   -1.5587,    -1.6158,    -1.3934,    -0.7756,    -1.0805, },
{0,   -1.1521,    -1.2457,    -1.2634,    -1.3759,    -1.2145, 
   -1.8480,    -2.1072,    -1.4177,    -0.9732,    -1.4782, 
   -1.3397,    -1.1711,    5.2520,    1.0771,    0.4588, 
   -1.4171,    -1.2903,    -0.8159,    -0.7124,    -1.8271, },
{0,   -1.2036,    -1.5199,    -0.8820,    -0.8429,    -0.8030, 
   -1.0409,    -1.5325,    -1.0102,    -0.7105,    -0.9100, 
   -0.8469,    0.8463,    1.0771,    3.2975,    1.4696, 
   -0.6038,    -0.6657,    -0.5310,    -0.4974,    -1.4599, },
{0,   -1.1877,    -1.5537,    -1.1050,    -1.1845,    -1.0538, 
   -1.4970,    -1.7419,    -1.5962,    -1.5822,    -1.5393, 
   -1.3932,    -0.6171,    0.4588,    1.4696,    3.0230, 
   -0.4245,    -0.0804,    0.2074,    0.0063,    -1.7986, },
{0,   -0.4038,    -1.5694,    -0.0947,    -0.8231,    -0.0278, 
   -1.4382,    -1.5713,    -1.2211,    -1.0992,    -1.1312, 
   -1.2513,    -1.5587,    -1.4171,    -0.6038,    -0.4245, 
   1.8845,    1.2735,    0.3942,    0.3436,    -1.1744, },
{0,   -0.6138,    -1.8624,    -0.6609,    -1.1741,    -0.3588, 
   -1.6085,    -1.5606,    -1.5972,    -1.3848,    -1.3351, 
   -1.4951,    -1.6158,    -1.2903,    -0.6657,    -0.0804, 
   1.2735,    1.9993,    0.7608,    0.5634,    -1.3783, },
{0,   -0.6387,    -1.8135,    -0.7323,    -1.2213,    -0.5987, 
   -1.6895,    -1.8028,    -1.4232,    -1.0670,    -1.2234, 
   -1.0773,    -1.3934,    -0.8159,    -0.5310,    0.2074, 
   0.3942,    0.7608,    1.9247,    0.9959,    -1.4300, },
{0,   -0.7099,    -1.3383,    -0.4676,    -0.7404,    -0.3331, 
   -1.0754,    -1.5293,    -0.9990,    -0.2105,    -0.6774, 
   -0.6836,    -0.7756,    -0.7124,    -0.4974,    0.0063, 
   0.3436,    0.5634,    0.9959,    2.6963,    -1.2382, },
{0,   -1.3976,    -1.0668,    -0.4071,    -0.4045,    -0.5376, 
   -1.0002,    -0.7401,    -0.5581,    -0.6410,    -0.5068, 
   -1.0543,    -1.0805,    -1.8271,    -1.4599,    -1.7986, 
   -1.1744,    -1.3783,    -1.4300,    -1.2382,    3.6823, }
};

#if 1
static float blsm62_ins_emit_nats[21] = { 0.0,	// X
//    C       G       A       S       T  
-0.3466, 0.2766,-0.1033, 0.2488, 0.0811,
//    N       D       E       Q       K 
 0.1906, 0.1615, 0.0298, 0.0312, 0.1456,
//    R       H       W       Y       F
 0.0665, 0.0735,-0.2038,-0.1726,-0.2641,
//    V       I       L       M       P
-0.2558,-0.4339,-0.3230,-0.4991, 0.2731};

static float blsm62norm_kyte_doolittle[21] = {0.50, // X
// C    G    A    S    T    N    D    E    Q    K 
 0.78,0.46,0.70,0.40,0.42,0.11,0.11,0.11,0.11,0.07,
// R    H    W    Y    F    V    I    L    M    P
 0.00,0.14,0.40,0.36,0.80,0.97,1.00,0.91,0.71,0.32};

#endif

static float blsm62kyte_doolittle[21] = { 4.5,  /*  X
   C    G    A    S    T    N    D    E    Q    K */
  7.0, 4.1, 6.3, 3.6, 3.8, 1.0, 1.0, 1.0, 1.0, 0.6, 
/* R    H    W    Y    F    V    I    L    M    P */
  0.0, 1.3, 3.6, 3.2, 7.2, 8.7, 9.0, 8.2, 6.4, 2.9};

#if 0
static double blosum62freq[21] = {  0.0, /*  X
    C     G     A     S     T     N     D     E     Q     K */
0.025,0.074,0.074,0.057,0.051,0.045,0.054,0.054,0.034,0.058,
/*  R     H     W     Y     F     V     I     L     M     P */
0.052,0.026,0.013,0.032,0.047,0.073,0.068,0.099,0.025,0.039 };
#else
static double blosum62freq[21] = {  0.0, /*  X
    C      G        A       S       T       N       D       E       Q      K */
0.02469,0.07415,0.07422,0.05723,0.05089,0.04465,0.05363,0.05431,0.03426,0.05816,
/*  R       H       W       Y       F       V       I       L       M      P */
0.05161,0.02621,0.01303,0.03228,0.04742,0.07292,0.06792,0.09891,0.02499,0.03854};
#endif

static float blosum62L[21][21] = {
/*    C           G           A           S           T       
      N           D           E           Q           K       
      R           H           W           Y           F       
      V           I           L           M           P       */
{1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.,1.},
{1.,   19.5772,    0.4204,    0.8680,    0.7384,    0.7406, 
   0.3978,    0.3015,    0.2859,    0.3658,    0.3491, 
   0.3089,    0.3551,    0.4500,    0.4342,    0.4390, 
   0.7559,    0.6535,    0.6423,    0.6114,    0.3796, },
{1.,   0.4204,    6.8761,    1.0569,    0.9036,    0.5793, 
   0.8637,    0.6343,    0.4813,    0.5386,    0.5889, 
   0.4500,    0.4930,    0.4217,    0.3487,    0.3406, 
   0.3369,    0.2750,    0.2845,    0.3955,    0.4774, },
{1.,   0.8680,    1.0569,    3.9030,    1.4721,    0.9844, 
   0.5883,    0.5446,    0.7413,    0.7568,    0.7754, 
   0.6127,    0.5694,    0.4166,    0.5426,    0.4649, 
   0.9365,    0.6325,    0.6019,    0.7232,    0.7541, },
{1.,   0.7384,    0.9036,    1.4721,    3.8429,    1.6140, 
   1.2316,    0.9135,    0.9503,    0.9655,    0.9319, 
   0.7672,    0.7367,    0.3853,    0.5575,    0.4400, 
   0.5652,    0.4432,    0.4289,    0.5986,    0.7555, },
{1.,   0.7406,    0.5793,    0.9844,    1.6140,    4.8323, 
   0.9842,    0.6948,    0.7414,    0.7913,    0.7929, 
   0.6777,    0.5575,    0.4309,    0.5732,    0.4817, 
   0.9809,    0.7798,    0.6603,    0.7938,    0.6889, },
{1.,   0.3978,    0.8637,    0.5883,    1.2316,    0.9842, 
   7.0940,    1.5538,    0.9113,    1.0006,    0.9398, 
   0.8586,    1.2220,    0.2778,    0.4860,    0.3543, 
   0.3690,    0.3279,    0.3100,    0.4745,    0.4999, },
{1.,   0.3015,    0.6343,    0.5446,    0.9135,    0.6948, 
   1.5538,    7.3978,    1.6879,    0.8971,    0.7841, 
   0.5732,    0.6785,    0.2321,    0.3457,    0.2990, 
   0.3365,    0.3390,    0.2866,    0.3464,    0.5987, },
{1.,   0.2859,    0.4813,    0.7413,    0.9503,    0.7414, 
   0.9113,    1.6879,    5.4695,    1.9017,    1.3083, 
   0.9608,    0.9601,    0.3743,    0.4965,    0.3307, 
   0.4290,    0.3305,    0.3729,    0.5003,    0.6792, },
{1.,   0.3658,    0.5386,    0.7568,    0.9655,    0.7913, 
   1.0006,    0.8971,    1.9017,    6.2446,    1.5543, 
   1.4058,    1.1680,    0.5094,    0.6111,    0.3340, 
   0.4668,    0.3829,    0.4773,    0.8642,    0.6413, },
{1.,   0.3491,    0.5889,    0.7754,    0.9319,    0.7929, 
   0.9398,    0.7841,    1.3083,    1.5543,    4.7644, 
   2.0769,    0.7789,    0.3589,    0.5322,    0.3441, 
   0.4565,    0.3964,    0.4283,    0.6253,    0.7038, },
{1.,   0.3089,    0.4500,    0.6127,    0.7672,    0.6777, 
   0.8586,    0.5732,    0.9608,    1.4058,    2.0769, 
   6.6654,    0.9171,    0.3951,    0.5560,    0.3807, 
   0.4201,    0.3548,    0.4739,    0.6226,    0.4815, },
{1.,   0.3551,    0.4930,    0.5694,    0.7367,    0.5575, 
   1.2220,    0.6785,    0.9601,    1.1680,    0.7789, 
   0.9171,    13.5057,    0.4441,    1.7979,    0.6520, 
   0.3395,    0.3263,    0.3807,    0.5841,    0.4729, },
{1.,   0.4500,    0.4217,    0.4166,    0.3853,    0.4309, 
   0.2778,    0.2321,    0.3743,    0.5094,    0.3589, 
   0.3951,    0.4441,    38.1074,    2.1098,    1.3744, 
   0.3745,    0.4089,    0.5681,    0.6103,    0.2818, },
{1.,   0.4342,    0.3487,    0.5426,    0.5575,    0.5732, 
   0.4860,    0.3457,    0.4965,    0.6111,    0.5322, 
   0.5560,    1.7979,    2.1098,    9.8321,    2.7695, 
   0.6580,    0.6304,    0.6921,    0.7084,    0.3635, },
{1.,   0.4390,    0.3406,    0.4649,    0.4400,    0.4817, 
   0.3543,    0.2990,    0.3307,    0.3340,    0.3441, 
   0.3807,    0.6520,    1.3744,    2.7695,    8.1286, 
   0.7451,    0.9458,    1.1546,    1.0044,    0.2875, },
{1.,   0.7559,    0.3369,    0.9365,    0.5652,    0.9809, 
   0.3690,    0.3365,    0.4290,    0.4668,    0.4565, 
   0.4201,    0.3395,    0.3745,    0.6580,    0.7451, 
   3.6922,    2.4175,    1.3142,    1.2689,    0.4431, },
{1.,   0.6535,    0.2750,    0.6325,    0.4432,    0.7798, 
   0.3279,    0.3390,    0.3305,    0.3829,    0.3964, 
   0.3548,    0.3263,    0.4089,    0.6304,    0.9458, 
   2.4175,    3.9981,    1.6944,    1.4777,    0.3847, },
{1.,   0.6423,    0.2845,    0.6019,    0.4289,    0.6603, 
   0.3100,    0.2866,    0.3729,    0.4773,    0.4283, 
   0.4739,    0.3807,    0.5681,    0.6921,    1.1546, 
   1.3142,    1.6944,    3.7966,    1.9943,    0.3711, },
{1.,   0.6114,    0.3955,    0.7232,    0.5986,    0.7938, 
   0.4745,    0.3464,    0.5003,    0.8642,    0.6253, 
   0.6226,    0.5841,    0.6103,    0.7084,    1.0044, 
   1.2689,    1.4777,    1.9943,    6.4814,    0.4239, },
{1.,   0.3796,    0.4774,    0.7541,    0.7555,    0.6889, 
   0.4999,    0.5987,    0.6792,    0.6413,    0.7038, 
   0.4815,    0.4729,    0.2818,    0.3635,    0.2875, 
   0.4431,    0.3847,    0.3711,    0.4239,    12.8376, }
};

static float blosum62P[21][21] = {
{ 0.0, 0.0500, 0.0500, 0.0500, 0.0500, 0.0500, 
       0.0500, 0.0500, 0.0500, 0.0500, 0.0500, 
       0.0500, 0.0500, 0.0500, 0.0500, 0.0500, 
       0.0500, 0.0500, 0.0500, 0.0500, 0.0500 },
/*     C       G       A       S       T       
       N       D       E       Q       K       
       R       H       W       Y       F       
       V       I       L       M       P       */
{ 0.0, 0.6733, 0.0145, 0.0299, 0.0254, 0.0255, 
       0.0137, 0.0104, 0.0098, 0.0126, 0.0120, 
       0.0106, 0.0122, 0.0155, 0.0149, 0.0151, 
       0.0260, 0.0225, 0.0221, 0.0210, 0.0131 },
{ 0.0, 0.0251, 0.4101, 0.0630, 0.0539, 0.0346, 
       0.0515, 0.0378, 0.0287, 0.0321, 0.0351, 
       0.0268, 0.0294, 0.0252, 0.0208, 0.0203, 
       0.0201, 0.0164, 0.0170, 0.0236, 0.0285 },
{ 0.0, 0.0484, 0.0589, 0.2175, 0.0820, 0.0549, 
       0.0328, 0.0303, 0.0413, 0.0422, 0.0432, 
       0.0341, 0.0317, 0.0232, 0.0302, 0.0259, 
       0.0522, 0.0352, 0.0335, 0.0403, 0.0420 },
{ 0.0, 0.0384, 0.0470, 0.0765, 0.1997, 0.0839, 
       0.0640, 0.0475, 0.0494, 0.0502, 0.0484, 
       0.0399, 0.0383, 0.0200, 0.0290, 0.0229, 
       0.0294, 0.0230, 0.0223, 0.0311, 0.0393 },
{ 0.0, 0.0382, 0.0299, 0.0508, 0.0833, 0.2493, 
       0.0508, 0.0359, 0.0383, 0.0408, 0.0409, 
       0.0350, 0.0288, 0.0222, 0.0296, 0.0249, 
       0.0506, 0.0402, 0.0341, 0.0410, 0.0355 },
{ 0.0, 0.0192, 0.0416, 0.0284, 0.0594, 0.0474, 
       0.3420, 0.0749, 0.0439, 0.0482, 0.0453, 
       0.0414, 0.0589, 0.0134, 0.0234, 0.0171, 
       0.0178, 0.0158, 0.0149, 0.0229, 0.0241 },
{ 0.0, 0.0155, 0.0326, 0.0280, 0.0470, 0.0357, 
       0.0799, 0.3804, 0.0868, 0.0461, 0.0403, 
       0.0295, 0.0349, 0.0119, 0.0178, 0.0154, 
       0.0173, 0.0174, 0.0147, 0.0178, 0.0308 },
{ 0.0, 0.0144, 0.0242, 0.0372, 0.0477, 0.0372, 
       0.0458, 0.0848, 0.2747, 0.0955, 0.0657, 
       0.0482, 0.0482, 0.0188, 0.0249, 0.0166, 
       0.0215, 0.0166, 0.0187, 0.0251, 0.0341 },
{ 0.0, 0.0167, 0.0246, 0.0346, 0.0441, 0.0362, 
       0.0457, 0.0410, 0.0869, 0.2854, 0.0710, 
       0.0643, 0.0534, 0.0233, 0.0279, 0.0153, 
       0.0213, 0.0175, 0.0218, 0.0395, 0.0293 },
{ 0.0, 0.0179, 0.0302, 0.0398, 0.0478, 0.0407, 
       0.0482, 0.0402, 0.0671, 0.0797, 0.2444, 
       0.1066, 0.0400, 0.0184, 0.0273, 0.0177, 
       0.0234, 0.0203, 0.0220, 0.0321, 0.0361 },
{ 0.0, 0.0155, 0.0225, 0.0307, 0.0384, 0.0340, 
       0.0430, 0.0287, 0.0481, 0.0704, 0.1041, 
       0.3340, 0.0459, 0.0198, 0.0279, 0.0191, 
       0.0210, 0.0178, 0.0237, 0.0312, 0.0241 },
{ 0.0, 0.0132, 0.0183, 0.0211, 0.0273, 0.0207, 
       0.0454, 0.0252, 0.0356, 0.0434, 0.0289, 
       0.0340, 0.5013, 0.0165, 0.0667, 0.0242, 
       0.0126, 0.0121, 0.0141, 0.0217, 0.0176 },
{ 0.0, 0.0093, 0.0087, 0.0086, 0.0079, 0.0089, 
       0.0057, 0.0048, 0.0077, 0.0105, 0.0074, 
       0.0081, 0.0092, 0.7852, 0.0435, 0.0283, 
       0.0077, 0.0084, 0.0117, 0.0126, 0.0058 },
{ 0.0, 0.0173, 0.0139, 0.0217, 0.0223, 0.0229, 
       0.0194, 0.0138, 0.0198, 0.0244, 0.0212, 
       0.0222, 0.0718, 0.0842, 0.3926, 0.1106, 
       0.0263, 0.0252, 0.0276, 0.0283, 0.0145 },
{ 0.0, 0.0206, 0.0160, 0.0219, 0.0207, 0.0226, 
       0.0167, 0.0141, 0.0155, 0.0157, 0.0162, 
       0.0179, 0.0307, 0.0646, 0.1302, 0.3821, 
       0.0350, 0.0445, 0.0543, 0.0472, 0.0135 },
{ 0.0, 0.0437, 0.0195, 0.0541, 0.0327, 0.0567, 
       0.0213, 0.0194, 0.0248, 0.0270, 0.0264, 
       0.0243, 0.0196, 0.0216, 0.0380, 0.0431, 
       0.2133, 0.1397, 0.0759, 0.0733, 0.0256 },
{ 0.0, 0.0380, 0.0160, 0.0368, 0.0258, 0.0453, 
       0.0191, 0.0197, 0.0192, 0.0223, 0.0230, 
       0.0206, 0.0190, 0.0238, 0.0367, 0.0550, 
       0.1406, 0.2325, 0.0985, 0.0859, 0.0224 },
{ 0.0, 0.0379, 0.0168, 0.0355, 0.0253, 0.0390, 
       0.0183, 0.0169, 0.0220, 0.0282, 0.0253, 
       0.0280, 0.0225, 0.0335, 0.0409, 0.0682, 
       0.0776, 0.1001, 0.2242, 0.1178, 0.0219 },
{ 0.0, 0.0290, 0.0187, 0.0343, 0.0284, 0.0376, 
       0.0225, 0.0164, 0.0237, 0.0409, 0.0296, 
       0.0295, 0.0277, 0.0289, 0.0336, 0.0476, 
       0.0601, 0.0700, 0.0945, 0.3070, 0.0201 },
{ 0.0, 0.0169, 0.0212, 0.0335, 0.0335, 0.0306, 
       0.0222, 0.0266, 0.0302, 0.0285, 0.0312, 
       0.0214, 0.0210, 0.0125, 0.0161, 0.0128, 
       0.0197, 0.0171, 0.0165, 0.0188, 0.5699 } };

static float Dirichlet30P[31][21] = {
 { 0.0, 0.0500, 0.0500, 0.0500, 0.0500, 0.0500,
   0.0500, 0.0500, 0.0500, 0.0500, 0.0500,
   0.0500, 0.0500, 0.0500, 0.0500, 0.0500,
   0.0500, 0.0500, 0.0500, 0.0500, 0.0500 },
{ 0.0, 0.022183, 0.025437, 0.085549, 0.049761, 0.070277,
   0.020932, 0.011106, 0.020996, 0.022091, 0.024787,
   0.024429, 0.015539, 0.010222, 0.030963, 0.050573,
   0.157532, 0.132951, 0.150287, 0.057724, 0.016663},
{ 0.0, 0.032960, 0.143573, 0.056263, 0.058885, 0.051347,
   0.044766, 0.069251, 0.038523, 0.039582, 0.044210,
   0.061127, 0.042894, 0.023787, 0.036816, 0.040004,
   0.031715, 0.022624, 0.066547, 0.011785, 0.083330},
{ 0.0, 0.008453, 0.011081, 0.014456, 0.019711, 0.015101,
   0.019097, 0.007855, 0.008649, 0.016781, 0.012044,
   0.016492, 0.050953, 0.050139, 0.364613, 0.255959,
   0.025278, 0.023453, 0.056197, 0.015111, 0.008577},
{ 0.0, 0.005879, 0.084583, 0.045214, 0.117267, 0.053374,
   0.212785, 0.169731, 0.075148, 0.041671, 0.054819,
   0.028072, 0.036982, 0.002161, 0.013778, 0.007495,
   0.009432, 0.006101, 0.011029, 0.003827, 0.020653},
{ 0.0, 0.004916, 0.020904, 0.036117, 0.036904, 0.035444,
   0.036073, 0.013492, 0.046133, 0.087376, 0.307554,
   0.222668, 0.030255, 0.004348, 0.012391, 0.005576,
   0.022889, 0.016425, 0.033825, 0.013944, 0.012766},
{ 0.0, 0.007652, 0.004218, 0.019436, 0.005190, 0.016255,
   0.003044, 0.001887, 0.003729, 0.009009, 0.004080,
   0.006051, 0.004005, 0.007880, 0.015425, 0.084989,
   0.086105, 0.152735, 0.456800, 0.106051, 0.005460},
{ 0.0, 0.015389, 0.005906, 0.042317, 0.008924, 0.034892,
   0.005228, 0.004093, 0.005657, 0.003282, 0.005449,
   0.003511, 0.001399, 0.001177, 0.006149, 0.019712,
   0.380003, 0.307863, 0.115721, 0.028581, 0.004749},
{ 0.0, 0.000760, 0.019275, 0.054812, 0.032354, 0.025765,
   0.024561, 0.144127, 0.460190, 0.074480, 0.056243,
   0.019923, 0.010653, 0.000871, 0.004291, 0.002495,
   0.018574, 0.009388, 0.016315, 0.007174, 0.017748},
{ 0.0, 0.038455, 0.107921, 0.315754, 0.186379, 0.095442,
   0.022838, 0.011639, 0.013367, 0.016663, 0.011128,
   0.015635, 0.007523, 0.003515, 0.007257, 0.011113,
   0.054669, 0.015489, 0.023109, 0.011626, 0.030479},
{ 0.0, 0.006726, 0.037809, 0.086992, 0.088663, 0.066678,
   0.062534, 0.060100, 0.107630, 0.078867, 0.113765,
   0.070740, 0.032534, 0.004843, 0.019663, 0.015349,
   0.036147, 0.023388, 0.041623, 0.019691, 0.026260},
{ 0.0, 0.014513, 0.028952, 0.732922, 0.058240, 0.020507,
   0.006710, 0.006232, 0.009514, 0.006222, 0.008866,
   0.008129, 0.003517, 0.002075, 0.004145, 0.007178,
   0.039433, 0.012508, 0.018365, 0.008328, 0.003646},
{ 0.0, 0.959814, 0.001684, 0.005632, 0.002961, 0.003991,
   0.001591, 0.001441, 0.002130, 0.001299, 0.001485,
   0.001952, 0.000990, 0.000328, 0.000851, 0.001586,
   0.002669, 0.003253, 0.003439, 0.001687, 0.001215},
{ 0.0, 0.001690, 0.006065, 0.008971, 0.008821, 0.005111,
   0.029754, 0.859473, 0.036083, 0.004551, 0.004798,
   0.004338, 0.004698, 0.001045, 0.002985, 0.002695,
   0.005274, 0.004001, 0.005150, 0.002084, 0.002413},
{ 0.0, 0.000414, 0.001875, 0.002415, 0.001718, 0.001468,
   0.002535, 0.012298, 0.963690, 0.003168, 0.001215,
   0.001150, 0.001069, 0.000279, 0.000615, 0.000666,
   0.001456, 0.001492, 0.001298, 0.000554, 0.000624},
{ 0.0, 0.004283, 0.003294, 0.008398, 0.008338, 0.004187,
   0.002873, 0.002981, 0.003581, 0.002187, 0.003203,
   0.002648, 0.001968, 0.004484, 0.025446, 0.850936,
   0.012068, 0.013053, 0.035188, 0.007297, 0.003585},
{ 0.0, 0.002365, 0.868718, 0.023445, 0.016509, 0.006502,
   0.012342, 0.011296, 0.008114, 0.004401, 0.008597,
   0.007953, 0.003456, 0.001406, 0.002758, 0.002481,
   0.005505, 0.003430, 0.004097, 0.002393, 0.004231},
{ 0.0, 0.003860, 0.007387, 0.010006, 0.018725, 0.012845,
   0.036707, 0.013150, 0.010898, 0.042991, 0.006861,
   0.023413, 0.722249, 0.003907, 0.033135, 0.012285,
   0.008374, 0.005212, 0.015010, 0.006730, 0.006255},
{ 0.0, 0.002677, 0.003728, 0.010694, 0.007734, 0.010924,
   0.004676, 0.004042, 0.004666, 0.003727, 0.005910,
   0.004182, 0.001826, 0.001404, 0.004949, 0.008390,
   0.140679, 0.681615, 0.077033, 0.018434, 0.002712},
{ 0.0, 0.001697, 0.003029, 0.006887, 0.003922, 0.004617,
   0.004495, 0.002227, 0.003469, 0.003245, 0.903944,
   0.041775, 0.002092, 0.000893, 0.001443, 0.001159,
   0.002966, 0.004009, 0.003775, 0.001861, 0.002496},
{ 0.0, 0.003679, 0.003825, 0.011465, 0.007486, 0.010155,
   0.003928, 0.002962, 0.005961, 0.007536, 0.006501,
   0.007718, 0.003384, 0.002424, 0.005820, 0.019001,
   0.031260, 0.040194, 0.790038, 0.031659, 0.005005},
{ 0.0, 0.001656, 0.001943, 0.003539, 0.002946, 0.003115,
   0.001629, 0.001493, 0.001611, 0.001563, 0.002113,
   0.001390, 0.001019, 0.001563, 0.003406, 0.002798,
   0.007232, 0.009691, 0.021704, 0.928022, 0.001568},
{ 0.0, 0.002391, 0.006893, 0.006751, 0.023818, 0.011602,
   0.858995, 0.014038, 0.004345, 0.007710, 0.007890,
   0.005705, 0.014883, 0.001679, 0.003539, 0.003658,
   0.005915, 0.007154, 0.006140, 0.002897, 0.003997},
{ 0.0, 0.003602, 0.012380, 0.041799, 0.028339, 0.018962,
   0.009154, 0.011379, 0.015237, 0.013138, 0.016512,
   0.012587, 0.006070, 0.001285, 0.003536, 0.005648,
   0.014003, 0.009135, 0.016726, 0.004905, 0.755604},
{ 0.0, 0.002670, 0.004267, 0.014299, 0.011197, 0.008895,
   0.010470, 0.005329, 0.032161, 0.807311, 0.010611,
   0.014911, 0.025751, 0.002067, 0.002666, 0.002871,
   0.006815, 0.005653, 0.016119, 0.009558, 0.006381},
{ 0.0, 0.003142, 0.004679, 0.007569, 0.006509, 0.005060,
   0.005770, 0.002967, 0.003276, 0.009536, 0.027726,
   0.889700, 0.007210, 0.002055, 0.002301, 0.001946,
   0.002943, 0.004061, 0.006639, 0.002179, 0.004733},
{ 0.0, 0.006972, 0.009548, 0.028482, 0.707416, 0.139256,
   0.019459, 0.007498, 0.006047, 0.006118, 0.010446,
   0.009797, 0.003807, 0.001538, 0.004601, 0.005152,
   0.006563, 0.006379, 0.009089, 0.004714, 0.007118},
{ 0.0, 0.007180, 0.007340, 0.024720, 0.107763, 0.690341,
   0.023042, 0.008456, 0.007624, 0.011031, 0.012988,
   0.011204, 0.004921, 0.001939, 0.003921, 0.006001,
   0.024936, 0.017376, 0.012577, 0.010045, 0.006594},
{ 0.0, 0.007345, 0.005934, 0.044749, 0.010007, 0.024013,
   0.005017, 0.005765, 0.008057, 0.004920, 0.007143,
   0.008130, 0.004166, 0.001262, 0.002611, 0.007142,
   0.745035, 0.068859, 0.025512, 0.008007, 0.006326},
{ 0.0, 0.002133, 0.004192, 0.005173, 0.004657, 0.004173,
   0.003637, 0.003506, 0.003903, 0.003875, 0.004210,
   0.005020, 0.002366, 0.888513, 0.012561, 0.018439,
   0.006210, 0.004042, 0.017141, 0.003791, 0.002459},
{ 0.0, 0.008099, 0.011827, 0.034205, 0.028779, 0.017614,
   0.013199, 0.012685, 0.017470, 0.011624, 0.016444,
   0.015903, 0.043134, 0.013185, 0.494687, 0.156033,
   0.024986, 0.020475, 0.036366, 0.012981, 0.010304} };

static float Dirichlet30Mix[31] = { 0.0, 0.055795, 0.198333, 0.043566, 0.060170, 0.065466, 0.067614, 0.080724, 0.051030, 0.103529, 0.062940, 0.012518, 0.004953, 0.013849, 0.008388, 0.008064, 0.032205, 0.005033, 0.007454, 0.009400, 0.017057, 0.002761, 0.005734, 0.022818, 0.005931, 0.011491, 0.008219, 0.019050, 0.007047, 0.003957, 0.004904 };


static float Dirichlet30Conc[31] = { 0.0, 5.623820, 0.097240, 1.648336, 2.595432, 3.112271, 2.053644, 2.138987, 3.878926, 1.486325, 8.221215, 38.955630, 381.562208, 90.727567, 404.591046, 83.323671, 32.644869, 35.520823, 101.265474, 150.415980, 31.896633, 201.346274, 108.343187, 15.153304, 79.417510, 93.103899, 47.504796, 14.027470, 76.958153, 150.973331, 30.653224 };

#endif

