/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ***************************************************************************************/

#if !defined(_RDC_TYP_H_)
#define _RDC_TYP_H_

#include "stdinc.h"
#include "alphabet.h"
#include "cmsa.h"
#include "residues.h"
#include "table.h"
#include "dheap.h"
#include "set_typ.h"
#include "blosum62.h"
#include "table.h"
#include "swt_typ.h"

class rdc_typ {         // rank direct couplings type
public:
	rdc_typ(){ print_error("rdc_typ( ) constructor disallowed"); }
        rdc_typ(cma_typ in_cma){ own_cma=FALSE; cma=in_cma; AB=AlphabetCMSA(cma); }
        rdc_typ(char *cmafile){
		AB = MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
        	cma=ReadCMSA2(cmafile,AB); own_cma=TRUE;
	}
	~rdc_typ( ){ if(own_cma){ TotalNilCMSA(cma); NilAlpha(AB); } }
	Int4 Run(FILE *ofp,Int4 pairA,Int4 pairB,Int4 rank){
		  long double **rtn=RunRtnLogP(ofp,pairA,pairB,rank);
		  for(Int4 i=1; rtn[i]; i++) free(rtn[i]); free(rtn);
		}
	long double	**RunRtnLogP(FILE *ofp,Int4 pairA,Int4 pairB,Int4 rank,swt_typ *swt=0);
private:
	void	Init(char *cmafile);
	BooLean	own_cma;
	cma_typ	cma;
	char	*filename;
	long double FisherExact(Int4 red_out, Int4 black_out,Int4 red_in,Int4 black_in,
                                                BooLean onetail=TRUE, FILE *fp=0);
	a_type  AB;
};

#endif
