/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined (_DRC_TYP_)
#define _DRC_TYP_

#include <cstdlib>
# include <iostream>
# include <iomanip>
# include <omp.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

// #include <cuda.h>
// #include <cuda_runtime_api.h>

#include "ccmpred.h"
#include "evaluate_cpu.h"
#include "evaluate_cpu_omp.h"
// #include "evaluate_cuda.h
// #include "evaluate_cuda_kernels.h"
#include "io.h"
#include "meta.h"
#include "numdif.h"
#include "parseopt.h"
#include "reweighting.h"
#include "sequence.h"
#include "util.h"
#include <stdbool.h>
#include "conjugrad.h"

#include "omc_typ.h"
#include "lha_typ.h"
#include "hierview.h"
#include "c2h_typ.h"
#include "hsc_typ.h"
#include "edc_typ.h"
#include "drc_typ.h"
#include "sprc_typ.h"
#include "c2a_typ.h"
#include "scl_typ.h"
#include "ssd_typ.h"
#include "rdc_typ.h"

#include "stdinc.h"
#include "histogram.h"
#include "dheap.h"
#include "afnio.h"

// # using namespace std;

extern "C" int run_ccmpred(int argc, char **argv);

class lsd_typ {         // layered subsample darc type
public:
        lsd_typ(){ print_error("lsd_typ( ) constructor disallowed"); }
        lsd_typ(Int4 sl,Int4 ct){
		  sqlen=sl;
		  Int4 i,cuts[]={ 0, 20, 10, 5, 2, 0 };
        	  for(i=1; i <= 4; i++){ ssd[i]=new ssd_typ(cuts[i],sqlen,ct); } ssd[i]=0;
        	  for(i=1; i <= 4; i++) NN[i]=0;
		}
	~lsd_typ(){ for(Int4 i=1; ssd[i] != 0; i++) delete  ssd[i]; }
	Int4	**Put(FILE *fp,FILE *pfp=0,char chn=0, Int4 OS=0){
		Int4 **col_pairs=ssd[1]->PutSorted(fp,ssd[2],ssd[3],ssd[4],pfp,chn,OS);
		return col_pairs;
		}
	Int4	AddToHeap(Int4 x, Int4 y, Int4 ii, Int4 jj, Int4 cI, Int4 cJ, double d){
		   for(Int4 i=1; ssd[i] != 0; i++){
			Int4 rtn=ssd[i]->AddToHeap(x,y,ii,jj,cI,cJ,d); 
			if(rtn > 0) NN[i] += ssd[i]->RtnXY(x,y);
		   }
		}
	Int4	IncXY(Int4 j, Int4 x, Int4 y){
		   Int4 fnd=0;
		   for(Int4 i=1; ssd[i] != 0; i++){
                      if(j <= ssd[i]->RtnCut()){ 
			fnd++; ssd[i]->IncXY(x,y); 
			// if(ssd[i]->RtnXY(x,y) == 1) fprintf(stdout,"%d: %d %d\n", j,x,y);
		      }
                   } return fnd;
		}
	Int4	RtnNumInHeap(){ 
		   Int4 N=0;
		   for(Int4 i=1; ssd[i] != 0; i++) N+= ssd[i]->RtnNumInHeap();
		   return N;
		}
private:
	ssd_typ *ssd[6];
	Int4	sqlen,NN[6];
};

class drc_typ {         // Deep Analysis of Residue Correlations (DARC) type
public:
                drc_typ(){ print_error("drc_typ( ) constructor disallowed"); }
                drc_typ(int ac, char *av[],char mode=0,BooLean clbr=TRUE){
			Mode=mode; clobber=clbr;
			argc=ac; NEWP(argv,argc +3, char);
			for(Int4 i=0; i < argc; i++) argv[i]=AllocString(av[i]); 
			Init(); 
			if(mode=='R'){ GetArgSPARC(); PathSPARC=AllocString(argv[2]); }
			else if(mode=='S'){ GetArgSPARC(); PathSPARC=AllocString(argv[2]); }
			else if(mode=='B'){ GetArg(); } else GetArg(".darc");
		}
                ~drc_typ( ){ Free(); for(Int4 i=0; i < argc; i++) free(argv[i]); free(argv); }
	Int4	Run();
	Int4    run_sparc();
#if 0
	Int4	SubSampleDCA(Int4 Cut, Int4 Size, Int4 Num, FILE *ofp, FILE *pmlfp=0,
			char chn=0, Int4 OS=0,char *cmafile=0);
#else
	lsd_typ	*SubSampleDCA(Int4 Cut, Int4 Size, Int4 Num, FILE *ofp);
#endif
	Int4	run_key_starc(char *PdbSeqID,char *pdb_path,FILE *osfp=0);
	Int4    ScoreSeqs(Int4 Cut=30);	// see what seqs best match DCA and BPPS patterns.
	BooLean	ModeIsMDS(){ if(mds_file) return TRUE; else return FALSE; }
private:
#if 1	// needed for -mds=<mds_file>:<src_pdbid> option.
	char	*mds_file;	
	Int4	NumPDBidsMDS();
	void	PrintErrorMDS(char c, Int4 j, FILE *fp);
	char	*src_pdb;	
	char	*srch_ptrn;
	char	*ptrn_file;
#endif
	BooLean	clobber;
	set_typ MapX2I(Int4 *&x2i,char *&x2c);
	Int4    SubSample(Int4 Num, Int4 L,UInt2 *x2i,Int4 MinSepar, lsd_typ *lsd,set_typ SetXY);
	void    PrintError(const char *usage,const char *version);
	char	Mode;
	//================= drc_init.cc routines ===================
	void	Init();
	void	Free();
	void	GetArg(const char *suffix=0);
	void	GetArgSPARC();
	//================= drc_typ.cc test routines ===================
	//================= drc_typ.cc routines ===================
	Int4    ReSizeInCCM(Int4 N,char *infile,char *outfile=0);
	//================= drc_typ.cc routines ===================
	Int4    find_lots_of_pdbids(FILE *fp);
	Int4	run_bpps(FILE *mmafp, FILE *hptfp, FILE *ptrnfp); // creates fg & bg .
	Int4	run_c2a();		// requires fg (& bg); creates mst & ccm input files
	Int4	run_ccm();		// requires ccm input; performs DCA on fg (& bg).
	Int4	expand_pdbids(char *mstfile);	// requires mst file; creates list of pdb_ids
	Int4	create_pdb_paths(Int4 X); // requires mst file; creates paths to pdb files
	Int4	run_sarp(FILE *vsifp,FILE *mmafp,FILE *hptfp,FILE *ptrnfp); 
	Int4    MapMST2VSI(FILE *vsifp); // creates mst2vsi array
	Int4	expand_mstfile(char *mstfile);	// requires bpps_ptrns & pdbAllID & mst2vsi.
	Int4	SetUpPyMOL(FILE *vsifp,Int4 hpsz);
	Int4	MkPyMOL(FILE *vsifp,Int4 end);
	dch_typ *run_starc(Int4 hpsz,Int4 end);
	Int4    GetSubMST(FILE *ofp,char *keypdb, char *twinpdb);
	Int4    KeyPdbID(Int4 grp);
	//================= objects ===================
	char	**argv,**Argv,*ArgV[25];
	Int4	argc,Argc,ArgC;
	char    *pdbaa_path,***bpps_ptrns,***SeqID,***pdbAllID,**PdbPath;
	char	**pdbID;	// from mst file...in order...
	char	**pdbUnique;
	char	*PathSPARC;	// path to SPARC pdb directory = argv[2].
	char	*SbSmplKey;
	Int4	SbSmplSize,SbSmplNum;
	Int4	SizeInCCM;	// run sparc only...
	Int4	num_thrds,query_id,MaxDepth,num_dc,NumPdbID,*numF,maxF;
	Int4    nMst,*IDs,*File,*X2id,*X2file;
	BooLean UseBG,MkSIPRIS; 
	Int4	*mst2vsi;	// map mst item number to vsi file number.
	static const Int4 StrLen=5000,len_str=500;
	char    str[502],str0[201],str1[502],str2[201],Str[5005];
	float   Dmax;
};

#endif

