/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/
#include "drc_typ.h"

void	drc_typ::PrintErrorMDS(char C, Int4 J,FILE *fp)
{
	Int4	i;
	char c;
	fprintf(stderr,"case %d --> '%c'...\"",J,C);
	for(i=0; (c=fgetc(fp)) != EOF && i < 10; i++){ fprintf(stderr,"%c",c); }
	fprintf(stderr,"\".\n");
	print_error("mds input file syntax error");
}

Int4	drc_typ::NumPDBidsMDS()
{
	Int4	i,j,n=0;
	char	c;
	assert(mds_file);
	FILE *fp=open_file(mds_file,"","r");
	for(n=i=0; (c=fgetc(fp)) != EOF; ){
	   if(isspace(c)) continue;
	   j=i%7;
	   switch (j){
	     case 0: if(!isdigit(c)) this->PrintErrorMDS(c,j,fp); break;
	     case 1: case 2: case 3:
		if(!isupper(c) && !isdigit(c)) this->PrintErrorMDS(c,j,fp);
	       break;
	     case 4: if(c != '_') this->PrintErrorMDS(c,j,fp); break;
	     case 5: if(!isalnum(c)) this->PrintErrorMDS(c,j,fp); break;
	     case 6:
		if(c == ';' || c == '.') n++; else this->PrintErrorMDS(c,j,fp);
	       break;
	     default: this->PrintErrorMDS(c,j,fp);
	   } i++;
	} fclose(fp);  
	n *= 12;   // assume <= 12 adjacent identical subunits: dodecahedron.
	return n;
}

Int4	drc_typ::run_sparc()
// run the SPARC program on the full MSA to find interesting structures.
{
	Int4    m,sq,i,A,N,NumFG=0,hpsz=10000;
	FILE	*fp=0,*tfp;
	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);

	// 2. ========= Create CCMpred input & *.dca + *.mst output files ============
	ArgV[0]=AllocString("cma2aln");
	sprintf(str,"%s_sprc",argv[1]); ArgV[1]=AllocString(str); ArgC=2;
	// sprintf(str,"%s.mma",argv[1]); pdbID=run_cma2aln(ArgC,ArgV,NumFG,str);
	pdbID=run_cma2aln(ArgC,ArgV,NumFG,argv[1]);	// use argv[1] as input...
	// pdbID=pdbids in *_fg and in *.mst files.
	if(SbSmplNum > 0){
	   double d=(double)SbSmplSize/(double)NumFG;
	   if(d > 0.20){
		fprintf(stderr,
		   "!!!!!!!!!!! WARNING: Subsample size (%d) is too large !!!!!!!!!!\n",
			SbSmplSize);
		SbSmplSize = (Int4) floor((double)NumFG/3.0); 
		fprintf(stderr,"   --> reseting to %d sequences.\n",SbSmplSize);
	   }
	}
	for(nMst=1; pdbID[nMst]; ) nMst++; nMst--;

        sprintf(str,"%s_sprc_X.mst",argv[1]);
	hpsz=this->expand_pdbids(str); 	// requires mst file; creates pdbAllID.
// fprintf(stderr,"0. hpsz=%d\n",hpsz);
        sprintf(str,"%s_sprc_X.mst",argv[1]);
	this->expand_mstfile(str);

	sprintf(str,"%s_sprc",argv[1]);
	fprintf(stderr,"PDB sequences found in the query partition ('%s') of the input MSA.\n",str);
	for(NumPdbID=0,i=1; pdbID[i]; i++){  
		NumPdbID++;
		if(i%10 == 1) fprintf(stderr," %s",pdbID[i]); else fprintf(stderr,", %s",pdbID[i]);
		if(i%10 == 0) fprintf(stderr,"\n");
	}
	if(pdbID == 0) print_error("No pdb sequences found"); else fprintf(stderr,"\n");
	for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }

	// 3. ================ Run CCMpred ====================
	sprintf(str,"%s_sprc_X.dca",argv[1]); fp=fopen(str,"r");
	if(fp == NULL){ 
	  if(SizeInCCM > 0 && SizeInCCM < N){    // Use a limited number of aligned sequences for DCA. 
	    sprintf(str,"%s_sprc.in",argv[1]); this->ReSizeInCCM(N,str);
	  }
	  ArgV[3]=ArgV[4]=0; ArgV[0]=AllocString("ccmpred"); ArgC=1;
	  ArgV[ArgC]=AllocString("-t"); ArgC++;
	  sprintf(str,"%d",num_thrds); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_sprc.in",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_sprc_X.dca",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
	  run_ccmpred(ArgC,ArgV);  fflush(stdout);
	  for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }
	} else fclose(fp); 

	//================= 4. Run SPARC ========================
	char	*s;
	ArgV[0]=AllocString("sparc"); ArgC=1;
#if 0
	fp=open_file(argv[2],"","r");
	if(fgets(Str,5000,fp) == NULL) print_error("pdb_paths invalid");
	fclose(fp);
	if(strchr(Str,'/') == NULL){ ArgV[1]=AllocString("./"); ArgC++; }
	else {
	   s=strrchr(Str,'/'); s++; *s=0;   // end string after last slash.
	   ArgV[1]=AllocString(Str); ArgC++;	// path to pdb files.
	}
#else
	ArgV[1]=AllocString(PathSPARC); ArgC++;	// path to pdb files.
#endif
	if(mds_file){ hpsz += this->NumPDBidsMDS(); } // fprintf(stderr,"2. hpsz=%d\n",hpsz);
	sprintf(str,"%s_sprc_X",argv[1]); ArgV[2]=AllocString(str); ArgC++;
        dch_typ *dch= new dch_typ(hpsz);
        sprc_typ sprc(ArgC,ArgV,dch);
if(src_pdb) sprc.PassInMDS(mds_file,src_pdb,ptrn_file);
        int rtn=sprc.run_mstarc(0,0,0,0,argv[1]); 
	fp=open_file(argv[1],".sprc","a");
	fprintf(fp,"\n######################## SPARC search results ########################\n");
        dch->Put(fp); fprintf(fp,"\n"); delete dch; fclose(fp);
	for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }

	NilAlpha(AB);
	return 0;
}

Int4	drc_typ::ReSizeInCCM(Int4 N, char *infile,char *outfile)
{
	Int4    m,sq;
	FILE	*fp=0,*tfp;

	if(SizeInCCM > 0){    // Use a limited number of the aligned sequences for DCA. 
            dh_type dH=dheap(N+2,4);
            for(sq=2; sq <= N; sq++){ insrtHeap(sq,(keytyp) Random(),dH); }
            BooLean *keep; NEW(keep,N+3,BooLean);
	    for(keep[1]=TRUE,m=1; (sq=delminHeap(dH)) != 0; ){
                        m++; keep[sq]=TRUE;
                        if(m >= SizeInCCM) break;
            } Nildheap(dH);
	    tfp=tmpfile(); fp=open_file(infile,"","r");
	    Str[4999]=0;
	    for(sq=1; fgets(Str,5000,fp) != NULL; sq++){	// read CCM input lines
		if(Str[4999] != 0) print_error("fatal: aln file input sequence too long\n");
		if(keep[sq]) fprintf(tfp,"%s",Str); 
		Str[4999]=0;
	    } rewind(tfp); free(keep); fclose(fp);
	    if(outfile == 0) fp=open_file(infile,"","w");
	    else fp=open_file(outfile,"","w");
	    for( ; fgets(Str,5000,tfp) != NULL; ) fprintf(fp,"%s",Str); 
	    fclose(fp); fclose(tfp); return 0;
	} return 1;
}


set_typ	drc_typ::MapX2I(Int4 *&x2i,char *&x2c)
// call this within drc_sbsmpl.cc as well once it is working...
{
        Int4    arg,i,j,k,n,x,y,time1,nDC;
        char    *s,fstr[201];
        double  d;
        Int4    L,Max,sqlen=0;

        //============ 1. Check arguments. ===========
        Int4 MinSepar=5;
        char cI,cJ;
        Int4 ii,jj,dm[12];

        //============ 2. find the maximum and minimum residue positions from ref_dca  ===========
// fprintf(stderr,"1. Mode='%c'\n",Mode);
        if(Mode == 'B') sprintf(fstr,"%s_X",argv[1]); 
        else if(Mode == 'S') sprintf(fstr,"%s_sprc_X",argv[1]); 
	else sprintf(fstr,"%s_fg_X",argv[1]);
        FILE *fp=open_file(fstr,"","r");
        for(Max=0,L=0; fgets(str,500,fp) != NULL; ){
           if(sscanf(str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c",
                &ii,&jj,&d,&x,&y,&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&cI,&cJ) != 12){
                        fprintf(stderr,"%d. --> %s",L,str);
                        fprintf(stderr,"input file name --> %s\n",fstr);
                        print_error("SubSampleDCA score file input error 1.");
           } Max=MAXIMUM(Int4,x,Max); Max=MAXIMUM(Int4,y,Max);
           if(abs(ii-jj) >= MinSepar) L++;
        } fclose(fp); nDC=L; L=L*2;     // nDC = # of pairs in reference dca.

        //============ 1. map x2i; (columns to sequence positions) ===========
        sqlen=Max; NEW(x2i,sqlen +2,Int4); NEW(x2c,sqlen +2,char);
        set_typ SetXY=MakeSet(sqlen+2);
        fp=open_file(fstr,"","r");
        for( ; fgets(str,500,fp) != NULL; ){
           if(sscanf(str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c",
                &ii,&jj,&d,&x,&y,&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&cI,&cJ) != 12)
                        print_error("SubSampleDCA score file input error 2.");
           if(x2i[x]) assert(ii==x2i[x]); else x2i[x]=ii;
           if(x2i[y]) assert(jj==x2i[y]); else x2i[y]=jj;
           if(x2c[x]) assert(cI==x2c[x]); else x2c[x]=cI;
           if(x2c[y]) assert(cJ==x2c[y]); else x2c[y]=cJ;
           AddSet(x,SetXY); AddSet(y,SetXY);
        } fclose(fp);
	return SetXY;
}

Int4	drc_typ::ScoreSeqs(Int4 Cut)
// run the SPARC program on the full MSA to find interesting structures.
{
	Int4    i,j,k,N,m,sq,A,NumFG=0,hpsz=10000;
	FILE	*fp=0,*tfp;
	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);

	//===== 1. Create CCMpred input file from cmafile.
	ArgV[0]=AllocString("cma2aln");
	sprintf(str,"%s_sprc",argv[1]); ArgV[1]=AllocString(str); ArgC=2;
	if(pdbID){ for(i=1; pdbID[i]; i++) free(pdbID[i]); free(pdbID); pdbID=0; }
	// sprintf(str,"%s.mma",argv[1]); pdbID=run_cma2aln(ArgC,ArgV,NumFG,str);
	pdbID=run_cma2aln(ArgC,ArgV,NumFG,argv[1]);	// use argv[1] as input...
	// pdbID=pdbids in *_fg and in *.mst files.
	if(SbSmplNum > 0){
	   double d=(double)SbSmplSize/(double)NumFG;
	   if(d > 0.20){
		fprintf(stderr,
		   "!!!!!!!!!!! WARNING: Subsample size (%d) is too large !!!!!!!!!!\n",
			SbSmplSize);
		SbSmplSize = (Int4) floor((double)NumFG/3.0); 
		fprintf(stderr,"   --> reseting to %d sequences.\n",SbSmplSize);
	   }
	}
	for(nMst=1; pdbID[nMst]; ) nMst++; nMst--;

	// 2. Create *mst input file.
        sprintf(str,"%s_sprc_X.mst",argv[1]);
	hpsz=this->expand_pdbids(str); 	// requires mst file; creates pdbAllID.
        sprintf(str,"%s_sprc_X.mst",argv[1]);
	this->expand_mstfile(str);

	sprintf(str,"%s_sprc",argv[1]);
	fprintf(stderr,"PDB sequences found in the query partition ('%s') of the input MSA.\n",str);
	for(NumPdbID=0,i=1; pdbID[i]; i++){  
		NumPdbID++;
		if(i%10 == 1) fprintf(stderr," %s",pdbID[i]); else fprintf(stderr,", %s",pdbID[i]);
		if(i%10 == 0) fprintf(stderr,"\n");
	}
	if(pdbID == 0) print_error("No pdb sequences found"); else fprintf(stderr,"\n");
	for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }

	// 2. ================ Run CCMpred ====================
	sprintf(str,"%s_sprc_X.dca",argv[1]); fp=fopen(str,"r");
	if(fp == NULL){ 
	  if(SizeInCCM > 0 && SizeInCCM < N){    // Use a limited number of aligned sequences for DCA. 
	    sprintf(str,"%s_sprc.in",argv[1]); this->ReSizeInCCM(N,str);
	  }
	  ArgV[3]=ArgV[4]=0; ArgV[0]=AllocString("ccmpred"); ArgC=1;
	  ArgV[ArgC]=AllocString("-t"); ArgC++;
	  sprintf(str,"%d",num_thrds); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_sprc.in",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_sprc_X.dca",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
for(A=0; A < ArgC; A++){ fprintf(stderr,"%s ",ArgV[A]); } fprintf(stderr,"\n");
	  run_ccmpred(ArgC,ArgV);  fflush(stdout);
	  for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }
	} else fclose(fp); 

        // 2. Create a DCA file in EV-couplings format mapped to <pdbid> = <infile>_fg_X
	Argc=0;
        Argv[Argc]=AllocString("sprc"); Argc++;
        Argv[Argc]=AllocString(argv[1]); Argc++;
        // Argv[Argc]=AllocString("pdb_paths"); Argc++; 
	tfp=open_file(argv[1],".paths","w");
 	for(i=1; i <= NumPdbID; i++){
	  for(j=0; j < 4; j++) str0[j]=tolower(pdbID[i][j]); str0[j]=0;
	  fprintf(tfp,"%s/%s_H.pdb\n",argv[2],str0);
	} fclose(tfp);
	sprintf(str,"%s.paths",argv[1]);
        Argv[Argc]=AllocString(str); Argc++;
        if(num_thrds != 1){ sprintf(str,"-thrds=%d",num_thrds); Argv[Argc]=AllocString(str); Argc++; }
          // sprintf(str,"-inCCM=%d",Size); Argv[Argc]=AllocString(str); Argc++; 

	Int4 **X2I; NEWP(X2I,NumPdbID+3,Int4);
	char **X2C; NEWP(X2C,NumPdbID+3,char);
	set_typ *SetXY; NEW(SetXY,NumPdbID+3,set_typ);

        drc_typ *drc2 = 0; // drc2=new drc_typ(Argc,Argv,'S',FALSE);
	cma_typ cma=ReadCMSA2(argv[1],AB); 
	Int4 x,y,ii,jj,L; N=NumSeqsCMSA(cma); L=TotalLenCMSA(cma); 
	dh_type dH=0;
#if 1	// Obtain the Offsets...
	FILE *osfp=tmpfile();
	char	PDBID[10];
	Int4	*pdbOS; NEW(pdbOS, NumPdbID+3,Int4);
 	for(i=1; i <= NumPdbID; i++){
	  pdbOS[i]=INT4_MAX;
	  this->run_key_starc(pdbID[i],argv[2],osfp); 
	  SetXY[i]=this->MapX2I(X2I[i],X2C[i]);
	}
	rewind(osfp);
	for(j=1; fgets(str,101,osfp) != NULL; j++){
	   Int4	OS=0; assert(sscanf(str,"%s %d",PDBID,&OS) == 2);
fprintf(stderr,"%d. %s\n",j,str);
	   for(i=1; i <= NumPdbID; i++){
		if(strcmp(PDBID,pdbID[i]) == 0){
		   if(pdbOS[i]==INT4_MAX) pdbOS[i]=OS; 
	   	   fprintf(stderr,"%d. %s\t%d\t%s\n",i,PDBID,OS,pdbID[i]);
		   break;
		}
	   }
	}
	BooLean	*skip; NEW(skip,NumPdbID +5, BooLean);
	for(i=1; i <= NumPdbID; i++){
	    if(pdbOS[i]==INT4_MAX){
	   	fprintf(stderr,"%d. %s\t%d\t%s\n",i,PDBID,pdbOS,pdbID[i]);
		skip[i]=TRUE; continue;
	    	assert(pdbOS[i] != INT4_MAX);
	    }
	    // fprintf(stderr,"%d: %s\n",i,pdbID[i]);
	    for(j=1; j <= L; j++){
		if(MemberSet(j,SetXY[i])){
		      // fprintf(stdout,"%d:%d --> %c%d ",i,j,X2C[i][j],X2I[i][j]);
		      X2I[i][j] -= pdbOS[i];
		      // fprintf(stdout,"--> %c%d\n",X2C[i][j],X2I[i][j]);
		}
	    }
	} free(pdbOS); fclose(osfp);
#endif
#if 1	// get sequence weights...
	swt_typ *swt=0;
        hsw_typ hsw=0;
	BooLean	PassedInHSW=FALSE;
        sprintf(str,"%s.hsw",argv[1]);
        if((fp=fopen(str,"r")) == NULL){        // create file...
                swt = new swt_typ(cma);
                hsw=swt->RtnHSW( ); fp = open_file(argv[1],".hsw","w");
                FWriteHSW(fp,hsw); fclose(fp);
        } else { 
		hsw=FReadHSW(fp,AB,cma); fclose(fp); swt = new swt_typ(hsw); 
		PassedInHSW=TRUE; 
	}
	double  total,*SqWt=swt->RtnAveSqWt();
	// Int4   swt->WtFactor(){ return 100; }
	// NilHSW(hsw);
#endif
	// 3. =============== Run SubSampling ==================
	Cut=1;	// number of instances in order to print...
	FILE *xfp=open_file(argv[1],".sprc","a");
	Int4 Num=0;
	if(SbSmplSize==0){
		Num=(Int4)ceil((double)NumSeqsCMSA(cma)/3.0);
		SbSmplSize=MINIMUM(Int4,Num,SizeInCCM);
	}
	if(SbSmplNum==0){ SbSmplNum=5; }
// SbSmplSize=2500; SbSmplNum=500;
       	// lsd_typ *lsd=drc2->SubSampleDCA(Cut,SbSmplSize,SbSmplNum,xfp); 
       	lsd_typ *lsd=this->SubSampleDCA(Cut,SbSmplSize,SbSmplNum,xfp); 
	FILE *pmlfp=0;
	Int4 **colpair=lsd->Put(xfp,pmlfp,0,0); delete lsd;

        if(0) {
	   fprintf(xfp,"##################### residue pair contributions to DC-score #####################\n");
           rdc_typ rdc(cma);
           for(Int4 i=1; colpair[1][i] != 0; i++){
                Int4 p,ii,jj,x=colpair[1][i],y=colpair[2][i];
                // assert(y > 0 && x > 0); rdc.Run(xfp,x,y);
                assert(y > 0 && x > 0); 
#if 1
		long double **scr=rdc.RunRtnLogP(xfp,x,y,i,swt);
		// fprintf(xfp,"\n  %d.(%d,%d):\n",i,x,y);
		fprintf(xfp,"\n\tID \tpdbid\tresI\tresJ\t status \tp-value\n");
		
		char ri,rj;
		for(p=1; p <= NumPdbID; p++){
			if(skip[p]) continue;	// new...
			ii=X2I[p][x]; jj=X2I[p][y]; 
			char cI=X2C[p][x],cJ=X2C[p][y];
			ri=AlphaCode(cI,AB); rj=AlphaCode(cJ,AB);
			if(cI==0) cI='-';
			if(cJ==0) cJ='-';
			long double	dd=0.0;
			if(rj > 0 && ri > 0){
			   dd=scr[ri][rj];
			   if(dd <= -2.0){	// not observed?.
				continue;
			   }else if(dd >= 2.0){	// Suppressed -underflow prob.
			     fprintf(xfp,"\t%d.%d\t%s\t%c%d\t%c%d\t reduced\t0.0\n",
				p,i,pdbID[p],cI,ii,cJ,jj);
			   } else if(dd <= -1.0){	// elevated underflow prob.
			     fprintf(xfp,"\t%d.%d\t%s\t%c%d\t%c%d\televated\t0.0\n",
				p,i,pdbID[p],cI,ii,cJ,jj);
			   } else if(dd < 0.0){	// suppressed & in range.
			     fprintf(xfp,"\t%d.%d\t%s\t%c%d\t%c%d\t reduced\t%.3Lg\n",
				p,i,pdbID[p],cI,ii,cJ,jj,-scr[ri][rj]);
			   } else {		// elevated & in range.
			     fprintf(xfp,"\t%d.%d\t%s\t%c%d\t%c%d\televated\t%.3Lg\n",
				p,i,pdbID[p],cI,ii,cJ,jj,scr[ri][rj]);
			   }
			} else {
			   fprintf(xfp,"\t%d.%d\t%s\t%c%d\t%c%d\tunchanged\t-\n", p,i,pdbID[p],cI,ii,cJ,jj);
			}
		} for(ri=0; scr[ri]; ri++) free(scr[ri]); free(scr);
#endif
           } 
        } free(colpair[1]); free(colpair[2]); free(colpair); 
free(skip);
	fprintf(xfp,"\n"); fclose(xfp);
	for(i=0; i < Argc; i++) free(Argv[i]);
	for(i=1; i <= NumPdbID; i++){ free(X2I[i]); free(X2C[i]); NilSet(SetXY[i]); }
	free(X2I); free(X2C); free(SetXY);
	TotalNilCMSA(cma); delete swt; 
	if(PassedInHSW) NilHSW(hsw);
	// if(drc2) delete drc2;
// long double LD=7.27e-47; fprintf(stderr,"log10l(%Lg)=%Lf\n",LD,log10l(LD));

	// for(i=1; pdbID[i]; i++) free(pdbID[i]);free(pdbID);   // freed by drc_typ
	NilAlpha(AB);
	return 0;
}

