/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

// # using namespace std;

#include "drc_typ.h"

extern "C" int run_ccmpred(int argc, char **argv);

#define USAGE "drc_sbsmpl <prefix> <reference_DC-scores> <int1> <int2> <int3>\n\
	 Input: \n\
	   <prefix>.mma = multiple sequence alignment (MSA)in cma format.\n\
	   <reference_DC-scores> = DARC *_fg_X output (DCA) file.\n\
	   List only those pairs sampled at least <int1> times.\n\
	   Sample <int2> of the sequences (with replacement) from the input mma.\n\
	   Sample these <int3> times (range: 2 to 1000).\n\\n"

lsd_typ	*drc_typ::SubSampleDCA(Int4 Cut, Int4 Size, Int4 Num, FILE *ofp)
#if 0
	Int4	Cut=1;		// cutoff to print score
	Int4	Size=1000;	// number of sequences to sample...
#endif
{
	Int4	arg,i,j,k,n,x,y,time1,nDC;
	char	*s,fstr[9002];
	double	d;

	time1=time(NULL); 
	Int4	L,Max,sqlen=0; 
	UInt4 seed=7061950;
	if(seed == 7061950)  seed = (UInt4) time(NULL)/2;
	sRandom(seed);

	//============ 1. Check arguments. ===========
	if(Cut < 1 || Cut > 100) print_error(USAGE);
	if(Size < 50 || Size > 10000) print_error(USAGE);
	if(Num < 2 || Num > 1000) print_error(USAGE);
	Int4 MinSepar=5;
	char cI,cJ;
	Int4 ii,jj,dm[12];
	Int4 SizeCCM=SizeInCCM;
	SizeInCCM=Size;
	UInt2 *x2i; 

#if 1	// replace with below...
	//============ 2. find the maximum and minimum residue positions from ref_dca  ===========
	if(Mode == 'B') sprintf(fstr,"%s_X",argv[1]); 
	else if(Mode == 'S') sprintf(fstr,"%s_sprc_X",argv[1]); 
	else sprintf(fstr,"%s_fg_X",argv[1]); 
	FILE *fp=open_file(fstr,"","r");
	for(Max=0,L=0; fgets(str,500,fp) != NULL; ){
	   if(sscanf(str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c",
                &ii,&jj,&d,&x,&y,&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&cI,&cJ) != 12){
			fprintf(stderr,"%d. --> %s",L,str);
			fprintf(stderr,"input file name --> %s\n",fstr);
                        print_error("SubSampleDCA score file input error 1.");
	   } Max=MAXIMUM(Int4,x,Max); Max=MAXIMUM(Int4,y,Max);
	   if(abs(ii-jj) >= MinSepar) L++;
	} fclose(fp); nDC=L; L=L*2;	// nDC = # of pairs in reference dca.

	//============ 1. map x2i; (columns to sequence positions) ===========
	sqlen=Max; NEW(x2i,sqlen +2,UInt2);
	set_typ SetXY=MakeSet(sqlen+2);
	fp=open_file(fstr,"","r");
	for( ; fgets(str,500,fp) != NULL; ){
	   if(sscanf(str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c",
                &ii,&jj,&d,&x,&y,&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&cI,&cJ) != 12)
                        print_error("SubSampleDCA score file input error 2.");
	   if(x2i[x]) assert(ii==x2i[x]); else x2i[x]=ii; 
	   if(x2i[y]) assert(jj==x2i[y]); else x2i[y]=jj;
	   AddSet(x,SetXY); AddSet(y,SetXY);
	} fclose(fp);
#else
	set_typ SetXY=this->MapX2I(Int4 *&x2i,char *&x2c);
#endif

	//============ 2. sample DC-scores =============
	lsd_typ *lsd=new lsd_typ(sqlen,Cut);
 	this->SubSample(Num,L,x2i,MinSepar,lsd,SetXY); NilSet(SetXY);

	//=========  3. read reference DC-score to map columns to sequence positions. ====
	FILE *rfp=open_file(fstr,"","r");
	for(k=0,j=1; fgets(str,500,rfp) != NULL; j++){
	   if(sscanf(str,"%d,%d,%lf,%d,%d,%d,%d,%d,%d,%d,%c,%c",
                &ii,&jj,&d,&x,&y,&dm[3],&dm[4],&dm[5],&dm[6],&dm[7],&cI,&cJ) != 12)
                        print_error("SubSampleDCA score file input error 3.");
	   if(abs(ii-jj) < MinSepar) continue;
	   lsd->AddToHeap(x,y,ii,jj,cI,cJ,d);
// fprintf(stderr,"DEBUG 4.3.%d(%d): %s\n",j,lsd->RtnNumInHeap(),str);
	} fclose(rfp);
// fprintf(stderr,"DEBUG 4.4: # in heap = %d\n",lsd->RtnNumInHeap());

	fprintf(ofp,"################### sub-sampling: %d seqs; %d samples; %d DC-pairs ###################\n\n",
					SizeInCCM,Num,nDC);
	if(Size != SizeInCCM){
	   fprintf(ofp,"  Sample size was too large; lowered from %d to %d\n",Size,SizeInCCM);
	} 
	SizeInCCM=SizeCCM; free(x2i);
#if 0
	Int4 **colpair=lsd->Put(ofp,pmlfp,chn,OS); delete lsd; 
	if(cmafile){
	  rdc_typ *rdc = new rdc_typ(cmafile);
	  for(i=1; colpair[1][i] != 0; i++){
		Int4 x=colpair[1][i],y=colpair[2][i];
		assert(y > 0 && x > 0); rdc->Run(ofp,x,y);
	  } delete rdc; 
	}
	free(colpair[1]); free(colpair[2]); free(colpair);
	fprintf(stderr,"\ttime: %d seconds (%0.2f minutes)\n",
                        time(NULL)-time1,(float)(time(NULL)-time1)/60.0);
	return 0;
#else
	return lsd;
#endif
}

Int4	drc_typ::SubSample(Int4 Num, Int4 L,UInt2 *x2i,Int4 MinSepar,lsd_typ *lsd, set_typ SetXY)
// Determine the degree to which DCA rankings of residue pairs depend on the input MSA.
// use _fg_X.dca as reference
{
	Int4	i,j,k,A,w,fnd,N;
	if(Mode=='B') sprintf(str,"%s",argv[1]); 
	else if(Mode=='S') sprintf(str,"%s",argv[1]); 
	else sprintf(str,"%s_fg",argv[1]); 

	a_type  AB=MkAlpha(AMINO_ACIDS,PROT_BLOSUM62);
	cma_typ cma=ReadCMSA2(str,AB); N=NumSeqsCMSA(cma); TotalNilCMSA(cma);
#if 1   // scale down Size...
        double d=(double)SizeInCCM/(double)N;
        if(d > 0.20){
           fprintf(stderr,"!!!!!!!!!!! WARNING: Subsample size (%d) is too large !!!!!!!!!!\n",
                        SizeInCCM);
           SizeInCCM= (Int4) floor((double)N/3.0);
           fprintf(stderr,"   --> reseting to %d sequences.\n",SizeInCCM);
        }
#endif
	assert(Num <= 10000);
	dh_type dH=dheap(L+2,4);
	for(i=1; i <= Num; i++){
	  if(Mode=='B'){ sprintf(str,"%s.in",argv[1]); }
	  else if(Mode=='S'){ sprintf(str,"%s_sprc.in",argv[1]); }
	  else { sprintf(str,"%s_fg.in",argv[1]); }
	  sprintf(str0,"%s_tmp.in",argv[1]); 
	  this->ReSizeInCCM(N,str,str0);
	  ArgV[3]=ArgV[4]=0; ArgV[0]=AllocString("ccmpred"); ArgC=1;
	  ArgV[ArgC]=AllocString("-t"); ArgC++;
	  sprintf(str,"%d",num_thrds); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_tmp.in",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
	  sprintf(str,"%s_tmp.dca",argv[1]); ArgV[ArgC]=AllocString(str); ArgC++;
	  run_ccmpred(ArgC,ArgV);  fflush(stdout); fflush(stderr);

// fprintf(stderr,"SizeInCCM=%d\n",SizeInCCM);
	  Int4	 ii,jj,x,y;
	  double d;
          sprintf(str,"%s_tmp.dca",argv[1]);
          FILE *fp=fopen(str,"r"); assert(fp != NULL);
	  UInt2 *Y,*X; 
          NEW(X,L+2,UInt2); NEW(Y,L+2,UInt2);
          for(k=1; fgets(Str,5000,fp) != NULL; k++){
                if(sscanf(Str,"%d %d %lf",&x,&y,&d) != 3) break;
                ii=x2i[x]; jj=x2i[y];
                if(abs(ii-jj) <= MinSepar) continue;
		if(!MemberSet(x,SetXY) || !MemberSet(y,SetXY)){ continue; }
                insrtHeap(k,-d,dH); Y[k]=y; X[k]=x;
          }
          for(j=0; !emptyHeap(dH); ){
                j++; d=minkeyHeap(dH); assert((k=delminHeap(dH)) != 0);
                x=X[k]; y=Y[k];
		fnd=lsd->IncXY(j,x,y);
		if(fnd==0){ while(delminHeap(dH) != 0) ; break; }
          } free(X); free(Y);
          fclose(fp);
	  for(A=0; A < ArgC; A++){ free(ArgV[A]); ArgV[A]=0; }
	} NilAlpha(AB);
        sprintf(str,"%s_tmp.in",argv[1]); remove(str);
        sprintf(str,"%s_tmp.dca",argv[1]); remove(str);
	Nildheap(dH);
	return 0;
}

