#if !defined (DRC_USAGE)
#define DRC_USAGE

#define DRC_VERSION "\
  ----------------------------------------------------\n\
     DARC v1.0.6 (November 14, 2019)\n\
     www.igs.umaryland.edu/labs/neuwald/software/darc/\n\
     Copyright 2019 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define SPRC_VERSION "\
  ----------------------------------------------------\n\
     SPARC v1.0.3 (October 17, 2019)\n\
     www.igs.umaryland.edu/labs/neuwald/software/sparc/\n\
     Copyright 2019 The University of Maryland\n\
     Freely distributed under the MIT License\n\
  ----------------------------------------------------\n"

#define USAGE_DARC "\
  Deep Analysis of Residue Constraints (DARC)\n\
  Usage: darc <prefix> <pdb_paths> [options]\n\
     Input: \n\
        <prefix>.mma multiple sequence alignment (MSA)in cma format.\n\
	   Because the first sequence in the MSA is typically a consensus, the \n\
	   second sequence serves as the query by default (but see -query option).\n\
	   Convert a fasta formatted MSA (with the consensus as the first sequence)\n\
	      into cma format using the faToCMA program.\n\
	<pdb_paths>: a file listing the paths to pdb coordinate files.\n\
	   Ideally, the coordinate files should include hydrogen atoms.\n\
	   Add hydrogens using either the h_add command within PyMOL or the Reduce program \n\
	      by J. Michael Word (http://kinemage.biochem.duke.edu/software/reduce.php\n\
          	 or https://github.com/rlabduke/reduce.git).\n\
	   Names of the coordinate files need to be based on their pdb identifiers\n\
		in lower case (e.g., 3glf) followed by '_H.pdb' (e.g., 3glf_H.pdb).\n\
     Most relevant output: \n\
	<prefix>.chk: BPPS checkpoint file (used to run bpps further along).\n\
	<prefix>_aln.rtf: rich text format 'contrast alignment' showing BPPS-defined patterns.\n\
	<prefix>_<int>.pml: pymol scripts for proteins of known structure included in sub-MSA.\n\
	<prefix>.darc: DARC output file containing:\n\
	     1.BPPS partitions and query subgroup distinguishing residue patterns.\n\
	     2.SIPRIS (mode='S') cluster analysis.\n\
	     (3. SubSamplng when -SbSmpl option is used.)\n\
	     3.High DC-scoring residue pairs (shown in PyMOL scripts).\n\
	     4.STARC S-scores for 3D structures (see reference 3).\n\
	<prefix>.sprs  SIPRIS input file (see reference 4).\n\
     Additional output: \n\
	<prefix>.hsw: sequence weighting (binary) file for BPPS.\n\
	<prefix>_fg query family (foreground) MSA (in cma format) as defined by BPPS.\n\
	<prefix>_fg_X.dca: CCMpred output file (input for STARC).\n\
	<prefix>_fg_X.mst: STARC input file.\n\
	<prefix>.paths: paths to pdb coordinate files for PyMOL scripts.\n\
     Temporary files: \n\
	<prefix>_fg.in: query-based foreground MSA in PSICOV format for CCMpred.\n\
	<prefix>_fg_X: EVcouplings formated DCA file (required by STARC).\n\
     Options: \n\
        -bpps	      Show BPPS input options\n\
	-SbSmpl=<int1>:<int2>=<pdbid> Run CCM subsamplng with <int1> samples of size <int2>.\n\
		Map to positions in pdbid (e.g., 3GLF_B) with path to coordinates given\n\
		in <pdb_paths> (note: <int1> range: 5-1000; <int2> range: 50-10000; \n\
		sample size needs to be < 1/3rd size of foregroud sequence set).\n\
	-dc=<int>     Number of highest DC-scoring pairs to be shown (range 0-100; default=25)\n\
	-D=<real>     Maximum distance (in Angstroms) defining residue contacts (default: 3.5)\n\
	-inCCM=<int>  Run CCM using <int> (>= 250) randomly chosen aligned sequences\n\
        -pdbaa=<str>  Retrieves pdbids for sequences in the MSA from NCBI pdbaa (path=<str>)\n\
	-query=<int>  Use the <int>th sequence as the query (<int> must be > 1; default=2)\n\
	-seed=<int>   Provide a seed for the random number generator\n\
	-thrds=<int>  Number of threads to be used for CCMpred (default: 1)\n\
     Steps performed by DARC:\n\
	1. Query-centric BPPS analysis (see reference 4).\n\
	2. SIPRIS analyis using BPPS output & structures in <pdb_paths> (see reference 4).\n\
	3. Direct coupling analsis (DCA) of the subalignment using the algorithm in referece 2.\n\
	4. STARC analysis on aligned sequences with coordinates in <pdb_paths> (see reference 3)\n\
	    Use NCBI identifiers (e.g., '3GLF_B') for PDB sequences in the MSA\n\
	    and name the coordinate files correspondingly as <ident>_H.pdb (e.g., 3glf_H.pdb)\n\
	5. PyMOL scripts showing BPPS residues & top scoring directly coupled (DC-)pairs.\n\
   References:\n\
     1.Tondnevis F., Dudenhausen E.E., Miller A.M., McKenna R., Altschul S.F., Bloom L.B. & Neuwald A.F.\n\
        2019. Deep Analysis of Residue Constraints (DARC): identifying determinants of protein \n\
        functional specificity. Submitted.\n\
     2.Seemayer S., Gruber M. & Söding J. CCMpred--fast and precise prediction of protein\n\
	residue-residue contacts from correlated mutations. Bioinformatics. 2014. 30(21):3128-30.\n\
     3.Neuwald, A.F. & Altschul S.F. 2018. Statistical Investigations of Protein Residue Direct\n\
        Couplings. PLoS Computational Biology 14(12):e1006237. PMID: 30596639.\n\
     4.Neuwald A.F., Aravind L. & Altschul S.F. 2018. Inferring Joint Sequence-Structural Determinants\n\
	of Protein Functional Specificity. eLife doi: 10.7554/eLife.29880.001. PMID: 29336305)\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
	General Medical Sciences grant R01GM125878.\n\
\n"

#define USAGE_DARC_PRIVATE "\
  Deep Analysis of Residue Constraints (DARC)\n\
  Usage: darc <prefix> <pdb_paths> [options]\n\
     Input: \n\
        <prefix>.mma multiple sequence alignment (MSA)in cma format.\n\
	   The first sequence in the MSA needs to be a consensus.\n\
	   The second sequence serves as a query sequence by default (but see -query option).\n\
	   Convert a Fasta formatted MSA into cma format using the faToCMA program.\n\
	<pdb_paths>: a file listing the paths to pdb coordinate files for pymol scripts.\n\
	   Ideally, the coordinate files should include hydrogen atoms.\n\
	   Add hydrogens using, for example, the Reduce program by J. Michael Word.\n\
     	   (http://kinemage.biochem.duke.edu/software/reduce.php\n\
          	 or https://github.com/rlabduke/reduce.git).\n\
	   Names of the listed coordinate files need to end in '_H.pdb' to be recognized.\n\
     Most relevant output: \n\
	<prefix>_aln.rtf: rich text format 'contrast alignment' showing BPPS-defined patterns.\n\
	<prefix>_<int>.pml: pymol scripts for proteins of known structure included in sub-MSA.\n\
	<prefix>.darc: DARC output file containing:\n\
	     1.BPPS partitions and query subgroup distinguishing residue patterns.\n\
	     2.SIPRIS (mode='S') cluster analysis.\n\
	     3.High DC-scoring residue pairs (shown in PyMOL scripts).\n\
	     4.STARC S-scores for 3D structures (see reference 3).\n\
	<prefix>.sprs  SIPRIS input file (see reference 4).\n\
	<prefix>.chk: BPPS checkpoint file (used to run bpps further along).\n\
     Additional output: \n\
	<prefix>.hsw: binary sequence weighting file for BPPS.\n\
	<prefix>_fg query family (foreground) MSA (in cma format) as defined by BPPS.\n\
	<prefix>_fg.in: query MSA in PSICOV format for CCMpred analysis.\n\
	<prefix>_fg_X.dca: CCMpred output file (input for STARC).\n\
	<prefix>_fg_X.mst: Additional STARC input file.\n\
	<prefix>_fg_X: EVcouplings formated DCA file (required by STARC).\n\
	<prefix>.paths: paths to pdb coordinate files for PyMOL scripts.\n\
     Options: \n\
	-BG           Subtract out background DC-scores; (_bg files are also created).\n\
	-SbSmpl=<int1>:<int2> Run CCM subsampling with <int1> samples of size <int2>\n\
			(note: <int1> range: 5-100; <int2> range: 250-10000)\n\
	-dc=<int>     Number of highest DC-scoring pairs to be shown (range 0-500; default=25)\n\
	-D=<real>     Maximum distance (in Angstroms) defining residue contacts (default: 3.5)\n\
	-inCCM=<int>  Run CCM using <int> (>= 250) randomly chosen aligned sequences\n\
        -pdbaa=<str>  Retrieve pdbids related to those in the MSA from NCBI pdbaa (path=<str>)\n\
	-query=<int>  Use the <int>th sequence as the query (<int> must be > 1; default=2)\n\
	-seed=<int>   Provide a seed for the random number generator\n\
	-thrds=<int>  Number of threads to be used for CCMpred (default: 1)\n\
        -bpps	      Show BPPS options\n\
     Steps performed by this program:\n\
	1. Query-centric BPPS.\n\
            Uses the 2nd sequence in the MSA (after a consensus sequence) as the query.\n\
	2. Direct coupling analsis (DCA) of the query subalignment using the CCMpred algorithm.\n\
	3. A STARC analysis using the PDB sequences in the sub-MSA and coordinates in <pdb_paths>.\n\
	    Use NCBI identifiers (e.g., '1A16_A') for PDB sequences in the MSA\n\
	    and name the coordinate files correspondingly as <ident>_H.pdb (e.g., 1a16_H.pdb)\n\
	    (The '_H.pdb' indicates that hydrogen atoms have been included.)\n\
	4. Creates PyMOL scripts showing BPPS residues & DCA pairs.\n\
   References:\n\
     1.Tondnevis F., Dudenhausen E.E., Miller A.M., McKenna R., Altschul S.F., Bloom L.B. & Neuwald A.F.\n\
        2019. Deep Analysis of Residue Constraints (DARC): identifying determinants of protein \n\
        functional specificity. Submitted.\n\
     2.Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction of protein\n\
	residue-residue contacts from correlated mutations. Bioinformatics 30(21):3128-30.\n\
     3.Neuwald, A.F. & Altschul S.F. 2018. Statistical Investigations of Protein Residue Direct\n\
        Couplings. PLoS Computational Biology 14(12):e1006237. PMID: 30596639.\n\
     4.Neuwald A.F., Aravind L. & Altschul S.F. 2018. Inferring Joint Sequence-Structural Determinants of \n\
	Protein Functional Specificity. eLife doi: 10.7554/eLife.29880.001. PMID: 29336305)\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
	General Medical Sciences grant R01GM125878.\n\
\n"

#define USAGE_SPARC "\
   Search Procedure for Analysis of Residue Constraints (SPARC)\n\
   Usage: sparc <infile> <pdb_directory> [options]\n\
   Input:  <infile> MSA in cma format with NCBI pdb ids for structural protein sequences\n\
           <pdb_directory> path to the pdb structural coordinate directory\n\
            Files in this directory need the syntax <pdbid>_H.pdb to be recognized\n\
             where <pdbid> is the lowercase version of the pdb identifier (e.g., '1abc').\n\
   Output: \n\
           <prefix>.sprc SPARC output file showing STARC S-scores.\n\
   Temporary output: \n\
           <prefix>_sprc_X.in  input aln file for CCMpred\n\
           <prefix>_sprc_X.mst input file for STARC algorithm\n\
           <prefix>_sprc_X.dca CCMpred output DCA file (input for STARC algorithm)\n\
           <prefix>_sprc_X file of DCA scores in EVC format\n\
   Options: \n\
      -D=<real>       Maximum distance (in Angstroms) between scored residue pairs (default: 3.0).\n\
      -I              Optimize over ICA P-values instead of unified P-values\n\
      -inCCM=<int>    Run CCMpred using <int> (>= 250) randomly chosen aligned sequences\n\
      -m=<int>        Minimum sequence separation between paired residues NOT YET IMPLEMENTED(default: 5)\n\
      -mds=<file>:<src> Score molecular dynamics simulation (MDS) structures (listed in <file>\n\
			where MDS are based on source pdb_id <src> (e.g., 3M0E)\n\
      -pdbaa=<str>    Retrieve pdbids related to those in the MSA from NCBI pdbaa (path=<str>)\n\
      -ptrn=<str>     BPPS search pattern for -mds option (path=<str>)\n\
      -sbsmpl=<int1>:<int2> Run CCM subsamplng with <int1> samples of size <int2>\n\
			(default: 5:1000); Note: <int1> range: 5-1000; <int2> range: 50-10000; \n\
		         sample size needs to be < 1/3rd size of foregroud sequence set.\n\
      -seed=<int>     Seed for random number generator\n\
      -thrds=<int>    Number of threads to use for CCMpred step (default: 1).\n\
   References:\n\
      Neuwald, A.F. & Altschul, S.F. 2018. Statistical Investigations of Protein Residue Direct\n\
        Couplings. PLoS Computational Biology 14(12):e1006237. PMID: 30596639.\n\
      Seemayer S., Gruber M. & Söding J. 2014. CCMpred--fast and precise prediction of protein\n\
	residue-residue contacts from correlated mutations. Bioinformatics 30(21):3128-30.\n\
      Neuwald, A.F. & Nixon, B.T. 2019. Determinants of bacterial enhancer-binding protein \n\
        functional specificity. submitted\n\
   Funding provided by the National Institutes of Health, National Institute of \n\
	General Medical Sciences grant R01GM125878.\n\
\n"

//      -v              Verbose output.\n\

#endif
