/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ***************************************************************************************/

#if !defined(_C2A_TYP_H_)
#define _C2A_TYP_H_

#include "sma.h"
#include "cmsa.h"
#include "residues.h"
#include "gpsi_typ.h"
#include "editcma.h"
#include "table.h"
#include "sset.h"
#include "wdigraph.h"
// #include "selexCMSA.h"
#include "dheap.h"
#include "swaln.h"
#include "tax_typ.h"
#include "set_typ.h"
#include "hat_typ.h"
#include "hpt_typ.h"

#define	USAGE_C2A_TYP_START	"USAGE: cma2aln <input_cma> [options]\n\
   Note: by default both the ccm input file and the mst file is created.\n\
   options:\n\
     -mst         ONLY create an mstarc alignment file for the NCBI pdb sequences (as <out_prefix>.mst).\n\
     -M=<int>     Ouput no more than <int> sequences for the ccm input file (<input_cma>.in).\n\
     -ccm         Create ONLY the ccm input file as <input_cma>.in\n\
     -pdb         ONLY show the pdb sequence ids within the input cma file (no files created)\n\
     -ptrn=<file> Read in a BPPS pattern file corresponding to the input cma files.\n\
     -T           test mode\n\
\n\n"

Int4	*PtrnStr2Ints(Int4 id, char *Str);

Int4	*RenumberList(FILE *fp, Int4 *list);

char	**run_cma2aln(Int4 argc,char *argv[],Int4 &NumIn,char *infile=0);

#endif
